<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Calculator extends CI_Controller {
	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }
    public function isAdminLoggedIn()
	{
        if($this->session->userdata('usertype') !== 'admin' && $this->session->userdata('usertype') !== 'staff')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Calculator';
		$data['staffs'] = $this->model->getResultData('staff',['is_suspended'=>0]);
		$data['offerings'] = $this->model->getResultData('offering',['is_disable'=>0]);
        $page = 'calculator/index';
        $this->header_and_footer($page, $data);
    }
	
	public function calculation_list()
    {
        $data['title'] = 'Calculation List';
        if($this->session->userdata('usertype') == 'staff'){
            $where=['t1.staff_id'=>$this->session->userdata('id')];
        }else{
            $where=['t1.staff_id'=>$_POST['staff_id']];
        }
		$data['list'] = $this->calculator_model->getCalculatorResultData($where);
        $page = 'calculator/tb';
        $this->header_and_footer($page, $data);
    }

    public function calculatePricing()
    {
        $data = '';$total_ticket_price=0;
        if($this->session->userdata('usertype') == 'staff'){
            $staff_id=$this->session->userdata('id');
        }else{
            $staff_id=$_POST['staff_id'];
        }

        //add data in calculator table
        $calculator_array = array(
            'staff_id' => $staff_id,
        );
        $this->model->add('calculator',$calculator_array);
        $calculator_id = $this->db->insert_id();

        // foreach($_POST['offering_id'] as $offering_id) {
        for ($i = 0; $i < count($_POST['offering_id']); $i++) {
            $offering_id = $_POST['offering_id'][$i];
            $currency = $_POST['currency'][$i];
            $type = $_POST['type_'.($i+1).''];

            $offeringData = $this->model->getRowData('offering',['id'=>$offering_id]);

            if($currency == 'INR'){
                $offering_price = $offeringData['inr_hourly_rate'];
                if($type == 'Regular'){
                    $price = $offeringData['inr_hourly_rate'];
                }else if($type == 'Premium'){
                    $offer_price = ($offeringData['inr_hourly_rate']*50)/100;
                    $price = $offeringData['inr_hourly_rate'] + $offer_price;
                }else if($type == 'High Ticket'){
                    $price = $offeringData['inr_hourly_rate'] + $offeringData['inr_hourly_rate'];
                }
            }else if($currency == 'USD'){
                $offering_price = $offeringData['usd_hourly_rate'];
                if($type == 'Regular'){
                    $price = $offeringData['usd_hourly_rate'];
                }else if($type == 'Premium'){
                    $offer_price = ($offeringData['usd_hourly_rate']*50)/100;
                    $price = $offeringData['usd_hourly_rate'] + $offer_price;
                }else if($type == 'High Ticket'){
                    $price = $offeringData['usd_hourly_rate'] + $offeringData['usd_hourly_rate'];
                }
            }
            $total_ticket_price+=$price;

            $calculator_offerings_array = array(
                'calculator_id' => $calculator_id,
                'currency' => $currency,
                'type' => $type,
                'offering_id' => $offering_id,
                'offering_price' => $offering_price,
                'ticket_price' => $price,
            );

            $this->model->add('calculator_offerings',$calculator_offerings_array);

            //print calculation table row
            $data.='
                <tr>
                    <td>'.$offeringData['name'].'</td>
                    <td>'.$currency.'</td>
                    <td>'.$type.'</td>
                    <td>'.$price.'</td>
                </tr>
            ';
        }
        $data.='
                <tr>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td>'.$total_ticket_price.'</td>
                </tr>
            ';
        echo $data;


    }

    public function calculatorOfferingData()
    {
        $list = $this->calculator_model->getCalculatorOfferingsResultData($_POST['calculator_id']);
        $total_ticket_price = 0.00;$data='';
        foreach($list as $val) {
            $offeringData = $this->model->getRowData('offering',['id'=>$val['offering_id']]);
            $total_ticket_price+=$val['ticket_price'];
            $data.='
                <tr>
                    <td>'.$offeringData['name'].'</td>
                    <td>'.$val['currency'].'</td>
                    <td>'.$val['type'].'</td>
                    <td>'.$val['ticket_price'].'</td>
                </tr>
            ';
        }
        $data.='
                <tr>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td>'.$total_ticket_price.'</td>
                </tr>
            ';
        echo $data;


    }
	
   	
}
