
        <!-- Page title -->
        <section id="page-title">
            <div class="container">
                <div class="page-title">
                    <h1>Available Turfs</h1>
                    <span>Check Available Turfs from list</span>
                </div>
                <div class="breadcrumb">
                    <ul>
                        <li><a href="index.php">Home</a> </li>
                        <li class="active"><a href="#">Turfs</a> </li>
                    </ul>
                </div>
            </div>
        </section>
        <!-- end: Page title -->
        <!-- Section -->
        <section>
            <div class="container">
                <!--Team members -->
                <div class="heading-text heading-line text-center">
                    <!--<h4>Team members</h4>-->
                </div>
                <div class="row team-members m-b-40">
                    <?php foreach($turfs as $turf){ ?>
                    <div class="col-lg-3">
                        <div class="team-member">
                            <div class="team-image">
                                <img src="<?= turfCoverImage($turf['id']);?>">
                            </div>
                            <div class="team-desc">
                                <a href="<?= base_url('turf-slots/'.$turf['id'].''); ?>"><h4><?= $turf['turf_name']; ?></h4></a>
                                <span><?= $turf['turf_location'].','.$turf['city_name']; ?></span>
                                <p>Facilities: <?= $turf['turf_details']; ?></p>
                                <div class="align-center">
                                    <?php if($turf['fb_link']){ ?>
                                    <a class="btn btn-xs btn-slide btn-light" href="<?= $turf['fb_link']; ?>" target="_blank">
                                        <i class="fab fa-facebook-f"></i>
                                        <span>Facebook</span></a>
                                    <?php } ?>

                                    <?php if($turf['linkedin_link']){ ?>
                                    <a class="btn btn-xs btn-slide btn-light" href="<?= $turf['linkedin_link']; ?>" data-width="100" target="_blank">
                                        <i class="fab fa-linkedin"></i>
                                        <span>Linkedin</span></a>
                                    <?php } ?>

                                    <?php if($turf['insta_link']){ ?>
                                    <a class="btn btn-xs btn-slide btn-light" href="<?= $turf['insta_link']; ?>" data-width="118" target="_blank">
                                        <i class="fab fa-instagram"></i>
                                        <span>Instagram</span></a>
                                    <?php } ?>

                                    <?php if($turf['web_link']){ ?>
                                    <a class="btn btn-xs btn-slide btn-light" href="<?= $turf['web_link']; ?>" data-width="80" target="_blank">
                                        <i class="icon-globe"></i>
                                        <span>Website</span></a>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                </div>
                <!--END: Team members -->
                
            </div>
        </section>
        <div class="container-fluid">
            
        </div>
        <hr class="space">
        