        <!-- Captions -->
        <section>
            <div class="container">
                <h2 class="fw-400 m-b-0">Sports is great way to excercise.</h2>
                <h2 class="fw-400">Play <span class="text-rotator fw-700" data-animation="flash" data-speed="3000">Box Cricket.,Box Football.</span></h2>
            </div>
        </section>
        <!-- end: Captions -->

        
        <!-- PORTFOLIO -->
        <section>
        <div class="container">
            <h5>Check Availability (Blue = Available / Grey = Booked)</h5>
            <div class="row">
                <div class="col-lg-12">
                    <!-- Loop through the slots and create buttons for each -->
                    <?php foreach($turf_slots as $turf_slot){
                        if(checkTurfSlotBooked($this->uri->segment(2),$turf_slot['id'])){
                        ?>
                        <button type="button" class="btn btn-outline btn-roundeded slot-button" data-slot-id="<?= $turf_slot['id']; ?>">
                            <?= $turf_slot['slot_name']; ?>
                        </button>
                        <?php }else{ ?>

                            <button id="bookedSlotButton" data-slot-id="<?= $turf_slot['id']; ?>" type="button" class="btn btn-roundeded btn-light" data-container="body" data-toggle="popover" data-bs-placement="top" title="" data-bs-original-title="This slot is already booked" fdprocessedid="vfg89t" aria-describedby="popover755493"> <?= $turf_slot['slot_name']; ?></button>

                        </button>
                        <?php } ?>
                    <?php } ?>
                </div>
            </div>
            <div class="row mt-3">
                <div class="col-lg-12">
                    <h5>Total Price: <span id="totalPrice">0</span></h5>
                </div>
            </div>
            <div class="row mt-3">
                <div class="col-lg-12">
                    <?php if(get_cookie('user_id')){ ?>
                        <button id="bookNowButton" type="button" class="btn btn-primary" disabled>Book Now</button>
                        <button id="popoverButton" type="button" class="btn btn-primary" data-container="body" data-toggle="popover" data-bs-placement="right" title="" data-content="Vivamus sagittis lacus vel augue laoreet rutrum faucibus." data-bs-original-title="Please select the slot to continue" fdprocessedid="vfg89t" aria-describedby="popover755493" style="display:none;">Book Now</button>
                        
                    <?php }else{ ?>
                        <a href="javascript:void(0)" onclick="bookNowLoginAlert()" class="btn btn-primary" disabled>Book Now</a>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>
        <!-- end: PORTFOLIO -->

        <!-- Testimonial -->
        <section>
            <div class="container">
                <!-- Heading -->
                <div class="text-center">
                    <h3 class="fw-100">Our awesome clients.</h3>
                    <p>just a few words from them...</p>
                </div>
                <!-- end: Heading -->

                <!-- Testimonials -->
                <div class="carousel testimonial testimonial-box" data-items="3" data-margin="30" data-arrows="false">
                    <!-- Testimonials item -->
                    <div class="testimonial-item">
                        <img src="<?= base_url('website_assets/images/team/6.jpg');?>" alt="">
                        <p>Polo is by far the most amazing template out there! I literally could not be happier that I chose to buy this template!</p>
                        <span>Alan Monre</span>
                        <span>CEO, Square Software.</span>
                    </div>
                    <!-- end: Testimonials item-->
                    <!-- Testimonials item -->
                    <div class="testimonial-item">
                        <img src="<?= base_url('website_assets/images/team/7.jpg');?>" alt="">
                        <p>Polo is by far the most amazing template out there! I literally could not be happier that I chose to buy this template!</p>
                        <span>Resa Smith</span>
                        <span>Developer @Apple.inc</span>
                    </div>
                    <!-- end: Testimonials item-->
                    <!-- Testimonials item -->
                    <div class="testimonial-item">
                        <img src="<?= base_url('website_assets/images/team/8.jpg');?>" alt="">
                        <p>Polo is by far the most amazing template out there! I literally could not be happier that I chose to buy this template!</p>
                        <span>Alan Monre</span>
                        <span>CEO, Square Software.</span>
                    </div>
                    <!-- end: Testimonials item-->
                    <!-- Testimonials item -->
                    <div class="testimonial-item">
                        <img src="<?= base_url('website_assets/images/team/9.jpg');?>" alt="">
                        <p>Polo is by far the most amazing template out there! I literally could not be happier that I chose to buy this template!</p>
                        <span>Resa Smith</span>
                        <span>Developer @Apple.inc</span>
                    </div>
                    <!-- end: Testimonials item-->
                    <!-- Testimonials item -->
                    <div class="testimonial-item">
                        <img src="<?= base_url('website_assets/images/team/10.jpg');?>" alt="">
                        <p>Polo is by far the most amazing template out there! I literally could not be happier that I chose to buy this template!</p>
                        <span>Lulla Smith</span>
                        <span>CEO @Verso.</span>
                    </div>
                    <!-- end: Testimonials item-->
                    <!-- Testimonials item -->
                    <div class="testimonial-item">
                        <img src="<?= base_url('website_assets/images/team/11.jpg');?>" alt="">
                        <p>Polo is by far the most amazing template out there! I literally could not be happier that I chose to buy this template!</p>
                        <span>Ariol Perry</span>
                        <span>Creative Designer.</span>
                    </div>
                    <!-- end: Testimonials item-->

                </div>
                <!-- end: Testimonials -->
            </div>
        </section>
        <!-- end: Testimonial -->

        <script src="https://checkout.razorpay.com/v1/checkout.js"></script>


        <script>
            $(document).ready(function() {
    var selectedSlots = [];

    // Initial check on page load
    updateButtonState();

    // Handle slot button click
    $('.slot-button').on('click', function() {
        var slotId = $(this).data('slot-id');
        var isSelected = $(this).hasClass('btn-primary');

        if (isSelected) {
            // Deselect the slot
            $(this).removeClass('btn-primary');
            selectedSlots = selectedSlots.filter(id => id !== slotId);
        } else {
            // Select the slot
            $(this).addClass('btn-primary');
            selectedSlots.push(slotId);
        }

        // Update button state based on slot selection
        updateButtonState();

        // Fetch and display the total price
        fetchTotalPrice();
    });

    // Function to update the state of the 'Book Now' button
    function updateButtonState() {
        if (selectedSlots.length === 0) {
            $('#bookNowButton').prop('disabled', true).hide();
            $('#popoverButton').show(); // Show the popover button when Book Now is disabled
        } else {
            $('#bookNowButton').prop('disabled', false).show();
            $('#popoverButton').hide(); // Hide the popover button when Book Now is enabled
        }
    }

    // Function to fetch the total price
    function fetchTotalPrice() {
        if (selectedSlots.length > 0) {
            $.ajax({
                url: "<?php echo base_url('turf_booking/fetchAmount'); ?>",
                method: "POST",
                data: { time_slot_ids: selectedSlots },
                dataType: 'json',
                success: function(res) {
                    $('#totalPrice').text(res.total_amount);
                },
                error: function(xhr, status, error) {
                    console.error('Error:', error);
                    toastr.error('An error occurred while fetching the total price.');
                }
            });
        } else {
            $('#totalPrice').text(0);
        }
    }

    // Handle 'Book Now' button click
    $('#bookNowButton').on('click', function() {
        if (selectedSlots.length === 0) {
            $('#popoverButton').popover('show');
        } else {
            var totalPrice = $('#totalPrice').text();

            // Initialize Razorpay payment
            var options = {
                "key": "rzp_test_px4WRkJe1zY98p", // Enter the Key ID generated from the Razorpay Dashboard
                "amount": totalPrice * 100, // Convert to paise
                "currency": 'INR',
                "name": "Turf Booking",
                "description": "Booking Payment",
                "handler": function(response) {
                    confirmBooking(response, selectedSlots, totalPrice);
                },
                "modal": {
                    "ondismiss": function() {
                        location.reload();
                    }
                },
                "prefill": {
                    "name": "<?= webLoggedUserData()['name']; ?>",
                    "email": "<?= webLoggedUserData()['email']; ?>",
                    "contact": "<?= webLoggedUserData()['mobile']; ?>",
                },
                "theme": {
                    "color": "#F37254"
                }
            };

            var rzp1 = new Razorpay(options);
            rzp1.open();
        }
    });

    // Function to confirm booking after successful payment
    function confirmBooking(paymentResponse, selectedSlots, totalPrice) {
        $.ajax({
            url: "<?php echo base_url('website/bookSlot'); ?>",
            method: "POST",
            data: {
                time_slot_id: selectedSlots, 
                amount: totalPrice,
                turf_id: '<?= $this->uri->segment(2); ?>',
                razorpay_payment_id: paymentResponse.razorpay_payment_id,
            },
            dataType: 'json',
            success: function(res) {
                if (res.return) {
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: res.msg,
                        showConfirmButton: false,
                        timer: 2500
                    });
                    setTimeout(function() {
                        location.reload();
                    }, 2000);
                } else {
                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: res.msg,
                        showConfirmButton: false,
                        timer: 2500
                    });
                }
            },
            error: function(xhr, status, error) {
                console.error('Error:', error);
                toastr.error('An error occurred while confirming the booking.');
            }
        });
    }


    // Handle popover button click (if needed)
    $('#popoverButton').on('click', function() {
        $(this).popover('show');
    });

    // Hide popover when clicking anywhere else
    $(document).on('click', function(e) {
        if (!$(e.target).closest('#popoverButton').length) {
            $('#popoverButton').popover('hide');
        }
        if (!$(e.target).closest('#bookedSlotButton').length) {
            $('#bookedSlotButton').popover('hide');
        }
    });
});

    // Function to redirect to login if not logged in
    function bookNowLoginAlert() {
        Swal.fire({
            position: 'center',
            icon: 'info',
            title: 'Please login to your account',
            showConfirmButton: false,
            timer: 2500
        });
        setTimeout(function() {
            window.location.href = "<?= base_url('user-login/booking/'.$this->uri->segment(2).''); ?>";
        }, 3000);
    }
        </script>