
    <!-- Body Inner -->
    <div class="body-inner">
        <div class="container-fluid">
            <div class="row min-vh-100">
                <div class="col-md-8 col-lg-7 d-flex align-items-center">
                    <div class="w-100 px-3 px-sm-5 px-xl-7">
 
                            <div class="mb-5"><h6 class="h3 mb-1">Welcome back!</h6><p class="text-muted mb-0">Login to manage your account.</p></div>
                                <div class="col-md-12 mb-2">
                                    <span class="text-success success" style="display:none;"></span>
                                    <span class="text-danger error" style="display:none;"></span>
                                </div>
                                <!--Mobile form-->  
                                <div id="mobile-form">
                                    <div class="form-group">
                                        <div class="input-group">
                                            <input type="number" class="form-control" name="mobile" id="mobile" placeholder="Enter your mobile" required="">
                                            <span class="input-group-text"><i class="icon-phone"></i></span>
                                        </div>
                                    </div>
                                    <div class="mt-4"><button type="button" class="btn btn-primary btn-block btn-primary" id="mobile-btn">Get OTP</button>
                                    </div>
                                </div>
                                <!--Otp form-->  
                                <div id="otp-form" style="display:none">
                                    <div class="form-group">
                                        <div class="input-group">
                                            <input type="number" class="form-control" name="otp_mobile" id="otp_mobile" readonly>
                                            <span class="input-group-text"><i class="icon-phone"></i></span>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="input-group">
                                            <input type="number" class="form-control" name="otp" id="otp" placeholder="Enter otp">
                                            <span class="input-group-text"><i class="icon-key"></i></span>
                                        </div>
                                    </div>
                                    <div class="mt-4"><button type="button" class="btn btn-primary btn-block btn-primary" id="otp-btn">Verify</button>
                                    </div>
                                </div>
                                <!--Signup form-->  
                                <div id="user-detail-form" style="display:none">
                                    <div class="form-group">
                                        <div class="input-group">
                                            <input type="text" class="form-control" name="fullname" id="fullname" placeholder="Fullname">
                                            <span class="input-group-text"><i class="icon-user"></i></span>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="input-group">
                                            <input type="email" class="form-control" name="email" id="email" placeholder="Enter email">
                                            <span class="input-group-text"><i class="icon-mail"></i></span>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="input-group">
                                            <input type="number" class="form-control" name="user_mobile" id="user_mobile" readonly>
                                            <span class="input-group-text"><i class="icon-phone"></i></span>
                                        </div>
                                    </div>
                                    <div class="mt-4">
                                        <button type="button" class="btn btn-primary btn-block btn-primary" id="register-btn">
                                            <span id="sign-up">Sign up</span>
                                            <span id="sign-up-loader" style="display: none;">
                                                <i class="fa fa-circle-o-notch fa-spin"></i> Loading...
                                            </span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                </div>
                <div class="col-md-4 col-lg-5 d-none d-md-block bg-cover" style="background-image: url(<?= base_url('website_assets/images/login2.png') ?>);">
                    <a href="<?= base_url(); ?>" class="btn btn-white btn-rounded-only btn-rounded position-absolute left-4 top-4" data-bs-toggle="tooltip" data-bs-placement="right" title="" data-bs-original-title="Go back Homepage"><i class="icon-home"></i></a>
                </div>
            </div>
        </div>
    </div>
    <!-- end: Body Inner -->
    <script>
        //generate OTP
$("#mobile-btn").click(function(e){
    e.preventDefault();
    $.ajax({
        url: '<?= base_url('user_auth/generateOtp');?>',
        type: 'post',
        data: {mobile:$('#mobile').val()},
        dataType: 'json',
        beforeSend: function() {
                    $("#mobile-btn").attr("disabled", true);
                    $("#mobile-btn").html("Generating...");
                }, 
        success: function(res) {
                    if(res.return == true){
                        $(".error").hide();
                        $('#mobile-btn').removeAttr("disabled");
                        $('#mobile-btn').html("Get otp");
                        
                        $('#otp-btn').html("Verify"+res.msg);
                        $('#otp_mobile').val($('#mobile').val());
                        $("#mobile-form").slideUp();
                        $("#otp-form").fadeIn();
                    }else{
                        $('#mobile-btn').removeAttr("disabled");
                        $('#mobile-btn').html("Get otp");
                        
                        $(".error").show();
                        $(".error").html(res.msg);

                    }          
                },
        error: function (response) {
            
            $(".error").show();
            $(".error").html('<i class="fas fa-times text-danger"></i>&nbsp;Something went wrong!!');
            $('#mobile-btn').removeAttr("disabled");
            $('#mobile-btn').html("Verify");
                }
    });
});
//Verify otp
$("#otp-btn").click(function(e){
    e.preventDefault();
    $.ajax({
        url: '<?= base_url('user_auth/verifyOtp');?>',
        type: 'post',
        data: {mobile:$('#mobile').val(),otp:$('#otp').val()},
        dataType: 'json',
        beforeSend: function() {
                    $("#otp-btn").attr("disabled", true);
                    $("#otp-btn").html("Verifying...");
                }, 
        success: function(res) {
                    if(res.return == true){   
                        if(res.is_exist == 'no')
                        {
                            $(".error").hide();                         
                            $("#otp-form").slideUp();
                            $("#user-detail-form").fadeIn();
                            $("#user_mobile").val($('#mobile').val());
                        }
                        else
                        {
                            UserLogin();
                        }
                    }else{
                        $('#otp-btn').removeAttr("disabled");
                        $('#otp-btn').html("Verify");
                        
                        $(".error").show();
                        $(".error").html('<i class="fas fa-times text-danger"></i>&nbsp;'+res.msg);
                    }          
                },
        error: function (response) {
            $(".error").show();
            $(".error").html('<i class="fas fa-times text-danger"></i>&nbsp;Something went wrong!!');
            $('#otp-btn').removeAttr("disabled");
            $('#otp-btn').html("Verify");
                }
    });
});
$("#register-btn").click(function(e){
    var fullname = $('#fullname').val();
    var email = $('#email').val();
    var mobile = $('#user_mobile').val();
    $.ajax({
      type: "POST",
      url : "<?= base_url('user_auth/submitRegister');?>",
      dataType: "JSON",
      data : "fullname="+fullname+"&email="+email+"&mobile="+mobile,
      cache : false,
      beforeSend: function() {
        $("#sign-up").hide();
        $("#sign-up-loader").show();
        $("#sign-up-button").attr("disabled",true);       
    }, 
      success: function(res)
      {
        if(res.return)
        {
            $(".error").hide();
            $("#success").show();
            $("#sign-up-loader").html('<i class="fa fa-circle-o-notch fa-spin"></i> Redirecting...');
            setTimeout(function(){
                window.location = "<?= base_url(); ?>";
            },2000);
        }
        else
        {
            $(".error").show();
            $(".error").html(res.msg);
            $("#success").hide();
            $("#sign-up").show();
            $("#sign-up-loader").hide();
            $("#sign-up-button").removeAttr("disabled"); 
        }
      },
      error: function (jqXHR, exception) {
        var msg = '';
        if (jqXHR.status === 0) {
            msg = 'Not connect.\n Verify Network.';
        } else if (jqXHR.status == 404) {
            msg = 'Requested page not found. [404]';
        } else if (jqXHR.status == 500) {
            msg = 'Internal Server Error [500].';
        } else if (exception === 'parsererror') {
            msg = 'Requested JSON parse failed.';
        } else if (exception === 'timeout') {
            msg = 'Time out error.';
        } else if (exception === 'abort') {
            msg = 'Ajax request aborted.';
        } else {
            msg = 'Uncaught Error.\n' + jqXHR.responseText;
        }
        $(".error").show();
        $(".error").html(res.msg);
    },
    });
});
function UserLogin()
{
    var turf_id = '<?= $turf_id; ?>';
    if('<?= $type; ?>' == 'booking'){
        var url = '<?= base_url('user_auth/UserLogin/checkout');?>';
    }else{
        var url = '<?= base_url('user_auth/UserLogin');?>'
    }
    var mobile = $('#mobile').val();
    $.ajax({
      type: "POST",
      url : url,
      dataType: "JSON",
      data : {
          'mobile':mobile,
      },
      cache : false,
      beforeSend: function() {
        $("#otp-btn").attr("disabled",true);    
        $("#otp-btn").html('Loading..');      
    }, 
      success: function(res)
      {
        if(res.return)
        {
            $(".error").hide();
            $("#success").show();
            $("#otp-btn").html('<i class="fa fa-circle-o-notch fa-spin"></i> Redirecting...');
            setTimeout(function(){
                if('<?= $this->uri->segment(2); ?>' == 'booking'){
                    window.location.href = "<?= base_url('turf-slots/'); ?>"+turf_id;
                }else{
                    window.location.href = "<?= base_url('turfs'); ?>";
                }
                
            },2000);
        }
        else
        {
            $(".error").show();
            $(".error").html(res.msg);
            $("#success").hide();
            $("#otp-btn").removeAttr("disabled"); 
            $("#otp-btn").html('Verify');      
        }
      },
      error: function (jqXHR, exception) {
        var msg = '';
        if (jqXHR.status === 0) {
            msg = 'Not connect.\n Verify Network.';
        } else if (jqXHR.status == 404) {
            msg = 'Requested page not found. [404]';
        } else if (jqXHR.status == 500) {
            msg = 'Internal Server Error [500].';
        } else if (exception === 'parsererror') {
            msg = 'Requested JSON parse failed.';
        } else if (exception === 'timeout') {
            msg = 'Time out error.';
        } else if (exception === 'abort') {
            msg = 'Ajax request aborted.';
        } else {
            msg = 'Uncaught Error.\n' + jqXHR.responseText;
        }
        $(".error").show();
        $(".error").html(res.msg);
    },
    });
};
    </script>