

  <main id="main" class="main">

    <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card">
              <div class="card-header mb-4">
                <div class="row">
                  <div class="col-sm-6">
                    <h4 class="text-dark"><?= $title; ?></h4>
                  </div>
                  <div class="col-sm-6" style="text-align: right;">
                    <button class="btn btn-success rounded add-btn" type="button" onclick="add()"><i class="bi bi-plus"></i> Add <?= $title; ?></button>
                  </div>
                 </div>

            </div>
            <div class="card-body">
              <!-- Table with stripped rows -->
              <div class="table-responsive" id="tb">
                    </div>
              <!-- End Table with stripped rows -->

            </div>
          </div>

        </div>
      </div>
    </section>

  </main><!-- End #main -->
   <!-- Add Modal -->
        <div class="modal fade modal-bookmark" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="row g-3" id="add-form">
                  <div class="col-md-12">
                    <label class="form-label">Fullname</label>
                    <input type="text" class="form-control" id="fullname" name="fullname">
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">Mobile</label>
                    <input type="text" pattern="[1-9]{1}[0-9]{9}" title="Enter 10 digit contact number" maxlength="10" class="form-control" id="mobile" name="mobile">
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">Email</label>
                    <input type="email" class="form-control" id="email" name="email">
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">Gender</label>
                    <select class="form-select" name="gender" id="gender">
                      <option value="">Select</option>
                      <option value="Male">Male</option>
                      <option value="Female">Female</option>
                      <option value="Other">Other</option>
                    </select>
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">DOB</label>
                    <input type="date" class="form-control" id="dob" name="dob">
                  </div>
                  <div class="col-md-4">
                    <label class="form-label">Country</label>
                    <select name="country" class="form-control" id="country" onchange="fetch_state(this.value)">
                        <option value="">Select Country</option>
                        <?php foreach($countries as $country){ ?>
                          <option value="<?= $country['id']; ?>" required><?= $country['name']; ?></option>
                        <?php } ?>
                    </select>                   
                  </div>
                  <div class="col-md-4">
                    <label class="form-label">State</label>
                    <select name="state" class="state form-control" id="state" onchange="fetch_city(this.value)">
                    </select>                    
                  </div>
                  <div class="col-md-4">
                    <label class="form-label">City</label>
                    <select name="city" class="city form-control" id="city">
                    </select>                 
                  </div>
                  <div class="col-12">
                    <label class="form-label">Address</label>
                    <textarea class="form-control" id="address" name="address"></textarea>
                  </div>
                  <div class="text-left">
                    <button type="submit" class="btn btn-primary">Save</button>
                    <button type="reset" class="btn btn-danger">Reset</button>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>

      <!-- Edit Modal -->
      <div class="modal fade modal-bookmark" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="row g-3" id="edit-form">
                  <div class="col-md-12">
                    <label class="form-label">Fullname</label>
                    <input type="text" class="form-control" id="e_fullname" name="fullname">
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">Mobile</label>
                    <input type="text" pattern="[1-9]{1}[0-9]{9}" title="Enter 10 digit contact number" maxlength="10" class="form-control" id="e_mobile" name="mobile">
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">Email</label>
                    <input type="email" class="form-control" id="e_email" name="email">
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">Gender</label>
                    <select class="form-select" name="gender" id="e_gender">
                      <option value="">Select</option>
                      <option value="Male">Male</option>
                      <option value="Female">Female</option>
                      <option value="Other">Other</option>
                    </select>
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">DOB</label>
                    <input type="date" class="form-control" id="e_dob" name="dob">
                  </div>
                  <div class="col-md-4">
                    <label class="form-label">Country</label>
                    <select name="country" class="form-control" id="e_country" onchange="fetch_state(this.value)">
                        <option value="">Select Country</option>
                        <?php foreach($countries as $country){ ?>
                          <option value="<?= $country['id']; ?>" required><?= $country['name']; ?></option>
                        <?php } ?>
                    </select>                   
                  </div>
                  <div class="col-md-4">
                    <label class="form-label">State</label>
                    <select name="state" class="state form-control" id="e_state" onchange="fetch_city(this.value)">
                    </select>                    
                  </div>
                  <div class="col-md-4">
                    <label class="form-label">City</label>
                    <select name="city" class="city form-control" id="e_city">
                    </select>                 
                  </div>
                  <div class="col-12">
                    <label class="form-label">Address</label>
                    <textarea class="form-control" id="e_address" name="address"></textarea>
                    <input type="hidden" name="id" id="e_id">
                  </div>
                  <div class="text-left">
                    <button type="submit" class="btn btn-primary">Save</button>
                    <button type="reset" class="btn btn-danger">Reset</button>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
<script>
  function add()
  {
    $('#addModal').modal('toggle'); 
    $('#add-form')[0].reset();
    $('#city').find('option:not(:first)').remove();
    $('#state').find('option:not(:first)').remove();
  }
$(document).ready(function(){  
$("#tb").html('<div class="text-center"><img src="loader.gif"></div>')
  $('#addModal').modal({
           backdrop: 'static',
           keyboard: false
    })
    $('#editModal').modal({
           backdrop: 'static',
           keyboard: false
    })
  $('#tb').load('<?= base_url('user/viewUser'); ?>');
});


$("#add-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('user/addUser'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#addModal').modal('toggle'); 
          $('#add-form')[0].reset();
          $('#tb').load('<?= base_url('user/viewUser'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
        
      }
  });
})

  function fetch_state(country_id,state_id) {
    $.ajax({
      url: "<?= base_url('dashboard/fetch_state'); ?>",
      method: "POST",
      data: {
        country_id: country_id,
        state_id: state_id
      },
      success: function(data) {
        if(state_id == null)
        {
          $(".state").html(data);
        }
        else
        {
          $("#e_state").html(data);
        }
      },
    });
  }
  function fetch_city(state_id,city_id) {
    $.ajax({
      url: "<?= base_url('dashboard/fetch_city'); ?>",
      method: "POST",
      data: {
        state_id: state_id,
        city_id: city_id
      },
      success: function(data) {
        if(city_id == null)
        {
          $(".city").html(data);
        }
        else
        {
          $("#e_city").html(data);
        }
      },
    });
  }
function editData(id)
{
  $.ajax({
      url: "<?= base_url('user/editUser'); ?>",
      method: "POST",
        dataType: 'json',
      data: {
          id:id
      },
      success:function(res){
          fetch_state(res.country,res.state);
          fetch_city(res.state,res.city);
          $("#e_id").val(res.id);
          $("#e_fullname").val(res.fullname);
          $("#e_mobile").val(res.mobile);
          $("#e_gender").val(res.gender);
          $("#e_email").val(res.email);
          $("#e_dob").val(res.dob);
          $("#e_country option[value='"+res.country+"']").attr("selected", "selected");
          $("#e_address").val(res.address);
      }
  });
};
$("#edit-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('user/updateUser'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#editModal').modal('toggle'); 
          $('#edit-form')[0].reset();
          $('#tb').load('<?= base_url('user/viewUser'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
        
      }
  });
})
</script>