<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>Turf Owner Login</title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="website_assets/img/logo.png" rel="icon">
  <link href="assets/img/apple-touch-icon.png" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="<?= base_url('assets/vendor/bootstrap/css/bootstrap.min.css');?>" rel="stylesheet">
  <link href="<?= base_url('assets/vendor/bootstrap-icons/bootstrap-icons.css');?>" rel="stylesheet">
  <link href="<?= base_url('assets/vendor/boxicons/css/boxicons.min.css');?>" rel="stylesheet">
  <link href="<?= base_url('assets/vendor/quill/quill.snow.css');?>" rel="stylesheet">
  <link href="<?= base_url('assets/vendor/quill/quill.bubble.css');?>" rel="stylesheet">
  <link href="<?= base_url('assets/vendor/remixicon/remixicon.css');?>" rel="stylesheet">
  <link href="<?= base_url('assets/vendor/simple-datatables/style.css');?>" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="<?= base_url('assets/css/style.css');?>" rel="stylesheet">

  <!-- =======================================================
  * Template Name: NiceAdmin
  * Updated: Jul 27 2023 with Bootstrap v5.3.1
  * Template URL: https://bootstrapmade.com/nice-admin-bootstrap-admin-html-template/
  * Author: BootstrapMade.com
  * License: https://bootstrapmade.com/license/
  ======================================================== -->
</head>

<body>

  <main>
    <div class="container">

      <section class="section register min-vh-100 d-flex flex-column align-items-center justify-content-center py-4">
        <div class="container">
          <div class="row justify-content-center">
            <div class="col-lg-4 col-md-6 d-flex flex-column align-items-center justify-content-center">

              <div class="d-flex justify-content-center py-4">
                <a href="index.html" class="logo d-flex align-items-center w-auto">
                  <span class="text-primary"><?= get_setting()['title']; ?></span>
                </a>
              </div>
              <!-- End Logo -->
              <div class="card mb-3">

                <div class="card-body">

                  <div class="pt-4 pb-2">
                    <h5 class="card-title text-center pb-0 fs-4">Turf Owner Login</h5>
                  </div>
                  <div class="col-md-12 mb-2">
                      <span class="text-success success" style="display:none;"></span>
                      <span class="text-danger error" style="display:none;"></span>
                  </div>
                  <div class="row g-3 " id="mobile-form">
                    <div class="col-12">
                      <div class="input-group">
                        <input type="number" class="form-control" name="mobile" id="mobile" placeholder="Enter your mobile" required="">
                      </div>
                    </div>
                    <div class="col-12">
                      <button type="button" class="btn btn-primary btn-block w-100" id="mobile-btn">Get OTP</button>
                    </div>
                  </div>
                  <!--otp form-->
                  <div class="row g-3 " id="otp-form" style="display:none">
                    <div class="col-12">
                      <div class="input-group">
                          <input type="number" class="form-control" name="otp" id="otp" placeholder="Enter otp">
                      </div>
                    </div>
                    <div class="col-12">
                      <button type="button" class="btn btn-primary btn-block w-100" id="otp-btn">Verify</button>
                    </div>
                  </div>

                </div>
              </div>

              <div class="credits">
                Designed by <a href="<?= base_url('https://Techicom.com/');?>">Techicom</a>
              </div>

            </div>
          </div>
        </div>

      </section>

    </div>
  </main><!-- End #main -->

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="<?= base_url('assets/vendor/apexcharts/apexcharts.min.js');?>"></script>
  <script src="<?= base_url('assets/vendor/bootstrap/js/bootstrap.bundle.min.js');?>"></script>
  <script src="<?= base_url('assets/vendor/chart.js/chart.umd.js');?>"></script>
  <script src="<?= base_url('assets/vendor/echarts/echarts.min.js');?>"></script>
  <script src="<?= base_url('assets/vendor/quill/quill.min.js');?>"></script>
  <script src="<?= base_url('assets/vendor/simple-datatables/simple-datatables.js');?>"></script>
  <script src="<?= base_url('assets/vendor/tinymce/tinymce.min.js');?>"></script>
  <script src="<?= base_url('assets/vendor/php-email-form/validate.js');?>"></script>

  <!-- Template Main JS File -->
  <script src="<?= base_url('assets/js/main.js');?>"></script>
  <!-- login js-->
      <!-- Plugin used-->
      <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>

<script>
//generate OTP
$("#mobile-btn").click(function(e){
    e.preventDefault();
    $.ajax({
        url: '<?= base_url('turf_owner_auth/generateOtp');?>',
        type: 'post',
        data: {mobile:$('#mobile').val()},
        dataType: 'json',
        beforeSend: function() {
                    $("#mobile-btn").attr("disabled", true);
                    $("#mobile-btn").html("Generating...");
                }, 
        success: function(res) {
                    if(res.return == true){
                        $(".error").hide();
                        $('#mobile-btn').removeAttr("disabled");
                        $('#mobile-btn').html("Get otp");
                        
                        $('#otp-btn').html("Verify");
                        $('#otp_mobile').val($('#mobile').val());
                        $("#mobile-form").slideUp();
                        $("#otp-form").fadeIn();
                    }else{
                        $('#mobile-btn').removeAttr("disabled");
                        $('#mobile-btn').html("Get otp");
                        
                        $(".error").show();
                        $(".error").html(res.msg);

                    }          
                },
        error: function (response) {
            
            $(".error").show();
            $(".error").html('<i class="fas fa-times text-danger"></i>&nbsp;Something went wrong!!');
            $('#mobile-btn').removeAttr("disabled");
            $('#mobile-btn').html("Verify");
                }
    });
});
//Verify otp
$("#otp-btn").click(function(e){
    e.preventDefault();
    $.ajax({
        url: '<?= base_url('turf_owner_auth/verifyOtp');?>',
        type: 'post',
        data: {mobile:$('#mobile').val(),otp:$('#otp').val()},
        dataType: 'json',
        beforeSend: function() {
                    $("#otp-btn").attr("disabled", true);
                    $("#otp-btn").html("Verifying...");
                }, 
        success: function(res) {
                    if(res.return == true){   
                      UserLogin();
                    }else{
                        $('#otp-btn').removeAttr("disabled");
                        $('#otp-btn').html("Verify");
                        
                        $(".error").show();
                        $(".error").html('<i class="fas fa-times text-danger"></i>&nbsp;'+res.msg);
                    }          
                },
        error: function (response) {
            $(".error").show();
            $(".error").html('<i class="fas fa-times text-danger"></i>&nbsp;Something went wrong!!');
            $('#otp-btn').removeAttr("disabled");
            $('#otp-btn').html("Verify");
                }
    });
});
function UserLogin()
{
    var mobile = $('#mobile').val();
    $.ajax({
      type: "POST",
      url : "<?= base_url('turf_owner_auth/UserLogin');?>",
      dataType: "JSON",
      data : {
          'mobile':mobile,
      },
      cache : false,
      beforeSend: function() {
        $("#otp-btn").attr("disabled",true);    
        $("#otp-btn").html('Loading..');      
    }, 
      success: function(res)
      {
        if(res.return)
        {
            $(".error").hide();
            $(".success").show();
            $("#otp-btn").html('<i class="fa fa-circle-o-notch fa-spin"></i> Redirecting...');
            setTimeout(function(){
              window.location.href = "<?= base_url('dashboard'); ?>";
                
            },2000);
        }
        else
        {
            $("#error-message").html(res.msg);
            $("#error").show();
            $("#success").hide();
            $("#otp-btn").removeAttr("disabled"); 
            $("#otp-btn").html('Verify');      
        }
      },
      error: function (jqXHR, exception) {
        var msg = '';
        if (jqXHR.status === 0) {
            msg = 'Not connect.\n Verify Network.';
        } else if (jqXHR.status == 404) {
            msg = 'Requested page not found. [404]';
        } else if (jqXHR.status == 500) {
            msg = 'Internal Server Error [500].';
        } else if (exception === 'parsererror') {
            msg = 'Requested JSON parse failed.';
        } else if (exception === 'timeout') {
            msg = 'Time out error.';
        } else if (exception === 'abort') {
            msg = 'Ajax request aborted.';
        } else {
            msg = 'Uncaught Error.\n' + jqXHR.responseText;
        }
        $("#error-message").html(msg);
            $("#error").show();
    },
    });
};
</script>
</body>
</html>