<?php


class Website_model extends CI_Model
{
    public function getTurfResultData()
	{
        $this->db
        ->select('t1.*,t2.name as country_name,t3.name as state_name,t4.name as city_name,t5.fullname as turf_owner_name,t6.name as turf_category_name')
        ->from('turf t1')
        ->join('countries t2', 't2.id = t1.country','left') 
        ->join('states t3', 't3.id = t1.state','left') 
        ->join('cities t4', 't4.id = t1.city','left') 
        ->join('turf_owner t5', 't5.id = t1.turf_owner_id','left') 
        ->join('turf_category t6', 't6.id = t1.turf_category_id','left')
        ->where('t1.is_disable',0);
        $query = $this->db->get();
		return $query->result_array();
	}
    public function getTurfSlotsResultData($turf_id)
	{
        $query = $this->db
        ->select('t1.*,t2.turf_name')
        ->from('time_slot t1')
        ->join('turf t2', 't2.id = t1.turf_id','left')  
        ->join('turf_price t3', 't3.time_slot_id = t1.id')  
        ->where('t1.is_disable',0)
        ->where('t1.turf_id',$turf_id)
        ->get();
		return $query->result_array();
	}
    public function getTurfBookingResultData()
    {
        $query = $this->db
            ->select('t1.*, t2.turf_name, GROUP_CONCAT(t3.slot_name ORDER BY t3.slot_name ASC SEPARATOR ", ") AS slot_names,t4.fullname')
            ->from('turf_booking t1')
            ->join('turf t2', 't2.id = t1.turf_id', 'left')
            ->join('time_slot t3', 'FIND_IN_SET(t3.id, t1.time_slot_id)', 'left')
            ->join('user t4', 't4.id = t1.user_id', 'left')
            ->where('t1.is_disable',0)
            ->where('t1.user_id',get_cookie('user_id'))
            ->group_by('t1.id')
            ->get();

        return $query->result_array();
    }
    
}

?>