<?php


class Turf_model extends CI_Model
{
    public function getTurfRowData($id)
	{
        $query = $this->db
        ->select('t1.*,t2.name as country_name,t3.name as state_name,t4.name as city_name,t5.fullname as turf_owner_name,t6.name as turf_category_name')
        ->from('turf t1')
        ->join('countries t2', 't2.id = t1.country','left') 
        ->join('states t3', 't3.id = t1.state','left') 
        ->join('cities t4', 't4.id = t1.city','left') 
        ->join('turf_owner t5', 't5.id = t1.turf_owner_id','left') 
        ->join('turf_category t6', 't6.id = t1.turf_category_id','left') 
        ->where('t1.id',$id) 
        ->get();
		return $query->row_array();
	}
    public function getTurfResultData()
	{
        $this->db
        ->select('t1.*,t2.name as country_name,t3.name as state_name,t4.name as city_name,t5.fullname as turf_owner_name,t6.name as turf_category_name')
        ->from('turf t1')
        ->join('countries t2', 't2.id = t1.country','left') 
        ->join('states t3', 't3.id = t1.state','left') 
        ->join('cities t4', 't4.id = t1.city','left') 
        ->join('turf_owner t5', 't5.id = t1.turf_owner_id','left') 
        ->join('turf_category t6', 't6.id = t1.turf_category_id','left');
        if($this->session->userdata('usertype') == 'turf_owner'){
			$this->db->where(['t1.turf_owner_id'=>$this->session->userdata('id')]);
		}
        $query = $this->db->get();
		return $query->result_array();
	}

    //turf image
    public function turfImage($turf_id)
	{
		$images = $this->db->get_where('turf_image',['turf_id'=>$turf_id])->result_array();
        $data = '';
        $i=1;
        foreach($images as $image){
            $ext = substr($image['image'], strrpos($image['image'], '.') + 1);
            $data.= '<tr>';
            $data.= '<td>'.$i++.'</td>';
            
            if($ext == 'mp4' || $ext == 'mov'){
                $data.= '<td><iframe src="'.base_url('assets/uploads/'.$image['image']).'" height="80" width="100"></iframe></td>';
            }else{
                $data.= '<td><img src="'.base_url('assets/uploads/'.$image['image']).'" height="70"></td>';
            }

            $data.= '<td>';
            if($image['is_cover'] !=='1')
            {
                $data.= '<button class="btn btn-sm btn-danger" onclick="deleteTurfImage('.$image['id'].','.$turf_id.')">Delete</button>';
            }
            else{
                $data.= '<button class="btn btn-sm btn-danger" onclick="turfDeleteAlert()">Delete</button>';
            }
            if($image['is_cover']!=='1')
            {
                $data.='<button class="btn btn-sm btn-primary" onclick="makeTurfCoverImage('.$image['id'].','.$turf_id.')">Make cover</button>';
            }
            $data.='</td>';
            $data.= '</tr>';
        }
        echo $data;
	}
    public function addTurfImage($turf_id)
    {
        $config['file_name'] = rand(10000, 10000000000);
        $config['upload_path'] = './assets/uploads/turf';
        $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf';
        $this->load->library('upload', $config);
        $this->upload->initialize($config);

        if (!empty($_FILES['turf_image']['name'])) {
            //upload images
            if ($this->upload->do_upload('turf_image')) {

                $image_data = $this->upload->data();
                $config2 = array(
                    'image_library' => 'gd2',
                    'source_image' => './assets/uploads/turf/' . $image_data['file_name'],
                    'width' => 525,
                    'height' => 350,
                    'maintain_ratio' => FALSE,
                    'new_image' => './assets/uploads/turf/' . $image_data['file_name'],
                );
                $this->load->library('image_lib', $config2);

                if (!$this->image_lib->resize()) {
                    echo $this->image_lib->display_errors(); // Displaying error if resize fails
                    return false;
                }

                $this->image_lib->clear();
                $fileName = "turf/" . $image_data['file_name'];
            }
            $data['image'] = $fileName;
            $data['turf_id'] = $turf_id;
        } else {
            $data['image'] = "";
            $data['turf_id'] = $turf_id;
        }
        return $this->db->insert('turf_image', $data);
    }
    public function deleteTurfImage($id)
    {
        $image = $this->model->getRowData('turf_image',['id'=>$id]);
        $prod_image = ltrim($image['image'], '/');
        if(is_file(base_url('assets/uploads/'.$prod_image)))
        {
            unlink(base_url('assets/uploads/'.$prod_image));
        }
        return $this->db->delete('turf_image',['id'=>$id]);
        
	}
}

?>