<?php
class Turf_booking_model extends CI_Model
{
    public function getTurfBookingRowData($id)
    {
        $query = $this->db
            ->select('t1.*, t2.turf_name, GROUP_CONCAT(t3.slot_name ORDER BY t3.slot_name ASC SEPARATOR ", ") AS slot_names,t4.fullname')
            ->from('turf_booking t1')
            ->join('turf t2', 't2.id = t1.turf_id', 'left')
            ->join('time_slot t3', 'FIND_IN_SET(t3.id, t1.time_slot_id)', 'left')
            ->join('user t4', 't4.id = t1.user_id', 'left')
            ->where('t1.id', $id)
            ->group_by('t1.id')
            ->get();

        return $query->row_array();
    }

    public function getTurfBookingResultData()
    {
        $query = $this->db
            ->select('t1.*, t2.turf_name, GROUP_CONCAT(t3.slot_name ORDER BY t3.slot_name ASC SEPARATOR ", ") AS slot_names,t4.fullname')
            ->from('turf_booking t1')
            ->join('turf t2', 't2.id = t1.turf_id', 'left')
            ->join('time_slot t3', 'FIND_IN_SET(t3.id, t1.time_slot_id)', 'left')
            ->join('user t4', 't4.id = t1.user_id', 'left')
            ->group_by('t1.id')
            ->get();

        return $query->result_array();
    }
}

?>