<?php
defined('BASEPATH') OR exit('No direct script access allowed');
use Razorpay\Api\Api;
// require 'vendor/autoload.php';

class Website extends CI_Controller {

	public function header_and_footer($page, $data)
    {
        $this->load->view('website/includes/header',$data);
        $this->load->view('website/'.$page);
        $this->load->view('website/includes/footer');
    }

	public function index()
	{
		$data['title'] = 'Home';       
        $page = 'index';
        $this->header_and_footer($page, $data);
	}
    public function turfs()
	{
		$data['title'] = 'Turfs';       
		$data['turfs'] = $this->website_model->getTurfResultData();    
        $page = 'turfs';
        $this->header_and_footer($page, $data);
	}
    public function turf_slots()
	{
		$data['title'] = 'Turf Slots';   
        $turf_id = $this->uri->segment(2);    
		$data['turf_slots'] = $this->website_model->getTurfSlotsResultData($turf_id);    
        $page = 'turf_slots';
        $this->header_and_footer($page, $data);
	}
	public function createOrder()
	{
		$amount = $this->input->post('totalPrice');
		$api = new Api('rzp_test_px4WRkJe1zY98p', '4V1bnjLVfFWLbkw2fkfk8efM');

		$orderData = [
			'receipt'         => 'rcptid_11',
			'amount'          => $amount * 100, // amount in paise
			'currency'        => 'INR',
			'payment_capture' => 1 // auto capture
		];

		$razorpayOrder = $api->order->create($orderData);

		$response = array(
			'order_id' => $razorpayOrder['id'],
			'amount'   => $amount * 100,
			'currency' => 'INR'
		);

		echo json_encode($response);
	}
    public function bookSlot()
	{
		if($this->model->countData('turf_booking',[]) > 0){
			$number = $this->model->getRowData('turf_booking',[],null,'id','DESC')['id'] + 1;
			$number = sprintf('%03d',$number);
		}else{
			$number = sprintf('%03d',1);
		}
		$booking_id = 'TURF'.$number;

		$array = array(
			'booking_id' => $booking_id,
			'turf_id' => $_POST['turf_id'],
			'user_id' => get_cookie('user_id'),
			'time_slot_id' => implode(',', $_POST['time_slot_id']),
			'amount' => $_POST['amount'],
			'status' => 'Booked',
		);
		
		if($this->model->add('turf_booking',$array))
		{  
			$insert_booking_id = $this->db->insert_id();
			$transaction_array = array(
				'turf_booking_id' => $insert_booking_id,
				'user_id' => get_cookie('user_id'),
				'amount' => $_POST['amount'],
				'payment_date' => date('d-m-Y'),
				'razorpay_payment_id' => $_POST['razorpay_payment_id'],
				// 'razorpay_order_id' => $_POST['razorpay_order_id'],
				// 'razorpay_signature' => $_POST['razorpay_signature'],
			);
			$this->model->add('transaction',$transaction_array);

			echo json_encode(['return'=>true,'msg'=>'Booked Successfully']);
		} 
	}

    public function fetchSlotAmount()
	{
		$response = array();
		if(isset($_POST['time_slot_ids'])){
			$time_slot_ids = $_POST['time_slot_ids'];
		
			$total_amount = 0;
			foreach($time_slot_ids as $time_slot_id) {
				$data = $this->model->getRowData('turf_price', ['time_slot_id' => $time_slot_id]);
				$total_amount += $data['amount'];
			}
		}else{
			$total_amount= 0;
		}
		

		$response = array(
			'total_amount' => $total_amount,
		);
		echo json_encode($response);
	}

	//bookings
	public function bookings()
	{
		$data['title'] = 'Bookings';       
		$data['bookings'] = $this->website_model->getTurfBookingResultData();    
        $page = 'bookings';
        $this->header_and_footer($page, $data);
	}
        
}
