<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Turf_price extends CI_Controller {
	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }
    public function isAdminLoggedIn()
	{
        if($this->session->userdata('usertype') !== 'admin' && $this->session->userdata('usertype') !== 'staff')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Turf Price';
		if($this->session->userdata('usertype') == 'turf_owner'){
			$where = ['turf_owner_id'=>$this->session->userdata('id'),'is_disable'=>0];
			
		}else{
			$where = ['is_disable'=>0];
		}
		$data['turfs'] = $this->model->getResultData('turf',$where);
		$data['time_slots'] = $this->time_slot_model->getTimeSlotResultDataByOwnerId();
        $page = 'turf_price/index';
        $this->header_and_footer($page, $data);
    }
	
  
	public function addTurfPrice()
    {
		$array = array(
			'turf_id' => $_POST['turf_id'],
			'time_slot_id' => $_POST['time_slot_id'],
			'amount' => $_POST['amount'],
		);
		
		if($this->model->add('turf_price',$array))
		{  
			$lead_id = $this->db->insert_id();
			$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','turf price');
			echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
		} 
		
    }
	public function viewTurfPrice()
    {
		$data['list'] = $this->turf_price_model->getTurfPriceResultData();
		$this->load->view('turf_price/tb',$data);
    }
	public function editTurfPrice()
    {
        $response=array();
		$data = $this->model->getRowData('turf_price',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'turf_id' => $data['turf_id'],
			'time_slot_id' => $data['time_slot_id'],
			'amount' => $data['amount'],
		);
		echo json_encode($response);
    }
	public function updateTurfPrice()
    {
			if(isset($_POST['id']))
			{
				$array = array(
					'turf_id' => $_POST['turf_id'],
					'time_slot_id' => $_POST['time_slot_id'],
					'amount' => $_POST['amount'],
				);
				
				if($this->model->edit('turf_price',$array,['id'=>$_POST['id']]))
				{
					$lead_id = $_POST['id'];
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','turf price');

					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
		}
    public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Turf Price Detail';
		$data['data'] = $this->turf_price_model->getTurfPriceRowData($id);
        $page = 'turf_price/detail';
        $this->header_and_footer($page, $data);
    }
	
   	
}
