<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Turf_owner extends CI_Controller {
	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }
    public function isAdminLoggedIn()
	{
        if($this->session->userdata('usertype') !== 'admin' && $this->session->userdata('usertype') !== 'staff')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Turf Owner';
		$data['countries'] = $this->model->getResultData('countries',[]);
        $page = 'turf_owner/index';
        $this->header_and_footer($page, $data);
    }
	
  
	public function addTurfOwner()
    {
		$array = array(
			'fullname' => $_POST['fullname'],
			'mobile' => $_POST['mobile'],
			'gender' => $_POST['gender'],
			'email' => $_POST['email'],
			'dob' => $_POST['dob'],
			'country' => $_POST['country'],
			'state' => $_POST['state'],
			'city' => $_POST['city'],
			'address' => $_POST['address'],
			'company_name' => $_POST['company_name'],
			'gst_no' => $_POST['gst_no'],
		);
		
		if($this->turf_owner_model->addTurfOwner($array))
		{  
			$lead_id = $this->db->insert_id();
			$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','turf owner');
			echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
		} 
		
    }
	public function viewTurfOwner()
    {
		$data['list'] = $this->model->getResultData('turf_owner',[]);
		$this->load->view('turf_owner/tb',$data);
    }
	public function editTurfOwner()
    {
        $response=array();
		$data = $this->model->getRowData('turf_owner',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'fullname' => $data['fullname'],
			'mobile' => $data['mobile'],
			'gender' => $data['gender'],
			'email' => $data['email'],
			'dob' => $data['dob'],
			'country' => $data['country'],
			'state' => $data['state'],
			'city' => $data['city'],
			'address' => $data['address'],
			'company_name' => $data['company_name'],
			'gst_no' => $data['gst_no'],
			'id_proof' => base_url('assets/uploads/'.$data['id_proof'].''),
			'pan_card' => base_url('assets/uploads/'.$data['pan_card'].''),
		);
		echo json_encode($response);
    }
	public function updateTurfOwner()
    {
			if(isset($_POST['id']))
			{
				$array = array(
					'fullname' => $_POST['fullname'],
					'mobile' => $_POST['mobile'],
					'gender' => $_POST['gender'],
					'email' => $_POST['email'],
					'dob' => $_POST['dob'],
					'country' => $_POST['country'],
					'state' => $_POST['state'],
					'city' => $_POST['city'],
					'address' => $_POST['address'],
					'company_name' => $_POST['company_name'],
					'gst_no' => $_POST['gst_no'],
				);
				
				if($this->turf_owner_model->updateTurfOwner($array,$_POST['id']))
				{
					$lead_id = $_POST['id'];
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','turf owner');

					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
		}
    public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Turf Owner Detail';
		$data['data'] = $this->turf_owner_model->getTurfOwnerRowData($id);
        $page = 'turf_owner/detail';
        $this->header_and_footer($page, $data);
    }
	
   	
}
