

<main id="main" class="main">

<section class="section">
  <div class="row">
    <div class="col-lg-12">

      <div class="card">
          <div class="card-header mb-4">
            <div class="row">
              <div class="col-sm-6">
                <h4 class="text-dark"><?= $title; ?></h4>
              </div>
              <div class="col-sm-6" style="text-align: right;">
                <a class="btn btn-success rounded add-btn" href="<?= base_url('calculation-list') ?>" target="_blank"> View Calculations</a>
              </div>
             </div>

        </div>
        <div class="card-body">
          <form class="row g-3" id="add-form">
            <div class="col-md-6">
              <label class="form-label">Staff</label>
              <select name="staff_id" class="form-control" id="staff_id" required>
                  <option value="">Select</option>
                  <?php foreach($staffs as $staff){ ?>
                    <option value="<?= $staff['id']; ?>"><?= $staff['fullname']; ?></option>
                  <?php } ?>
              </select>                   
            </div>
            <div class="col-md-6">
              <label class="form-label">Currency</label>
              <select name="currency" class="form-control" id="currency" required>
                  <option value="">Select</option>
                  <option value="INR">INR</option>
                  <option value="USD">USD</option>
              </select>                   
            </div>
            <div class="col-md-6">
              <label class="form-label">Offering</label>
              <select name="offering_id[]" class="form-control" id="offering_id" multiple required>
                  <option value="">Select</option>
                  <?php foreach($offerings as $offering){ ?>
                    <option value="<?= $offering['id']; ?>"><?= $offering['name']; ?></option>
                  <?php } ?>
              </select>                   
            </div>
            <div class="col-md-6">
              <label class="form-label">Type</label>
              <div class="col-sm-10">
                <div class="form-check">
                  <input class="form-check-input" type="radio" name="type" id="type" value="Regular" required>
                  <label class="form-check-label" for="type">Regular</label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" name="type" id="type" value="Premium" required>
                  <label class="form-check-label" for="type">Premium</label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" name="type" id="type" value="High Ticket" required>
                  <label class="form-check-label" for="type">High Ticket</label>
                </div>
              </div>        
            </div>
            
            <div class="text-left">
              <button type="submit" class="btn btn-primary">Calculate</button>
            </div>
          </form>
        </div>
      </div>

    </div>
  </div>
</section>

</main><!-- End #main -->
<!-- Calculation Modal -->
<div class="modal fade modal-bookmark" id="viewCalculationModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Calculation</h5>
        <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div>
        <table class="table table-striped table-hover">
            <thead>
              <tr>
                  <th>Offering</th>
                  <th>Currency</th>
                  <th>Ticket Type</th>
                  <th>Price</th>
              </tr>
            </thead>
            <tbody id="calculation-details">
              
            </tbody>
        </table>
        </div>
      </div>
    </div>
  </div>
</div>



<script>
$(document).ready(function(){  
$('#viewCalculationModal').modal({
       backdrop: 'static',
       keyboard: false
})
});

$("#add-form").submit(function(e){
e.preventDefault();
disableButton();
$.ajax({
  url: "<?php echo base_url('calculator/calculatePricing'); ?>",
  method: "POST",
  data:  new FormData(this),
  cache: false,
  contentType: false,
  processData: false,
  success:function(res){
    enableButton();
      $('#viewCalculationModal').modal('toggle'); 
      $('#calculation-details').html(res);
      $('#add-form')[0].reset();
    
  }
});
})

</script>
