<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Offering extends CI_Controller {
	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }
    public function isAdminLoggedIn()
	{
        if($this->session->userdata('usertype') !== 'admin' && $this->session->userdata('usertype') !== 'staff')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Offering';
		$data['offering_categories'] = $this->model->getResultData('offering_category',['is_disable'=>0]);
        $page = 'offering/index';
        $this->header_and_footer($page, $data);
    }
	
  
	public function addOffering()
    {
		$array = array(
			'offering_category_id' => $_POST['offering_category_id'],
			'name' => $_POST['name'],
			'inr_hourly_rate' => $_POST['inr_hourly_rate'],
			'usd_hourly_rate' => $_POST['usd_hourly_rate'],
			'details' => $_POST['details'],
		);
		
		if($this->model->add('offering',$array))
		{  
			$lead_id = $this->db->insert_id();
			$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','offering');
			echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
		} 
		
    }
	public function viewOffering()
    {
		$data['list'] = $this->offering_model->getOfferingResultData();
		$this->load->view('offering/tb',$data);
    }
	public function editOffering()
    {
        $response=array();
		$data = $this->model->getRowData('offering',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'offering_category_id' => $data['offering_category_id'],
			'name' => $data['name'],
			'inr_hourly_rate' => $data['inr_hourly_rate'],
			'usd_hourly_rate' => $data['usd_hourly_rate'],
			'details' => $data['details'],
		);
		echo json_encode($response);
    }
	public function updateOffering()
    {
			if(isset($_POST['id']))
			{
				$array = array(
					'offering_category_id' => $_POST['offering_category_id'],
					'name' => $_POST['name'],
					'inr_hourly_rate' => $_POST['inr_hourly_rate'],
					'usd_hourly_rate' => $_POST['usd_hourly_rate'],
					'details' => $_POST['details'],
				);
				
				if($this->model->edit('offering',$array,['id'=>$_POST['id']]))
				{
					$lead_id = $_POST['id'];
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','offering');

					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
		}
    public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Offering Detail';
		$data['data'] = $this->offering_model->getOfferingRowData($id);
        $page = 'offering/detail';
        $this->header_and_footer($page, $data);
    }
	
   	
}
