<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Staff extends CI_Controller {
	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }
    public function isAdminLoggedIn()
	{
        if($this->session->userdata('usertype') !== 'admin' && $this->session->userdata('usertype') !== 'staff')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Staff';
		//generate employee id
		if($this->model->countData('staff',[]) > 0){
			$number = $this->model->getRowData('staff',[],null,'id','DESC')['id'] + 1;
			$number = sprintf('%03d',$number);
			$data['employeeId'] = 'CEMP'.$number;
		}else{
			$data['employeeId'] = 'CEMP'.sprintf('%03d',1);
		}
		$data['countries'] = $this->model->getResultData('countries',[]);
        $page = 'staff/index';
        $this->header_and_footer($page, $data);
    }
	
  
	public function addStaff()
    {
		$countEmail = $this->model->countData('staff',['emailid'=>$_POST['emailid']]);
		if($countEmail > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Email already exist']);
		}
		else
		{
			if($_POST['fullname'])
			{
				$array = array(
					'fullname' => ucfirst($_POST['fullname']),
					'department' => $_POST['department'],
					'emailid' => $_POST['emailid'],
					'password' =>md5($_POST['password']),
					'mobile' =>  '+'.$_POST['ccode'].' '.$_POST['mobile'],
					'country' => $_POST['country'],
					'state' => $_POST['state'],
					'city' => $_POST['city'],
					'employee_id' => $_POST['employee_id'],
					'pincode' => $_POST['pincode'],
					'gender' => $_POST['gender'],
					'dob' => $_POST['dob'],
					'address' => $_POST['address'],
				);
				if($this->model->add('staff',$array))
				{
					$lead_id = $this->db->insert_id();
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','staff detail');

					echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
				}
				
			}
		}
    }
	public function viewStaff()
    {
		$data['list'] = $this->model->getResultData('staff',[],null,'id','DESC');
		$this->load->view('staff/tb',$data);
    }
	public function editStaff()
    {
        $response=array();
		$data = $this->model->getRowData('staff',['id' => $_POST['id']]);
		if($data['mobile'] !== '')
		{
			$mob = explode(' ',$data['mobile']);
			$ccode = $mob[0];
			$contact = $mob[1];
		}else{
			$mob = '';
			$ccode = '';
			$contact = '';
		}
		$response = array(
			'id' => $_POST['id'],
			'department' => $data['department'],
			'fullname' => $data['fullname'],
			'email' => $data['emailid'],
			'mobile' => $contact,
			'ccode' => str_replace("+","",$ccode),
			'password' => $data['password'],
			'country' => $data['country'],
			'state' => $data['state'],
			'city' => $data['city'],
			'employee_id' => $data['employee_id'],
			'pincode' => $data['pincode'],
			'gender' => $data['gender'],
			'dob' => $data['dob'],
			'address' => $data['address'],
		);
		echo json_encode($response);
    }
	public function updateStaff()
    {
		$countEmail = $this->model->countData('staff',['emailid'=>$_POST['emailid'],'id!='=>$_POST['id']]);
		if($countEmail > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Email already exist']);
		}
		else
		{
			if(isset($_POST['id']))
			{
				$array = array(
					'fullname' => ucfirst($_POST['fullname']),
					'department' => $_POST['department'],
					'emailid' => $_POST['emailid'],
					'mobile' =>  '+'.$_POST['ccode'].' '.$_POST['mobile'],
					'country' => $_POST['country'],
					'state' => $_POST['state'],
					'city' => $_POST['city'],
					'employee_id' => $_POST['employee_id'],
					'pincode' => $_POST['pincode'],
					'gender' => $_POST['gender'],
					'dob' => $_POST['dob'],
					'address' => $_POST['address'],
				);
				if($this->model->edit('staff',$array,['id' => $_POST['id']]))
				{
					$lead_id = $_POST['id'];
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','staff detail');
					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
			else
			{
				echo json_encode(['return'=>false,'msg'=>'`id` is required']);
			}
		}
    }
  
    public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Staff Detail';
		$data['data'] = $this->staff_model->getStaffRowData($id);
        $page = 'staff/detail';
        $this->header_and_footer($page, $data);
    }
	public function changePassword()
    {
        if($_POST['id'])
		{
			if($this->model->edit('staff',['password'=>md5($_POST['password'])],['id' => $_POST['id']]))
			{
				$this->viewStaff();
			}
		}
    }
	
   	
}
