

  <main id="main" class="main">

    <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card">
              <div class="card-header mb-4">
                <div class="row">
                  <div class="col-sm-6">
                    <h4 class="text-dark"><?= $title; ?></h4>
                  </div>
                  <div class="col-sm-6" style="text-align: right;">
                    <button class="btn btn-success rounded add-btn" type="button" onclick="add()"><i class="bi bi-plus"></i> Add <?= $title; ?></button>
                  </div>
                 </div>

            </div>
            <div class="card-body">
              <!-- Table with stripped rows -->
              <div class="table-responsive" id="tb">
                    </div>
              <!-- End Table with stripped rows -->

            </div>
          </div>

        </div>
      </div>
    </section>

  </main><!-- End #main -->
   <!-- Add Modal -->
        <div class="modal fade modal-bookmark" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="row g-3" id="add-form">
                  <div class="col-md-6">
                    <label class="form-label">Turf</label>
                    <select name="turf_id" class="form-control" id="turf_id">
                        <option value="">Select</option>
                        <?php foreach($turfs as $turf){ ?>
                          <option value="<?= $turf['id']; ?>"><?= $turf['turf_name']; ?></option>
                        <?php } ?>
                    </select>                   
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">User</label>
                    <select name="user_id" class="form-control" id="user_id">
                        <option value="">Select</option>
                        <?php foreach($users as $user){ ?>
                          <option value="<?= $user['id']; ?>"><?= $user['fullname']; ?></option>
                        <?php } ?>
                    </select>                   
                  </div>
                  <div class="col-md-12">
                    <label class="form-label">Time Slot</label>
                    <select name="time_slot_id[]" class="form-control" id="time_slot_id" onchange="fetchAmount(this, 'add')" multiple>
                        <option value="">Select</option>
                        <?php foreach($time_slots as $time_slot){ ?>
                          <option value="<?= $time_slot['id']; ?>"><?= $time_slot['slot_name']; ?></option>
                        <?php } ?>
                    </select>                   
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">Status</label>
                    <select name="status" class="form-control" id="status">
                        <option value="">Select</option>
                        <option value="Booked">Booked</option>
                        <option value="Pending">Pending</option>
                        
                    </select>                   
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">Amount</label>
                    <input type="number" step="any" class="form-control" id="amount" name="amount" readonly>
                  </div>
                 
                  <div class="text-left">
                    <button type="submit" class="btn btn-primary">Save</button>
                    <button type="reset" class="btn btn-danger">Reset</button>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>

      <!-- Edit Modal -->
      <div class="modal fade modal-bookmark" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="row g-3" id="edit-form">
                  <div class="col-md-6">
                    <label class="form-label">Turf</label>
                    <select name="turf_id" class="form-control" id="e_turf_id">
                        <option value="">Select</option>
                        <?php foreach($turfs as $turf){ ?>
                          <option value="<?= $turf['id']; ?>"><?= $turf['turf_name']; ?></option>
                        <?php } ?>
                    </select>                   
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">User</label>
                    <select name="user_id" class="form-control" id="e_user_id">
                        <option value="">Select</option>
                        <?php foreach($users as $user){ ?>
                          <option value="<?= $user['id']; ?>"><?= $user['fullname']; ?></option>
                        <?php } ?>
                    </select>                   
                  </div>
                  <div class="col-md-12">
                    <label class="form-label">Time Slot</label>
                    <select name="time_slot_id[]" class="form-control" id="e_time_slot_id" multiple onchange="fetchAmount(this,'edit')">
                        <option value="">Select</option>
                        <?php foreach($time_slots as $time_slot){ ?>
                          <option value="<?= $time_slot['id']; ?>"><?= $time_slot['slot_name']; ?></option>
                        <?php } ?>
                    </select>                   
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">Status</label>
                    <select name="status" class="form-control" id="e_status">
                        <option value="">Select</option>
                        <option value="Booked">Booked</option>
                        <option value="Pending">Pending</option>
                    </select>                   
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">Amount</label>
                    <input type="number" step="any" class="form-control" id="e_amount" name="amount" readonly>
                  </div>
                    <div class="text-left">
                      <input type="hidden" id="e_id" name="id">
                      <button type="submit" class="btn btn-primary">Save</button>
                      <button type="reset" class="btn btn-danger">Reset</button>
                    </div>
                </form>
              </div>
            </div>
          </div>
        </div>
<script>
  function add()
  {
    $('#addModal').modal('toggle'); 
    $('#add-form')[0].reset();
  }
$(document).ready(function(){  
$("#tb").html('<div class="text-center"><img src="loader.gif"></div>')
  $('#addModal').modal({
           backdrop: 'static',
           keyboard: false
    })
    $('#editModal').modal({
           backdrop: 'static',
           keyboard: false
    })
  $('#tb').load('<?= base_url('turf_booking/viewTurfBooking'); ?>');
});


$("#add-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('turf_booking/addTurfBooking'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#addModal').modal('toggle'); 
          $('#add-form')[0].reset();
          $('#tb').load('<?= base_url('turf_booking/viewTurfBooking'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
        
      }
  });
})

function editData(id)
{
  $.ajax({
      url: "<?= base_url('turf_booking/editTurfBooking'); ?>",
      method: "POST",
        dataType: 'json',
      data: {
          id:id
      },
      success:function(res){
          $("#e_id").val(res.id);
          var selectedValues = res.time_slot_id.toString().split(',');
          $('#e_time_slot_id').val(selectedValues);

          $("#e_turf_id").val(res.turf_id);
          $("#e_user_id").val(res.user_id);
          $("#e_amount").val(res.amount);
          $("#e_status").val(res.status);
      }
  });
};
function fetchAmount(selectElement, type) {
  var selectedValues = Array.from(selectElement.selectedOptions).map(option => option.value);

  $.ajax({
      url: "<?= base_url('turf_booking/fetchAmount'); ?>",
      method: "POST",
      dataType: 'json',
      data: {
        time_slot_ids: selectedValues
      },
      success: function(res) {
        if (type == 'add') {
          $("#amount").val(res.total_amount);
        } else if (type == 'edit') {
          $("#e_amount").val(res.total_amount);
        }
      }
  });
}

$("#edit-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('turf_booking/updateTurfBooking'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#editModal').modal('toggle'); 
          $('#edit-form')[0].reset();
          $('#tb').load('<?= base_url('turf_booking/viewTurfBooking'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
        
      }
  });
})
</script>