<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title><?= $title; ?></title>
  <meta content="" name="description">
  <meta content="" name="keywords">

  <!-- Favicons -->
  <link href="website_assets/img/logo.png" rel="icon">
  <link href="assets/img/apple-touch-icon.png" rel="apple-touch-icon">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="<?= base_url('assets/vendor/bootstrap/css/bootstrap.min.css');?>" rel="stylesheet">
  <link href="<?= base_url('assets/vendor/bootstrap-icons/bootstrap-icons.css');?>" rel="stylesheet">
  <link href="<?= base_url('assets/vendor/boxicons/css/boxicons.min.css');?>" rel="stylesheet">
  <link href="<?= base_url('assets/vendor/quill/quill.snow.css');?>" rel="stylesheet">
  <link href="<?= base_url('assets/vendor/quill/quill.bubble.css');?>" rel="stylesheet">
  <link href="<?= base_url('assets/vendor/remixicon/remixicon.css');?>" rel="stylesheet">
  <link href="<?= base_url('assets/vendor/simple-datatables/style.css');?>" rel="stylesheet">

  <!-- Template Main CSS File -->
  <link href="<?= base_url('assets/css/style.css');?>" rel="stylesheet">

</head>

<body>

  <main>
    <div class="container">

      <section class="section register min-vh-100 d-flex flex-column align-items-center justify-content-center py-4">
        <div class="container">
          <div class="row justify-content-center">
            <div class="col-lg-4 col-md-6 d-flex flex-column align-items-center justify-content-center">

              <div class="d-flex justify-content-center py-4">
                <a href="index.html" class="logo d-flex align-items-center w-auto">
                  <span class="text-primary"><?= get_setting()['title']; ?></span>
                </a>
              </div>
              <!-- End Logo -->
              <div class="card mb-3">

                <div class="card-body">

                  <div class="pt-4 pb-2">
                    <h5 class="card-title text-center pb-0 fs-4"><?= $title; ?></h5>
                  </div>
                  <div class="col-md-12 mb-2">
                      <span class="text-success success" style="display:none;"></span>
                      <span class="text-danger error" style="display:none;"></span>
                  </div>
                  <div class="row g-3 " id="email-form">
                    <div class="col-12">
                      <div class="input-group">
                        <input type="email" class="form-control" name="email" id="email" placeholder="Enter your email" required="">
                      </div>
                    </div>
                    <div class="col-12">
                      <button type="button" class="btn btn-primary btn-block w-100" id="email-btn">Send OTP</button>
                    </div>
                  </div>
                  <!--otp form-->
                  <div class="row g-3 " id="otp-form" style="display:none">
                    <div class="col-12">
                      <div class="input-group">
                          <input type="number" class="form-control" name="otp" id="otp" placeholder="Enter otp">
                      </div>
                    </div>
                    <div class="col-12">
                      <button type="button" class="btn btn-primary btn-block w-100" id="otp-btn">Verify</button>
                    </div>
                  </div>
                  <!--forgot password form-->
                  <div class="row g-3 " id="forgot-password-form" style="display:none">
                    <div class="col-12">
                      <div class="input-group">
                        <input type="password" class="form-control" name="new_password" id="new_password" placeholder="New Password">
                      </div>
                    </div>
                    <div class="col-12">
                      <div class="input-group">
                        <input type="password" class="form-control" name="confirm_password" id="confirm_password" placeholder="Confirm Password">
                      </div>
                    </div>
                    <div class="col-12">
                      <button type="button" class="btn btn-primary btn-block w-100" id="reset-btn">
                        <span id="sign-up">Reset Password</span>
                        <span id="sign-up-loader" style="display: none;">
                            <i class="fa fa-circle-o-notch fa-spin"></i> Loading...
                        </span>
                      </button>
                    </div>
                  </div>

                </div>
              </div>

              <div class="credits">
                Designed by <a href="<?= base_url('https://Techicom.com/');?>">Techicom</a>
              </div>

            </div>
          </div>
        </div>

      </section>

    </div>
  </main><!-- End #main -->

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="<?= base_url('assets/vendor/apexcharts/apexcharts.min.js');?>"></script>
  <script src="<?= base_url('assets/vendor/bootstrap/js/bootstrap.bundle.min.js');?>"></script>
  <script src="<?= base_url('assets/vendor/chart.js/chart.umd.js');?>"></script>
  <script src="<?= base_url('assets/vendor/echarts/echarts.min.js');?>"></script>
  <script src="<?= base_url('assets/vendor/quill/quill.min.js');?>"></script>
  <script src="<?= base_url('assets/vendor/simple-datatables/simple-datatables.js');?>"></script>
  <script src="<?= base_url('assets/vendor/tinymce/tinymce.min.js');?>"></script>
  <script src="<?= base_url('assets/vendor/php-email-form/validate.js');?>"></script>

  <!-- Template Main JS File -->
  <script src="<?= base_url('assets/js/main.js');?>"></script>
  <!-- login js-->
      <!-- Plugin used-->
      <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>


      <script>
//generate OTP
$("#email-btn").click(function(e){
    e.preventDefault();
    $.ajax({
        url: '<?= base_url('staff_auth/generateResetPasswordOtp');?>',
        type: 'post',
        data: {email:$('#email').val()},
        dataType: 'json',
        beforeSend: function() {
                    $("#email-btn").attr("disabled", true);
                    $("#email-btn").html("Generating...");
                }, 
        success: function(res) {
                    if(res.return == true){
                        $(".error").hide();
                        $('#email-btn').removeAttr("disabled");
                        $('#email-btn').html("Get otp");
                        
                        $('#otp-btn').html("Verify"+res.msg);
                        $('#otp_email').val($('#email').val());
                        $("#email-form").slideUp();
                        $("#otp-form").fadeIn();
                    }else{
                        $('#email-btn').removeAttr("disabled");
                        $('#email-btn').html("Get otp");
                        
                        $(".error").show();
                        $(".error").html(res.msg);

                    }          
                },
        error: function (response) {
            
            $(".error").show();
            $(".error").html('<i class="fas fa-times text-danger"></i>&nbsp;Something went wrong!!');
            $('#email-btn').removeAttr("disabled");
            $('#email-btn').html("Verify");
                }
    });
});
//Verify otp
$("#otp-btn").click(function(e){
    e.preventDefault();
    $.ajax({
        url: '<?= base_url('staff_auth/verifyResetPasswordOtp');?>',
        type: 'post',
        data: {email:$('#email').val(),otp:$('#otp').val()},
        dataType: 'json',
        beforeSend: function() {
                    $("#otp-btn").attr("disabled", true);
                    $("#otp-btn").html("Verifying...");
                }, 
        success: function(res) {
                    if(res.return == true){   
                      $(".error").hide();                         
                      $("#otp-form").slideUp();
                      $("#forgot-password-form").fadeIn();
                      $("#staff_email").val($('#email').val());
                    }else{
                        $('#otp-btn').removeAttr("disabled");
                        $('#otp-btn').html("Verify");
                        
                        $(".error").show();
                        $(".error").html('<i class="fas fa-times text-danger"></i>&nbsp;'+res.msg);
                    }          
                },
        error: function (response) {
            $(".error").show();
            $(".error").html('<i class="fas fa-times text-danger"></i>&nbsp;Something went wrong!!');
            $('#otp-btn').removeAttr("disabled");
            $('#otp-btn').html("Verify");
        }
    });
});
$("#reset-btn").click(function(e){
    var new_password = $('#new_password').val();
    var confirm_password = $('#confirm_password').val();
    var email = $('#staff_email').val();
    $.ajax({
      type: "POST",
      url : "<?= base_url('staff_auth/resetPassword');?>",
      dataType: "JSON",
      data : "new_password="+new_password+"&confirm_password="+confirm_password+"&email="+email,
      cache : false,
      beforeSend: function() {
        $("#sign-up").hide();
        $("#sign-up-loader").show();
        $("#sign-up-button").attr("disabled",true);       
    }, 
      success: function(res)
      {
        if(res.return)
        {
          $(".error").hide();
          $("#success").show();
          $.ajax({
              type: "POST",
              url: "<?= base_url('staff_auth/setResetSuccessMessage');?>",
              data: { message: 'Password changed successfully.' },
              success: function() {
                  $("#sign-up-loader").html('<i class="fa fa-circle-o-notch fa-spin"></i> Redirecting...');
                  setTimeout(function(){
                      window.location = "<?= base_url('staff-login'); ?>";
                  }, 2000);
              }
          });
        }
        else
        {
            $(".error").html('<i class="fas fa-times text-danger"></i>&nbsp;'+res.msg);
            $(".error").show();
            $("#success").hide();
            $("#sign-up").show();
            $("#sign-up-loader").hide();
            $("#sign-up-button").removeAttr("disabled"); 
        }
      },
      error: function (jqXHR, exception) {
        var msg = '';
        if (jqXHR.status === 0) {
            msg = 'Not connect.\n Verify Network.';
        } else if (jqXHR.status == 404) {
            msg = 'Requested page not found. [404]';
        } else if (jqXHR.status == 500) {
            msg = 'Internal Server Error [500].';
        } else if (exception === 'parsererror') {
            msg = 'Requested JSON parse failed.';
        } else if (exception === 'timeout') {
            msg = 'Time out error.';
        } else if (exception === 'abort') {
            msg = 'Ajax request aborted.';
        } else {
            msg = 'Uncaught Error.\n' + jqXHR.responseText;
        }
        $(".error").html('<i class="fas fa-times text-danger"></i>&nbsp;'+res.msg);
            $("#error").show();
    },
    });
});
</script>
</body>
</html>