<?php


class Turf_owner_model extends CI_Model
{
    public function getTurfOwnerRowData($id)
	{
        $query = $this->db
        ->select('t1.*,t2.name as country_name,t3.name as state_name,t4.name as city_name')
        ->from('turf_owner t1')
        ->join('countries t2', 't2.id = t1.country','left') 
        ->join('states t3', 't3.id = t1.state','left') 
        ->join('cities t4', 't4.id = t1.city','left') 
        ->where('t1.id',$id) 
        ->get();
		return $query->row_array();
	}
    public function getTurfOwnerResultData()
	{
        $query = $this->db
        ->select('t1.*,t2.name as country_name,t3.name as state_name,t4.name as city_name')
        ->from('turf_owner t1')
        ->join('countries t2', 't2.id = t1.country','left') 
        ->join('states t3', 't3.id = t1.state','left') 
        ->join('cities t4', 't4.id = t1.city','left') 
        ->get();
		return $query->result_array();
	}
    public function addTurfOwner($data)
	{
		$config['file_name'] = rand(10000, 10000000000);
        $config['upload_path'] = './assets/uploads/turf_owner';
        $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf';
        $this->load->library('upload', $config);
        $this->upload->initialize($config);

        if (!empty($_FILES['id_proof']['name'])) {
            //upload images
            $_FILES['id_proofs']['name'] = $_FILES['id_proof']['name'];
            $_FILES['id_proofs']['type'] = $_FILES['id_proof']['type'];
            $_FILES['id_proofs']['tmp_name'] = $_FILES['id_proof']['tmp_name'];
            $_FILES['id_proofs']['size'] = $_FILES['id_proof']['size'];
            $_FILES['id_proofs']['error'] = $_FILES['id_proof']['error'];

            if ($this->upload->do_upload('id_proofs')) {

                $image_data = $this->upload->data();
                $config2 = array(
                    'image_library' => 'gd2', //get original image
                    'source_image' =>  './assets/uploads/turf_owner/'. $image_data['file_name'],
                    // 'width' => 152,
                    // 'height' => 142,
                    'maintain_ratio' => FALSE,
                    'new_image' =>  './assets/uploads/turf_owner/'. $image_data['file_name'],

                );
                $this->load->library('image_lib');
                $this->image_lib->initialize($config2);
                $this->image_lib->resize();
                $this->image_lib->clear();

                $fileName = "turf_owner/" . $image_data['file_name'];
            }
            
            $data['id_proof'] = $fileName;
        } else {
            $data['id_proof'] = "";
        }
        //pan card
        if (!empty($_FILES['pan_card']['name'])) {
            //upload images
            $_FILES['pan_cards']['name'] = $_FILES['pan_card']['name'];
            $_FILES['pan_cards']['type'] = $_FILES['pan_card']['type'];
            $_FILES['pan_cards']['tmp_name'] = $_FILES['pan_card']['tmp_name'];
            $_FILES['pan_cards']['size'] = $_FILES['pan_card']['size'];
            $_FILES['pan_cards']['error'] = $_FILES['pan_card']['error'];

            if ($this->upload->do_upload('pan_cards')) {

                $image_data = $this->upload->data();
                $config2 = array(
                    'image_library' => 'gd2', //get original image
                    'source_image' =>  './assets/uploads/pan_card/'. $image_data['file_name'],
                    // 'width' => 152,
                    // 'height' => 142,
                    'maintain_ratio' => FALSE,
                    'new_image' =>  './assets/uploads/pan_card/'. $image_data['file_name'],

                );
                $this->load->library('image_lib');
                $this->image_lib->initialize($config2);
                $this->image_lib->resize();
                $this->image_lib->clear();

                $fileName = "turf_owner/" . $image_data['file_name'];
            }
            $data['pan_card'] = $fileName;
        } else {
            $data['pan_card'] = "";
        }
        return $this->db->insert('turf_owner', $data);
	}
    public function updateTurfOwner($data,$id)
	{
		$config['file_name'] = rand(10000, 10000000000);
        $config['upload_path'] = './assets/uploads/turf_owner';
        $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf';
        $this->load->library('upload', $config);
        $this->upload->initialize($config);

        if (!empty($_FILES['id_proof']['name'])) {
            //upload images
            $_FILES['id_proofs']['name'] = $_FILES['id_proof']['name'];
            $_FILES['id_proofs']['type'] = $_FILES['id_proof']['type'];
            $_FILES['id_proofs']['tmp_name'] = $_FILES['id_proof']['tmp_name'];
            $_FILES['id_proofs']['size'] = $_FILES['id_proof']['size'];
            $_FILES['id_proofs']['error'] = $_FILES['id_proof']['error'];

            if ($this->upload->do_upload('id_proofs')) {
                $image_data = $this->upload->data();

                $config2 = array(
                    'image_library' => 'gd2',
                    'source_image' =>  './assets/uploads/turf_owner/'. $image_data['file_name'],
                    // 'width' => 152,
                    // 'height' => 142,
                    'maintain_ratio' => FALSE,
                    'new_image' =>  './assets/uploads/turf_owner/'. $image_data['file_name'],

                );
                $this->load->library('image_lib');
                $this->image_lib->initialize($config2);
                $this->image_lib->resize();
                $this->image_lib->clear();
                $fileName = "turf_owner/" . $image_data['file_name'];
            }
            $data['id_proof'] = $fileName;
            if (!empty($fileName))    
            {
                $images = $this->model->getRowData('turf_owner',['id'=>$id]);
                
                if($images['id_proof'] !== '' && $images['id_proof'] !== NULL){
                    $image = ltrim($images['id_proof'], '/');
                    if(is_file('./assets/uploads/'.$image))
                    {
                        unlink('./assets/uploads/'.$image);
                    }
                }
            }
        } 
        //pan card
        if (!empty($_FILES['pan_card']['name'])) {
            //upload images
            $_FILES['pan_cards']['name'] = $_FILES['pan_card']['name'];
            $_FILES['pan_cards']['type'] = $_FILES['pan_card']['type'];
            $_FILES['pan_cards']['tmp_name'] = $_FILES['pan_card']['tmp_name'];
            $_FILES['pan_cards']['size'] = $_FILES['pan_card']['size'];
            $_FILES['pan_cards']['error'] = $_FILES['pan_card']['error'];

            if ($this->upload->do_upload('pan_cards')) {
                $image_data = $this->upload->data();

                $config2 = array(
                    'image_library' => 'gd2',
                    'source_image' =>  './assets/uploads/turf_owner/'. $image_data['file_name'],
                    // 'width' => 152,
                    // 'height' => 142,
                    'maintain_ratio' => FALSE,
                    'new_image' =>  './assets/uploads/turf_owner/'. $image_data['file_name'],

                );
                $this->load->library('image_lib');
                $this->image_lib->initialize($config2);
                $this->image_lib->resize();
                $this->image_lib->clear();
                $fileName = "turf_owner/" . $image_data['file_name'];
            }
            $data['pan_card'] = $fileName;
            if (!empty($fileName))    
            {
                $images = $this->model->getRowData('turf_owner',['id'=>$id]);
                
                if($images['pan_card'] !== '' && $images['pan_card'] !== NULL){
                    $image = ltrim($images['pan_card'], '/');
                    if(is_file('./assets/uploads/'.$image))
                    {
                        unlink('./assets/uploads/'.$image);
                    }
                }
            }
        } 
        return $this->db->where('id', $id)->update('turf_owner',$data); 
	}
}

?>