<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Turf_category extends CI_Controller {
	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }
    public function isAdminLoggedIn()
	{
        if($this->session->userdata('usertype') !== 'admin' && $this->session->userdata('usertype') !== 'staff')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Turf Category';
		$data['countries'] = $this->model->getResultData('countries',[]);
        $page = 'turf_category/index';
        $this->header_and_footer($page, $data);
    }
	
  
	public function addTurfCategory()
    {
		$array = array(
			'name' => $_POST['name'],
		);
		
		if($this->turf_category_model->addTurfCategory($array))
		{  
			$lead_id = $this->db->insert_id();
			$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','turf category');
			echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
		} 
		
    }
	public function viewTurfCategory()
    {
		$data['list'] = $this->model->getResultData('turf_category',[]);
		$this->load->view('turf_category/tb',$data);
    }
	public function editTurfCategory()
    {
        $response=array();
		$data = $this->model->getRowData('turf_category',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'name' => $data['name'],
			'icon' => base_url('assets/uploads/'.$data['icon'].''),
		);
		echo json_encode($response);
    }
	public function updateTurfCategory()
    {
			if(isset($_POST['id']))
			{
				$array = array(
					'name' => $_POST['name'],
				);
				
				if($this->turf_category_model->updateTurfCategory($array,$_POST['id']))
				{
					$lead_id = $_POST['id'];
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','turf category');

					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
		}
    public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Turf Category Detail';
		$data['data'] = $this->model->getRowData('turf_category',['id'=>$id]);
        $page = 'turf_category/detail';
        $this->header_and_footer($page, $data);
    }
	
   	
}
