<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Turf_booking extends CI_Controller {
	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }
    public function isAdminLoggedIn()
	{
        if($this->session->userdata('usertype') !== 'admin' && $this->session->userdata('usertype') !== 'staff')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Turf Booking';
		$data['users'] = $this->model->getResultData('user',['is_suspended'=>0]);
		if($this->session->userdata('usertype') == 'turf_owner'){
			$where = ['turf_owner_id'=>$this->session->userdata('id'),'is_disable'=>0];
			
		}else{
			$where = ['turf_owner_id'=>$_POST['turf_owner_id'],'is_disable'=>0];
		}
		$data['turfs'] = $this->model->getResultData('turf',$where);
		$data['time_slots'] = $this->time_slot_model->getTimeSlotResultDataByOwnerId();
		
        $page = 'turf_booking/index';
        $this->header_and_footer($page, $data);
    }
	
  
	public function addTurfBooking()
    {
		if($this->model->countData('turf_booking',[]) > 0){
			$number = $this->model->getRowData('turf_booking',[],null,'id','DESC')['id'] + 1;
			$number = sprintf('%03d',$number);
		}else{
			$number = sprintf('%03d',1);
		}
		$order_id = 'TURF'.$number;

		$array = array(
			'booking_id' => $order_id,
			'turf_id' => $_POST['turf_id'],
			'user_id' => $_POST['user_id'],
			'time_slot_id' => implode(',', $_POST['time_slot_id']),
			'amount' => $_POST['amount'],
			'status' => $_POST['status'],
		);
		
		if($this->model->add('turf_booking',$array))
		{  
			$lead_id = $this->db->insert_id();
			$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','turf price');
			echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
		} 
		
    }
	public function viewTurfBooking()
    {
		$data['list'] = $this->turf_booking_model->getTurfBookingResultData();
		$this->load->view('turf_booking/tb',$data);
    }
	public function editTurfBooking()
    {
        $response=array();
		$data = $this->model->getRowData('turf_booking',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'turf_id' => $data['turf_id'],
			'user_id' => $data['user_id'],
			'time_slot_id' => $data['time_slot_id'],
			'amount' => $data['amount'],
			'status' => $data['status'],
		);
		echo json_encode($response);
    }
	public function fetchAmount()
	{
		$response = array();
		if(isset($_POST['time_slot_ids'])){
			$time_slot_ids = $_POST['time_slot_ids'];
		
			$total_amount = 0;
			foreach($time_slot_ids as $time_slot_id) {
				$data = $this->model->getRowData('turf_price', ['time_slot_id' => $time_slot_id]);
				$total_amount += $data['amount'];
			}
		}else{
			$total_amount= 0;
		}
		

		$response = array(
			'total_amount' => $total_amount,
		);
		echo json_encode($response);
	}
	public function updateTurfBooking()
    {
			if(isset($_POST['id']))
			{
				$array = array(
					'turf_id' => $_POST['turf_id'],
					'user_id' => $_POST['user_id'],
					'time_slot_id' => implode(',', $_POST['time_slot_id']),
					'amount' => $_POST['amount'],
					'status' => $_POST['status'],
				);
				
				if($this->model->edit('turf_booking',$array,['id'=>$_POST['id']]))
				{
					$lead_id = $_POST['id'];
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','turf price');

					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
		}
    public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Turf Booking Detail';
		$data['data'] = $this->turf_booking_model->getTurfBookingRowData($id);
        $page = 'turf_booking/detail';
        $this->header_and_footer($page, $data);
    }
	
   	
}
