<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Time_slot extends CI_Controller {
	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }
    public function isAdminLoggedIn()
	{
        if($this->session->userdata('usertype') !== 'admin' && $this->session->userdata('usertype') !== 'staff')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Time Slot';
		if($this->session->userdata('usertype') == 'turf_owner'){
			$where = ['turf_owner_id'=>$this->session->userdata('id'),'is_disable'=>0];
			
		}else{
			$where = ['turf_owner_id'=>$_POST['turf_owner_id'],'is_disable'=>0];
		}
		$data['turfs'] = $this->model->getResultData('turf',$where);
        $page = 'time_slot/index';
        $this->header_and_footer($page, $data);
    }
	
  
	public function addTimeSlot()
    {
		$countSlotName = $this->model->countData('time_slot',['slot_name'=>$_POST['slot_name']]);
		if($countSlotName > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Slot already exist']);
		}
		else
		{
			$array = array(
				'turf_id' => $_POST['turf_id'],
				'slot_name' => $_POST['slot_name'],
			);
			
			if($this->model->add('time_slot',$array))
			{  
				$lead_id = $this->db->insert_id();
				$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','time slot');
				echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
			} 
		}
		
    }
	public function viewTimeSlot()
    {
		$data['list'] = $this->time_slot_model->getTimeSlotResultData();
		$this->load->view('time_slot/tb',$data);
    }
	public function editTimeSlot()
    {
        $response=array();
		$data = $this->model->getRowData('time_slot',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'turf_id' => $data['turf_id'],
			'slot_name' => $data['slot_name'],
		);
		echo json_encode($response);
    }
	public function updateTimeSlot()
    {
		$countSlotName = $this->model->countData('time_slot',['slot_name'=>$_POST['slot_name'],'id!='=>$_POST['id']]);
		if($countSlotName > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Slot already exist']);
		}
		else
		{
			if(isset($_POST['id']))
			{
				$array = array(
					'turf_id' => $_POST['turf_id'],
					'slot_name' => $_POST['slot_name'],
				);
				
				if($this->model->edit('time_slot',$array,['id'=>$_POST['id']]))
				{
					$lead_id = $_POST['id'];
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','time slot');

					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
		}
		}
    public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Time Slot Detail';
		$data['data'] = $this->time_slot_model->getTimeSlotRowData($id);
        $page = 'time_slot/detail';
        $this->header_and_footer($page, $data);
    }
	
   	
}
