<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Settings extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn(){
        $is_logged_in = $this->session->userdata('logged_in');
        if(!isset($is_logged_in) || $is_logged_in!==TRUE && $this->session->userdata('usertype') != 'admin')
        {
            redirect(base_url());
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	
	public function index()
    {
        $data['title'] = 'Settings';
		$data['data'] = $this->model->getRowData('settings',[]);
		$data['vendors'] = $this->model->getResultData('vendor',['is_disable'=>0]);
        $page = 'settings/index';
        $this->header_and_footer($page, $data);
    }
	public function updateSettings()
    {
        if(isset($_POST))
		{
			$array = array(
				'phone' => $_POST['phone'],
				'email' => $_POST['email'],
				'address' => $_POST['address'],
				'advertisement' => $_POST['advertisement'],
				'map_address' => $_POST['map_address'],
				'banner_text1' => $_POST['banner_text1'],
				'banner_text2' => $_POST['banner_text2'],
				'link_type1' => $_POST['link_type1'],
				'link_type2' => $_POST['link_type2'],
				'link_type3' => $_POST['link_type3'],
				'link_type4' => $_POST['link_type4'],
				// 'slider1_link' => $_POST['slider1_link'],
				// 'slider2_link' => $_POST['slider2_link'],
				// 'slider3_link' => $_POST['slider3_link'],
				// 'slider4_link' => $_POST['slider4_link'],
			);
            if($_POST['link_type1'] == 'web_link'){
                $array['slider1_link'] = $_POST['slider1_link'];
            }else if($_POST['link_type1'] == 'mobile_app_link'){
                $array['slider1_link'] = $_POST['vendor_id1'];
            }
            if($_POST['link_type2'] == 'web_link'){
                $array['slider2_link'] = $_POST['slider2_link'];
            }else if($_POST['link_type2'] == 'mobile_app_link'){
                $array['slider2_link'] = $_POST['vendor_id2'];
            }
            if($_POST['link_type3'] == 'web_link'){
                $array['slider3_link'] = $_POST['slider3_link'];
            }else if($_POST['link_type3'] == 'mobile_app_link'){
                $array['slider3_link'] = $_POST['vendor_id3'];
            }
            if($_POST['link_type4'] == 'web_link'){
                $array['slider4_link'] = $_POST['slider4_link'];
            }else if($_POST['link_type4'] == 'mobile_app_link'){
                $array['slider4_link'] = $_POST['vendor_id4'];
            }
            // echo "<pre>";print_r($array);die();
			$this->settings_model->updateSettings($array);
		}
    }
   
	}
