<style>
  .field {
    position: relative;
    margin: 10px;
}

.field i.bi {
    position: absolute;
    top: 5px;
    right: 5px;
}
button[type=button] {
    background: #1bbd36;
    border: 0;
    padding: 10px 24px;
    color: #fff;
    transition: 0.4s;
    border-radius: 4px;
}
</style>
  <main id="main">

    <!-- ======= Breadcrumbs ======= -->
    <section id="breadcrumbs" class="breadcrumbs">
      <div class="container">

        <div class="d-flex justify-content-between align-items-center">
          <h2><?= $title; ?></h2>
          <ol>
            <li><a href="<?= base_url(); ?>">Home</a></li>
            <li><?= $title; ?></li>
          </ol>
        </div>

      </div>
    </section><!-- End Breadcrumbs -->

    <!-- ======= Contact Section ======= -->
    <section id="contact" class="contact">
      <div class="container">
        <div class="row mt-5 justify-content-center" data-aos="fade-up">
          <div class="col-lg-5">
			<div class="register-form">
				<div class="my-3">
					<div class="loading">Loading</div>
					<div class="error-message"></div>
					<div class="sent-message">Logged in Successfully...</div>
				</div>
				<div id="mobile-form">
				<div class="row">
					<!--Mobile verification-->
					<div class="col-md-12 form-group">
					<input type="text" pattern="[1-9]{1}[0-9]{9}" title="Enter 10 digit mobile number" class="form-control" placeholder="Mobile number" name="mobile" id="mobile" required>
					</div>
					<div class="text-center"><button type="button" id="mobile-btn">Get Otp</button></div>
				</div>
				
				</div>
				<div id="otp-form" style="display:none">
				<div class="row">
					<!--Mobile verification-->
					<div class="col-md-12 form-group">
						<input type="number" class="form-control" name="otp_mobile" id="otp_mobile" readonly>
					</div>
					<div class="col-md-12 form-group">
						<input type="number" class="form-control" name="otp" id="otp" placeholder="Enter otp">
					</div>
					<div class="text-center"><button type="button" id="otp-btn">Verify</button></div>
				</div>
				</div>
			</div>
          </div>

        </div>

      </div>
    </section><!-- End Contact Section -->

  </main><!-- End #main -->
<script>
	$("#mobile-btn").click(function(e){
    e.preventDefault();
    $.ajax({
        url: '<?= base_url('login/generateOtp');?>',
        type: 'post',
        data: {mobile:$('#mobile').val()},
        dataType: 'json',
        beforeSend: function() {
                    $("#mobile-btn").attr("disabled", true);
                    $("#mobile-btn").html("Generating...");
                }, 
        success: function(res) {
                    if(res.return == true){
                        // $(".error").hide();
                        $('#mobile-btn').removeAttr("disabled");
                        $('#mobile-btn').html("Get otp");
                        
                        $('#otp-btn').html("Verify"+res.msg);
                        $('#otp_mobile').val($('#mobile').val());
                        $("#mobile-form").slideUp();
                        $("#otp-form").fadeIn();
                    }else{
                        $('#mobile-btn').removeAttr("disabled");
                        $('#mobile-btn').html("Get otp");
                        
                        $(".error-message").html(res.msg);
                        $(".error-message").show();

                    }          
                },
        error: function (response) {
            
            $(".error-message").show();
            $(".error-message").html('<i class="fas fa-times text-danger"></i>&nbsp;Something went wrong!!');
            $('#mobile-btn').removeAttr("disabled");
            $('#mobile-btn').html("Verify");
                }
    });
});
//Verify otp
$("#otp-btn").click(function(e){
    e.preventDefault();
    $.ajax({
        url: '<?= base_url('login/verifyOtp');?>',
        type: 'post',
        data: {mobile:$('#mobile').val(),otp:$('#otp').val()},
        dataType: 'json',
        beforeSend: function() {
                    $("#otp-btn").attr("disabled", true);
                    $("#otp-btn").html("Verifying...");
                }, 
        success: function(res) {
                    if(res.return == true){   
                        UserLogin();
                    }else{
                        $('#otp-btn').removeAttr("disabled");
                        $('#otp-btn').html("Verify"+res.msg);
                        
                        $(".error-message").show();
                        $(".error-message").html('<i class="fas fa-times text-danger"></i>&nbsp;'+res.msg);
                    }          
                },
        error: function (response) {
            $(".error-message").show();
            $(".error-message").html('<i class="fas fa-times text-danger"></i>&nbsp;Something went wrong!!');
            $('#otp-btn').removeAttr("disabled");
            $('#otp-btn').html("Verify");
                }
    });
});
function UserLogin()
{
    var mobile = $('#mobile').val();
    $.ajax({
      type: "POST",
      url : "<?= base_url('login/UserLogin');?>",
      dataType: "JSON",
      data : "mobile="+mobile,
      cache : false,
      beforeSend: function() {
        $("#otp-btn").attr("disabled",true);    
        $("#otp-btn").html('Loading..');      
    }, 
      success: function(res)
      {
        if(res.return)
        {
            $(".error-message").hide();
            $(".sent-message").show();
            $("#otp-btn").html('<i class="fa fa-circle-o-notch fa-spin"></i> Redirecting...');
            setTimeout(function(){
                window.location = "<?= base_url(); ?>";
            },2000);
        }
        else
        {
            $(".error-message").html(res.msg);
            $(".error-message").show();
            $(".sent-message").hide();
            $("#otp-btn").removeAttr("disabled"); 
            $("#otp-btn").html('Verify');      
        }
      },
      error: function (jqXHR, exception) {
        var msg = '';
        if (jqXHR.status === 0) {
            msg = 'Not connect.\n Verify Network.';
        } else if (jqXHR.status == 404) {
            msg = 'Requested page not found. [404]';
        } else if (jqXHR.status == 500) {
            msg = 'Internal Server Error [500].';
        } else if (exception === 'parsererror') {
            msg = 'Requested JSON parse failed.';
        } else if (exception === 'timeout') {
            msg = 'Time out error.';
        } else if (exception === 'abort') {
            msg = 'Ajax request aborted.';
        } else {
            msg = 'Uncaught Error.\n' + jqXHR.responseText;
        }
        $(".error-message").html(msg);
            $(".error").show();
    },
    });
};
</script>