<script>
    $(document).ready(function() {
      if($('#usertype').val() == 'admin'){
        $('#mytable').DataTable({
          dom: 'Bfrtip',
        buttons: [
          { extend: 'pdf', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3]}, },
          { extend: 'excel', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3]}, },
          { extend: 'csv', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3]}, },
        ]});
      }else{
        $('#mytable').DataTable();
      }
    } );
</script>
<table class="table table-bordered" id="mytable">
  <thead>
    <tr>
      <th scope="col">Lead.No.</th>
      <th scope="col">Candidates</th>
      <th scope="col">Resume</th>
      <th scope="col">Qualification</th>
      <th scope="col">Employement Status</th>
      <th scope="col">Applied Position</th>
      <th scope="col">Work Experience</th>
      <th scope="col">About Yourself</th>
      <th scope="col">Action</th>
    </tr>
  </thead>
  <tbody>
    <?php $i=1; foreach($list as $val){
      $candidate = $this->model->getRowData('candidate',['id'=>$val['candidate_id']]);
      $job = $this->model->getRowData('job',['id'=>$val['job_id']]);
      ?>
    <tr>
      <th scope="row"><?= $val['id']; ?></th>
      <td><?= $candidate['fullname']; ?></td>
      <td><img src="<?= base_url('assets/uploads/'.$val['resume'].'') ?>" height="70"></td>
      <td><?= $val['qualification']; ?></td>
      <td><?= $val['status']; ?></td>
      <td><?= $job['name']; ?></td>
      <td><?= $val['experience']; ?></td>
      <td><?= $val['about']; ?></td>
      <td>
        <a href="<?= base_url('resume-detail/'.$val['id'].'') ?>" class="btn btn-primary btn-sm" target="_blank">View</a>  
        <a href="javascript:void(0)" class="btn btn-primary btn-sm edit-btn edit-btn" onclick="editResume(<?= $val['id']; ?>)" data-bs-toggle="modal" data-bs-target="#editResumeModal">Edit</a>
        <?php if($val['is_disable'] == '0'){ ?>
            <a href="javascript:void(0)" class="btn btn-danger btn-sm disable-btn disable-btn" onclick="changeStatus(<?= $val['id']; ?>,'1')">Disable</a>
        <?php } else{ ?>
            <a href="javascript:void(0)" class="btn btn-success btn-sm disable-btn disable-btn" onclick="changeStatus(<?= $val['id']; ?>,'0')">Enable</a>
        <?php } ?>
        <?php
          if ($val['resume_status'] == 'accepted') {
              ?>
              <a href="javascript:void(0)" class="btn btn-danger btn-sm resume-status-btn resume-status-btn" onclick="changeResumeStatus(<?= $val['id']; ?>, 'cancelled')">Cancel</a>
              <?php
          } elseif ($val['resume_status'] == 'cancelled') {
              ?>
              <a href="javascript:void(0)" class="btn btn-success btn-sm resume-status-btn resume-status-btn" onclick="changeResumeStatus(<?= $val['id']; ?>, 'opened')">Open</a>
              <?php
          } elseif ($val['resume_status'] == 'opened') {
              ?>
              <a href="javascript:void(0)" class="btn btn-primary btn-sm resume-status-btn resume-status-btn" onclick="changeResumeStatus(<?= $val['id']; ?>, 'accepted')">Accept</a>
              <?php
          }
          ?>

      </td>
    </tr>
    <?php } ?>
  </tbody>
</table>
<script>
function changeStatus(id,type)
{
  if (confirm('Are you sure?') == true) {
    var table = 'resume';
    var column = 'is_disable';
    $.ajax({
        url: "<?= base_url('Dashboard/Status'); ?>",
        method: "POST",
        data: {
            id:id,
            type:type,
            table:table,
            column:column,
            module:'resume'
        },
        dataType:'json',
        success:function(res){
          if(res.return)
          {
            $("#tb").load("<?= base_url('resume/viewResume/') ?>")
            toastr.success(res.msg);
          }
          else
          {          
            toastr.error(res.msg);
          }
        }
    });
  }
};
function changeResumeStatus(id,type)
{
  if (confirm('Are you sure?') == true) {
    var table = 'resume';
    var column = 'resume_status';
    $.ajax({
        url: "<?= base_url('Dashboard/Status'); ?>",
        method: "POST",
        data: {
            id:id,
            type:type,
            table:table,
            column:column,
            module:'resume'
        },
        dataType:'json',
        success:function(res){
          if(res.return)
          {
            $("#tb").load("<?= base_url('resume/viewResume/') ?>")
            toastr.success(res.msg);
          }
          else
          {          
            toastr.error(res.msg);
          }
        }
    });
  }
};
</script>