        <div class="page-body">
          <div class="container-fluid">
            <div class="page-title">
              <div class="row">
                <div class="col-6">
                  <h3><?= $title; ?></h3>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid starts-->
          <div class="container-fluid">
            <div class="row">
              <div class="col-sm-12">
                <div class="card">
                  <div class="card-header">
                  <div class="row">
                  <div class="col-sm-6">
                    <h5><?= $title; ?></h5>
                  </div>
                  <div class="col-sm-6 text-right">
                    <button class="btn btn-success rounded add-btn" type="button" onclick="addCenter()"><i class="fa fa-plus"></i> Add <?= $title; ?></button>
                   </div>
                 </div>
                  </div>
                  <div class="card-body">
                    <div class="table-responsive" id="tb">
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- Container-fluid Ends-->
        </div>
        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form class="form-bookmark" id="add-form">
                  <div class="row g-2">
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Name <span class="text-danger">*</span></label>
                      <input class="form-control" id="name" type="text" name="name" required>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Mobile <span class="text-danger">*</span></label>
                      <input name="mobile"  id="mobile" class="form-control" type="text" pattern="[1-9]{1}[0-9]{9}" title="Enter 10 digit contact number" placeholder="Mobile number" maxlength="10"  required>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Email<span class="text-danger">*</span></label>
                      <input class="form-control" id="email" type="email" name="email" required>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Password <span class="text-danger">*</span></label>
                      <input class="form-control" id="password" type="password" name="password" required>
                    </div>        
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Address</label>
                      <textarea class="form-control" id="address" name="address"></textarea>
                    </div>           
                  </div>
                  <button class="btn btn-secondary" type="submit">Add</button>
                  <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
                </form>
              </div>
            </div>
          </div>
        </div>

        <!-- Modal -->
        <div class="modal fade modal-bookmark" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Edit <?= $title; ?></h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
              <form class="form-bookmark" id="edit-form">
                  <div class="row g-2">
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Name <span class="text-danger">*</span></label>
                      <input class="form-control" id="e_name" type="text" name="name" required>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Mobile <span class="text-danger">*</span></label>
                      <input name="mobile"  id="e_mobile" class="form-control" type="text" pattern="[1-9]{1}[0-9]{9}" title="Enter 10 digit contact number" placeholder="Mobile number" maxlength="10"  required>
                    </div>
                    <div class="mb-3 mt-0 col-md-6">
                      <label for="bm-title">Email <span class="text-danger">*</span></label>
                      <input class="form-control" id="e_email" type="email" name="email" required>
                    </div>   
                    <div class="mb-3 mt-0 col-md-12">
                      <label for="bm-title">Address</label>
                      <textarea class="form-control" id="e_address" name="address"></textarea>
                    </div>      
                  </div>
                  <input type="hidden" id="e_id" name="id">
                  <button class="btn btn-secondary" type="submit">Update</button>
                  <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
              </form>
              </div>
            </div>
          </div>
        </div>
<!-- Modal -->
<div class="modal fade modal-bookmark" id="changePasswordModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="exampleModalLabel">Change Password</h5>
              <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <form class="form-bookmark" id="change-password-form">
                <div class="row g-2">
                  <div class="mb-3 mt-0 col-md-6">
                    <label for="bm-title">New Password</label>
                    <input class="form-control" id="new_password" type="password" required="">
                  </div>
                  <div class="mb-3 mt-0 col-md-6">
                    <label for="bm-title">Confirm Password</label>
                    <input class="form-control" id="confirm_password" type="password" required="">
                  </div>
                  <input type="hidden" id="center_id">
                </div>
                <button class="btn btn-secondary submit-btn" type="submit">Save</button>
                <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Cancel</button>
              </form>
            </div>
          </div>
        </div>
      </div>
<script>
  function addCenter()
  {
    $('#addModal').modal('toggle'); 
    $('#add-form')[0].reset();
  }
$(document).ready(function(){
  $('#addModal').modal({
           backdrop: 'static',
           keyboard: false
    })
    $('#editModal').modal({
           backdrop: 'static',
           keyboard: false
    })
  $('#tb').load('<?= base_url('center/viewCenter'); ?>');
});


$("#add-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('center/addCenter'); ?>",
      method: "POST",
      data: new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#addModal').modal('toggle'); 
          $('#add-form')[0].reset();
          $('#tb').load('<?= base_url('center/viewCenter'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
        
      }
  });
})
function editCenter(id)
{
  $.ajax({
      url: "<?= base_url('center/editCenter'); ?>",
      method: "POST",
        dataType: 'json',
      data: {
          id:id
      },
      success:function(res){
          $("#e_id").val(res.id);
          $("#e_name").val(res.name);
          $("#e_mobile").val(res.mobile);
          $("#e_email").val(res.email);
          $("#e_address").val(res.address);
      }
  });
};
$("#edit-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('center/updateCenter'); ?>",
      method: "POST",
      data: new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#editModal').modal('toggle'); 
          $('#add-form')[0].reset();
          $('#tb').load('<?= base_url('center/viewCenter'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
      }
  });
})
function changePassword(id)
{
  $('#changePasswordModal').modal('toggle'); 
  $('#center_id').val(id); 
};
$("#change-password-form").submit(function(e){
  e.preventDefault();
  disableButton();
  if($('#new_password').val() !== $('#confirm_password').val()){
    toastr.error("New Password and confirm password does not match");
    return false;
  }
  $.ajax({
      url: "<?php echo base_url('center/changePassword'); ?>",
      method: "POST",
      data: {
          id:$('#center_id').val(),
          password:$('#new_password').val()
      },
      success:function(res){
        enableButton();
        $('#changePasswordModal').modal('toggle'); 
        $('#change-password-form')[0].reset();
        $('#tb').html(res);
        toastr.success("Password Changed Successfully");
      }
  });
});
</script>