<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pass extends CI_Controller {
	public function __construct()
    {
        parent::__construct();

        $this->isAdminLoggedIn();
    }
    public function isAdminLoggedIn()
	{
        if($this->session->userdata('usertype') !== 'admin' && $this->session->userdata('usertype') !== 'staff')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Pass Type';
        $page = 'pass_type/index';
        $this->header_and_footer($page, $data);
    }
	public function addPassType()
    {
		if($_POST['name'])
		{
			$array = array(
				'name' => $_POST['name'],
				// 'no_of_days' => $_POST['no_of_days'],
				// 'amount' =>  $_POST['amount'],
				// 'gender' => $_POST['gender'],
				'daily_amount' =>  $_POST['daily_amount'],
				'9day_amount' =>  $_POST['9day_amount'],
			);
			if($this->model->add('pass_type',$array))
			{
				echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
			}
			
		}
    }
	public function viewPassType()
    {
		$data['list'] = $this->model->getResultData('pass_type',[]);
		$this->load->view('pass_type/tb',$data);
    }
	public function editPassType()
    {
        $response=array();
		$data = $this->model->getRowData('pass_type',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'name' => $data['name'],
			// 'no_of_days' => $data['no_of_days'],
			// 'amount' =>  $data['amount'],
			// 'gender' => $data['gender'],
			'daily_amount' =>  $data['daily_amount'],
			'nine_day_amount' =>  $data['9day_amount'],
		);
		echo json_encode($response);
    }
	public function updatePassType()
    {
		if(isset($_POST['id']))
		{
			$array = array(
				'name' => $_POST['name'],
				// 'no_of_days' => $_POST['no_of_days'],
				// 'amount' =>  $_POST['amount'],
				// 'gender' => $_POST['gender'],
				'daily_amount' =>  $_POST['daily_amount'],
				'9day_amount' =>  $_POST['9day_amount'],
			);
			if($this->model->edit('pass_type',$array,['id' => $_POST['id']]))
			{
				echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
			}
			
		}
    }
    public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Pass Type Detail';
		$data['data'] = $this->model->getRowData('pass_type',['id'=>$id]);
        $page = 'pass_type/detail';
        $this->header_and_footer($page, $data);
    }
    
		
}
