<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Interview extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn(){
        if($this->session->userdata('usertype') !== 'admin' && $this->session->userdata('usertype') !== 'staff')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }

	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }

	//
	public function index()
	{
		if($this->uri->segment(2))
		$data['title'] = 'Interview';
		$data['candidates'] = $this->resume_model->getResumeResultData();
		$page = 'interview/index';
		$this->header_and_footer($page,$data);
	}
	public function addInterview()
	{
		if(isset($_POST['candidate_id']))
		{
				$array = array(  
					'candidate_id' => $_POST['candidate_id'],
					'date' => $_POST['date'],
					'time' => $_POST['time'],
					'address' => $_POST['address'],
				);
			if($this->model->add('interview',$array))
			{
				echo json_encode(['return'=>true,'msg'=>'Contact Added Successfully']);
			}
		}
	}
	
	
	public function viewInterview()
	{
		$data['list'] = $this->interview_model->getInterviewResultData();
		$this->load->view('interview/tb',$data);
	}
	public function editInterview()
	{
		$response=array();
		$data = $this->model->getRowData('interview',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'candidate_id' => $data['candidate_id'],
			'date' => $data['date'],
			'time' => $data['time'],
			'address' => $data['address'],
		);
		echo json_encode($response);
	}
	public function updateInterview()
	{
		// $id = $this->uri->segment(2);
		// // print_r('working');
		// // exit();
		if(isset($_POST['id']))
		// // echo 'working';
		// // exit();
		{
			$array = array(
				'candidate_id' => $_POST['candidate_id'],
				'date' => $_POST['date'],
				'time' => $_POST['time'],
				'address' => $_POST['address'],
			);
			if($this->interview_model->updateInterview($array,$_POST['id']))
			{
				echo json_encode(['return'=>true,'msg'=>'Contact Updated Successfully']);
			}
			else{
				echo json_encode(['return'=>false,'msg'=>'not updated!']);
			}
		}
		else{
			echo json_encode(['return'=>false, 'msg'=>'something wrong`s there!']);
		}
			
	}
	
	public function InterviewDetail()
	{
		$id=$this->uri->segment(2);
		$data['title'] = 'Interview Detail';
		$data['data'] = $this->interview_model->getInterviewRowData($id);
		$page = 'interview/detail';
		$this->header_and_footer($page, $data);
	}
	function contactDeletes(){
		// die('A');
		// exit();
		$id = $this->uri->segment(2);
		if($this->model->deleteData('contacts',['id'=>$id])){
			
			echo json_encode(['return'=>true,'msg'=>'Contact Deleted Successfully']);
		}
		
		else
		   {
			echo json_encode(['return'=>false,'msg'=>'Something went wrong there!']);
		}

}
public function remindInterview()
	{
		$users = $this->interview_model->getInterview();
		foreach($users as $interview){
			$id = $interview['id'];
		}
				$array = array(  
					'interview_id' => $interview['id'],
				);
			if($this->model->add('reminder',$array))
			{
				echo json_encode(['return'=>true,'msg'=>'Candidate Added in Reminder']);
			}
			
	}
	public function reminder(){
			$data['title'] = 'Interview Reminder';
			$data['list'] = $this->model->getResultData('reminder',['id!='=>'']);
			$page = 'interview/reminder';
			$this->header_and_footer($page, $data);
	}
	// public function checkInterview() {
    //     // Get today's date
    //     $today = date('m-d');
	// 	$candidates = $this->interview_model->getInterview();
    //     foreach ($candidates as $candidate) {
	// 		$date = date('m-d',strtotime($candidate['date']));
	// 		$fullname = $user['fullname'];
	// 		$id = $user['id'];
	// 		$user_id = $user['user_id'];
	// 		if($today == $date)  
	// 		{
	// 			echo $message = "Today is Your Interview Day, " . $fullname . "!";
	// 			// echo 'conditions working';
	// 			//sms code
	// 			$data=array(
	// 				'contact_id' => $user['id'],
	// 				'user_id' => $user['user_id'],
	// 				'type' => 'Birthday',	
	// 			);
	// 			if($this->model->add('wishRecords',$data))
	// 				{
	// 					echo json_encode(['return'=>true,'msg'=>'wishing Successfully']);
	// 				}

	// 		}
	// 		else{
	// 			echo 'Today`s not the birthday of any contacts';
	// 		}
    //     } 
    // }
	// public function checkAnniversary() {
    //     // Get today's date
    //     $today = date('m-d');
	// 	$users = $this->contact_model->getBirthday();
    //     foreach ($users as $user) {
	// 		$doa = date('m-d',strtotime($user['doa']));
	// 		$fullname = $user['fullname'];
	// 		$id = $user['id'];
	// 		$user_id = $user['user_id'];
	// 		if($today == $doa)  
	// 		{
	// 			echo $message = "Happy Anniversary, " . $fullname . "!";
	// 			// echo 'conditions working';
	// 			//sms code
	// 			$data=array(
	// 				'contact_id' => $user['id'],
	// 				'user_id' => $user['user_id'],
	// 				'type' => 'Anniversary',	
	// 			);
	// 			if($this->model->add('wishRecords',$data))
	// 				{
	// 					echo json_encode(['return'=>true,'msg'=>'wishing Successfully']);
	// 				}

	// 		}
	// 		else{
	// 			echo 'Sorry! Today`s not the Anniversary of any contacts';
	// 		}
    //     } 
    // }
	// public function viewRecord()
    // {
	// 	$data['list'] = $this->model->getResultData('wishRecords',['id!='=>'']);
	// 	$page = 'contact/wishTable';
	// 	$this->header_and_footer($page, $data);
    // }
}
