  <main id="main" class="main">
    <section class="section">
      <div class="row">
        <div class="col-lg-12">

          <div class="card">
              <div class="card-header mb-4">
                <div class="row">
                  <div class="col-sm-6">
                    <h4 class="text-dark"><?= $title; ?></h4>
                  </div>
                  <div class="col-sm-6" style="text-align: right;">
                    <button class="btn btn-success rounded add-btn" type="button" onclick="add()"><i class="bi bi-plus"></i> Add <?= $title; ?></button>
                  </div>
                 </div>

            </div>
            <div class="card-body">
              <!-- Table with stripped rows -->
              <div class="table-responsive" id="tb">
                    </div>
              <!-- End Table with stripped rows -->

            </div>
          </div>

        </div>
      </div>
    </section>

  </main><!-- End #main -->
  
    <!-- Add Modal -->
    <div class="modal fade modal-bookmark" id="addModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
            <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <form class="row g-3" id="add-form">
              <div class="col-md-6">
                <label class="form-label">Fullname <span class="text-danger">*</span></label>
                <input class="form-control" id="fullname" type="text" name="fullname" required>
              </div>
              <div class="col-md-6">
                <label class="form-label">Department <span class="text-danger">*</span></label>
                <input class="form-control" id="department" type="text" name="department" required>
              </div>
              <div class="col-md-6">
                <label class="form-label">Country Code <span class="text-danger">*</span></label>
                <select class="form-control select2" name="ccode"  id="ccode" required>
                    <option value="">Select</option>
                    <?php foreach (getCountryWithPhoneCode() as $ccodekey => $ccodevalue): ?>
                        <option data-atr="<?= $ccodevalue['code'].' +'.$ccodevalue['phone']?>" data-ctr="<?= $ccodevalue['name'].' (+'.$ccodevalue['phone'].')' ?>" value="<?= $ccodevalue['phone'] ?>"><?= $ccodevalue['name'].' (+'.$ccodevalue['phone'].')' ?></option>
                    <?php endforeach ?>   
                </select>
              </div>
              <div class="col-md-6">
                <label class="form-label">Mobile <span class="text-danger">*</span></label>
                <input name="mobile"  id="mobile" class="form-control" type="text" pattern="[1-9]{1}[0-9]{9}" title="Enter 10 digit contact number" placeholder="Mobile number" maxlength="10"  required>
              </div>
              <div class="col-md-6">
                <label class="form-label">Email <span class="text-danger">*</span></label>
                <input class="form-control" id="emailid" type="email" name="emailid" required>
              </div>
            
              <div class="col-md-6">
                <label class="form-label">Password <span class="text-danger">*</span></label>
                <input class="form-control" id="password" type="password" name="password" required>
              </div>
              <div class="col-md-6">
                <label class="form-label">Employee ID <span class="text-danger">*</span></label>
                <input class="form-control" id="employee_id" type="text" name="employee_id" 
                value="<?= $employeeId ?>" readonly
                required>
              </div>
              <div class="col-md-6">
                <label class="form-label">Pincode</label>
                <input class="form-control" id="pincode" name="pincode" type="text" pattern="^[1-9][0-9]{5}$" title="minimum 6 digits are allowed" maxlength="6">
              </div>
              <div class="col-md-6">
                <label class="form-label">Gender</label>
                <select class="form-control" id="gender" name="gender">
                    <option value="">Select</option>
                    <option value="Male">Male</option>
                    <option value="Female">Female</option>
                    <option value="Other">Other</option>
                </select>
              </div>
              <div class="col-md-6">
                <label class="form-label">Date of Birth</label>
                <input class="form-control" id="dob" type="date" name="dob" max="<?= date('Y-m-d',strtotime("-1 days")); ?>">
              </div>
              <div class="col-md-4">
                <label class="form-label">Country</label>
                <select name="country" class="form-control" id="country" onchange="fetch_state(this.value)">
                    <option value="">Select Country</option>
                    <?php foreach($countries as $country){ ?>
                      <option value="<?= $country['id']; ?>" required><?= $country['name']; ?></option>
                    <?php } ?>
                </select>                   
              </div>
              <div class="col-md-4">
                <label class="form-label">State</label>
                <select name="state" class="state form-control" id="state" onchange="fetch_city(this.value)">
                </select>                    
              </div>
              <div class="col-md-4">
                <label class="form-label">City</label>
                <select name="city" class="city form-control" id="city">
                </select>                 
              </div>
              <div class="col-md-12">
                <label class="form-label">Address</label>
                <textarea class="form-control" id="address" name="address"></textarea>
              </div>
              <div class="text-left">
                <button type="submit" class="btn btn-primary">Save</button>
                <button type="reset" class="btn btn-danger">Reset</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>

    <!-- Edit Modal -->
    <div class="modal fade modal-bookmark" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Add <?= $title; ?></h5>
            <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <form class="row g-3" id="edit-form">
              <div class="col-md-6">
                <label class="form-label">Fullname <span class="text-danger">*</span></label>
                <input class="form-control" id="efullname" name="fullname" type="text" required="">
              </div>
              <div class="col-md-6">
                <label class="form-label">Department <span class="text-danger">*</span></label>
                <input class="form-control" id="e_department" type="text" name="department" required>
              </div>
              <div class="col-md-6">
                <label class="form-label">Country Code <span class="text-danger">*</span></label>
                <select class="form-control select2" name="ccode"  id="e_ccode" required>
                    <option value="">Select</option>
                    <?php foreach (getCountryWithPhoneCode() as $ccodekey => $ccodevalue): ?>
                        <option data-atr="<?= $ccodevalue['code'].' +'.$ccodevalue['phone']?>" data-ctr="<?= $ccodevalue['name'].' (+'.$ccodevalue['phone'].')' ?>" value="<?= $ccodevalue['phone'] ?>"><?= $ccodevalue['name'].' (+'.$ccodevalue['phone'].')' ?></option>
                    <?php endforeach ?>   
                </select>
              </div>
              <div class="col-md-6">
                <label class="form-label">Mobile <span class="text-danger">*</span></label>
                <input name="mobile"  id="e_mobile" class="form-control" type="text" pattern="[1-9]{1}[0-9]{9}" title="Enter 10 digit mobile number" placeholder="Mobile number" required >
              </div>
              <div class="col-md-6">
                <label class="form-label">Email <span class="text-danger">*</span></label>
                <input class="form-control" id="eemailid" name="emailid" type="email" required="">
              </div>
              <div class="col-md-6">
                <label class="form-label">Gender </label>
                <select class="form-control" id="e_gender" name="gender">
                    <option value="">Select</option>
                    <option value="Male">Male</option>
                    <option value="Female">Female</option>
                    <option value="Other">Other</option>
                </select>
              </div>
              <div class="col-md-12">
                <label class="form-label">Date of Birth</label>
                <input class="form-control" id="e_dob" type="date" name="dob" max="<?= date('Y-m-d',strtotime("-1 days")); ?>">
              </div>
              <div class="col-md-6">
                <label class="form-label">Employee ID <span class="text-danger">*</span></label>
                <input class="form-control" id="e_employee_id" type="text" name="employee_id" readonly required>
              </div>
              <div class="col-md-6">
                <label class="form-label">Pincode</label>
                <input class="form-control" id="e_pincode" name="pincode" type="text" pattern="^[1-9][0-9]{5}$" title="minimum 6 digits are allowed" maxlength="6">
              </div>
              <div class="col-md-4">
                <label class="form-label">Country</label>
                  <select name="country" class="form-control" id="e_country" onchange="fetch_state(this.value)">
                      <option value="">Select Country</option>
                      <?php foreach($countries as $country){ ?>
                        <option value="<?= $country['id']; ?>" required><?= $country['name']; ?></option>
                      <?php } ?>
                  </select>                     
              </div>
              <div class="col-md-4">
                <label class="form-label">State</label>
                <select name="state" class="state form-control" id="e_state" onchange="fetch_city(this.value)">
                    <option value="">Select State</option>
                </select>                    
              </div>
              <div class="col-md-4">
                <label class="form-label">City</label>
                <select name="city" class="city form-control" id="e_city">
                    <option value="">Select City</option>
                </select>                 
              </div>
              <div class="col-md-12">
                <label class="form-label">Address</label>
                <textarea class="form-control" id="e_address" name="address"></textarea>
              </div>
              <div class="text-left">
                <input type="hidden" name="id" id="e_id">
                <button type="submit" class="btn btn-primary">Save</button>
                <button type="reset" class="btn btn-danger">Reset</button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>

    <!-- Modal -->
    <div class="modal fade modal-bookmark" id="changePasswordModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="exampleModalLabel">Change Password</h5>
              <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <form class="row g-3" id="change-password-form">
                <div class="row g-2">
                  <div class="col-md-6">
                    <label class="form-label">New Password</label>
                    <input class="form-control" id="new_password" type="password" required="">
                  </div>
                  <div class="col-md-6">
                    <label class="form-label">Confirm Password</label>
                    <input class="form-control" id="confirm_password" type="password" required="">
                  </div>
                  <div class="text-left">
                    <input type="hidden" id="staff_id">
                    <button type="submit" class="btn btn-primary">Save</button>
                    <button type="reset" class="btn btn-danger">Reset</button>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
<script>
  function add()
  {
    $('#addModal').modal('toggle'); 
    $('#add-form')[0].reset();
    $('#city').find('option:not(:first)').remove();
    $('#state').find('option:not(:first)').remove();
  }
$(document).ready(function(){  
$("#tb").html('<div class="text-center"><img src="loader.gif"></div>')
  $('#addModal').modal({
           backdrop: 'static',
           keyboard: false
    })
    $('#editModal').modal({
           backdrop: 'static',
           keyboard: false
    })
  $('#tb').load('<?= base_url('staff/viewStaff'); ?>');
});


$("#add-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('staff/addStaff'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#addModal').modal('toggle'); 
          $('#add-form')[0].reset();
          $('#tb').load('<?= base_url('staff/viewStaff'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
        
      }
  });
})

  function fetch_state(country_id,state_id) {
    $.ajax({
      url: "<?= base_url('dashboard/fetch_state'); ?>",
      method: "POST",
      data: {
        country_id: country_id,
        state_id: state_id
      },
      success: function(data) {
        if(state_id == null)
        {
          $(".state").html(data);
        }
        else
        {
          $("#e_state").html(data);
        }
      },
    });
  }
  function fetch_city(state_id,city_id) {
    $.ajax({
      url: "<?= base_url('dashboard/fetch_city'); ?>",
      method: "POST",
      data: {
        state_id: state_id,
        city_id: city_id
      },
      success: function(data) {
        if(city_id == null)
        {
          $(".city").html(data);
        }
        else
        {
          $("#e_city").html(data);
        }
      },
    });
  }
function editData(id)
{
  $.ajax({
      url: "<?= base_url('staff/editStaff'); ?>",
      method: "POST",
        dataType: 'json',
      data: {
          id:id
      },
      success:function(res){
        fetch_state(res.country,res.state);
        fetch_city(res.state,res.city);
        $("#e_id").val(res.id);
        $("#efullname").val(res.fullname);
        $("#e_department").val(res.department);
        $("#eemailid").val(res.email);
        $("#e_mobile").val(res.mobile);
        $("#e_ccode option[value='"+res.ccode+"']").attr("selected", "selected");
        $("#e_employee_id").val(res.employee_id);
        $("#e_pincode").val(res.pincode);
        $("#e_gender option[value='"+res.gender+"']").attr("selected", "selected");
        $("#e_dob").val(res.dob);
        $("#e_address").val(res.address);
        $("#e_country option[value='"+res.country+"']").attr("selected", "selected");
      }
  });
};
$("#edit-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
      url: "<?php echo base_url('staff/updateStaff'); ?>",
      method: "POST",
      data:  new FormData(this),
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#editModal').modal('toggle'); 
          $('#edit-form')[0].reset();
          $('#tb').load('<?= base_url('staff/viewStaff'); ?>');
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
        
      }
  });
})
function changePassword(id)
{
  $('#changePasswordModal').modal('toggle'); 
  $('#staff_id').val(id); 
};
$("#change-password-form").submit(function(e){
  e.preventDefault();
  disableButton();
  if($('#new_password').val() !== $('#confirm_password').val()){
    toastr.error("New Password and confirm password does not match");
    return false;
  }
  $.ajax({
      url: "<?php echo base_url('staff/changePassword'); ?>",
      method: "POST",
      data: {
          id:$('#staff_id').val(),
          password:$('#new_password').val()
      },
      success:function(res){
        enableButton();
        $('#changePasswordModal').modal('toggle'); 
        $('#change-password-form')[0].reset();
        $('#tb').html(res);
        toastr.success("Password Changed Successfully");
      }
  });
});
</script>