<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Website extends CI_Controller {
	public function __construct()
    {
        parent::__construct();

    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('website/includes/header',$data);
        $this->load->view('website/'.$page);
        $this->load->view('website/includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Home';
        $page = 'index';
        $this->header_and_footer($page, $data);
    }
	public function register()
    {
        $data['title'] = 'Candidate';
		$data['jobs'] = $this->model->getResultData('job',['is_disable'=>0]);
        if($this->session->userdata('user_logged_in')){
			$data['user'] = $this->model->getRowData('candidate',['mobile'=>$this->session->userdata('user_mobile')]);
		}
        $page = 'candidate';
        $this->header_and_footer($page, $data);
    }
    public function submitCandidate()
    {
        // if(isset($_POST['email_otp']) && (string) $_POST['email_otp'] !== (string) $this->session->userdata('email_otp') && !$this->session->userdata('user_logged_in')){
		// 	echo json_encode(['return'=>false,'msg'=>'Wrong Email Otp']);
		// }
		// else if(isset($_POST['mobile_otp']) && (string) $_POST['mobile_otp'] !== (string) $this->session->userdata('mobile_otp') && !$this->session->userdata('user_logged_in')){
		// 		echo json_encode(['return'=>false,'msg'=>'Wrong Mobile Otp']);
		// }else{
            // $countMobileAndName = $this->model->countData('register',['mobile'=>$_POST['mobile'],'fullname'=>$_POST['fullname']]);
            // if($countMobileAndName == '0'){
                if($_POST['fullname']){
                    $candidate_array = array(
                        'mobile' => $_POST['mobile'],
                        'email' => $_POST['email'],
                        'fullname' => $_POST['fullname'],
                        'gender' => $_POST['gender'],
                        'dob' => $_POST['dob'],
                        'address' => $_POST['address'],
                    );
                    $this->model->add('candidate',$candidate_array);
                    $candidate_id = $this->db->insert_id();
                    $resume_array = array(
                        'candidate_id' => $candidate_id,
                        'qualification' => $_POST['qualification'],
                        'status' => $_POST['status'],
                        'job_id' => $_POST['job_id'],
                        'experience' => $_POST['experience'],
                        'about' => $_POST['about'],
                    );
                    if($this->website_model->submitCandidate($resume_array)){   //or $this->model->add('resume',$resume_array);
                        echo json_encode(['return'=>true,'msg'=>'Registered Successfully']);
                        
                    }
                    else{
                        echo json_encode(['return'=>false,'msg'=>'Something wrong there!']);
                    }

                }
                
                
            // }else{
            //     $this->session->set_flashdata('failure','Something wrong there!');
            // }
            
        // }
        
    }


    
    public function sendOtpToMobile()
    {
		$otp=mt_rand(100000, 999999);
// 		$countMobile = $this->model->countData('user',['mobile'=>$_POST['mobile']]);
// 		if($countMobile > 0 )
// 		{
// 			echo json_encode(['return'=>false,'msg'=>'Mobile already exist']);
// 		}else{
			// $this->model->send_otp($_POST['mobile'],$otp);
			$this->session->set_userdata(array('mobile_otp' => $otp) );
			echo json_encode(['return'=>true,'msg'=>$otp.'otp has been sent to your mobile number']);
// 		}
		
    }
    public function sendOtpToMailId()
    {
		$otp=mt_rand(100000, 999999);
		$sms = '<p>Dear Applicant,</p>
		<p>Thank you for your interest in our event Registration. Please enter OTP '.$otp.' to verify this mail id.</p>

		<p>Regards,</p>
		<p>Team Greyline Classic - India</p>
		';
// 		$countEmail = $this->model->countData('user',['email'=>$_POST['email']]);
// 		if($countEmail > 0 )
// 		{
// 			echo json_encode(['return'=>false,'msg'=>'Email already exist']);
// 		}else{
			// $this->send_mail($_POST['email'],'Verification otp',$sms);
			$this->session->set_userdata(array('email_otp' => $otp) );

			echo json_encode(['return'=>true,'msg'=>$otp.'please check your mail also in spam folder to verify your mail']);
// 		}
		
		
    }
    public function checkEmailOtp(){
		if($_POST['email_otp'] == $this->session->userdata('email_otp')){
			echo json_encode(['return'=>true,'msg'=>'Otp verified']);
		}else{
			echo json_encode(['return'=>false,'msg'=>'Incorrect Otp']);
		}
	}
	
	public function checkMobileOtp(){
		if($_POST['mobile_otp'] == $this->session->userdata('mobile_otp')){
			echo json_encode(['return'=>true,'msg'=>'Otp verified']);
		}else{
			echo json_encode(['return'=>false,'msg'=>'Incorrect Otp']);
		}
	}
    public function logout(){
		$this->session->unset_userdata(array('user_logged_in','user_mobile'));
		redirect(base_url());
	}
}
