<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller {
	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }
    public function isAdminLoggedIn()
	{
        if($this->session->userdata('usertype') !== 'admin' && $this->session->userdata('usertype') !== 'staff')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Users';
		$data['jobs'] = $this->model->getResultData('job',['is_disable'=>0]);
        $page = 'user/index';
        $this->header_and_footer($page, $data);
    }
	public function sendOtpToMobile()
    {
		$otp=mt_rand(100000, 999999);
// 		$countMobile = $this->model->countData('user',['mobile'=>$_POST['mobile']]);
// 		if($countMobile > 0 )
// 		{
// 			echo json_encode(['return'=>false,'msg'=>'Mobile already exist']);
// 		}else{
			// $this->model->send_otp($_POST['mobile'],$otp);
			$this->session->set_userdata(array('mobile_otp' => $otp) );
			echo json_encode(['return'=>true,'msg'=>$otp.'otp has been sent to your mobile number']);
// 		}
		
    }
    public function sendOtpToMailId()
    {
		$otp=mt_rand(100000, 999999);
		$sms = '<p>Dear Applicant,</p>
		<p>Thank you for your interest in our event Registration. Please enter OTP '.$otp.' to verify this mail id.</p>

		<p>Regards,</p>
		<p>Team Greyline Classic - India</p>
		';
// 		$countEmail = $this->model->countData('user',['email'=>$_POST['email']]);
// 		if($countEmail > 0 )
// 		{
// 			echo json_encode(['return'=>false,'msg'=>'Email already exist']);
// 		}else{
			// $this->send_mail($_POST['email'],'Verification otp',$sms);
			$this->session->set_userdata(array('email_otp' => $otp) );

			echo json_encode(['return'=>true,'msg'=>$otp.'please check your mail also in spam folder to verify your mail']);
// 		}
		
		
    }
    public function checkEmailOtp(){
		if($_POST['email_otp'] == $this->session->userdata('email_otp')){
			echo json_encode(['return'=>true,'msg'=>'Otp verified']);
		}else{
			echo json_encode(['return'=>false,'msg'=>'Incorrect Otp']);
		}
	}
	
	public function checkMobileOtp(){
		if($_POST['mobile_otp'] == $this->session->userdata('mobile_otp')){
			echo json_encode(['return'=>true,'msg'=>'Otp verified']);
		}else{
			echo json_encode(['return'=>false,'msg'=>'Incorrect Otp']);
		}
	}
	public function addUser()
    {
		$candidate_array = array(
			'mobile' => $_POST['mobile'],
			'email' => $_POST['email'],
			'fullname' => $_POST['fullname'],
			'gender' => $_POST['gender'],
			'dob' => $_POST['dob'],
			'address' => $_POST['address'],
		);
		$this->model->add('candidate',$candidate_array);
		$candidate_id = $this->db->insert_id();
		$resume_array = array(
			'candidate_id' => $candidate_id,
			'qualification' => $_POST['qualification'],
			'status' => $_POST['status'],
			'job_id' => $_POST['job_id'],
			'experience' => $_POST['experience'],
			'about' => $_POST['about'],
		);
		if($this->website_model->submitCandidate($resume_array)){   //or $this->model->add('resume',$resume_array);
			echo json_encode(['return'=>true,'msg'=>'Registered Successfully']);
		} 
        else{
                echo json_encode(['return'=>false,'msg'=>'Already registered for this name and number']);
            }
		
		
    }
	public function viewUser()
    {
		$data['list'] = $this->model->getResultData('candidate',['fullname!='=>'']);
		$this->load->view('user/tb',$data);
    }
	public function editUser()
    {
        $response=array();
		$data = $this->model->getRowData('candidate',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'mobile' => $data['mobile'],
			'email' => $data['email'],
			'fullname' => $data['fullname'],
			'gender' => $data['gender'],
			'dob' => date('Y-m-d',strtotime($data['dob'])),
			'pincode' => $data['pincode'],
			'address' => $data['address'],
		);
		echo json_encode($response);
    }
	public function updateUser()
    {
			if(isset($_POST['id']))
			{
				$candidate_array = array(
					'mobile' => $_POST['mobile'],
					'email' => $_POST['email'],
					'fullname' => $_POST['fullname'],
					'gender' => $_POST['gender'],
					'dob' => $_POST['dob'],
					'pincode' => $_POST['pincode'],
					'address' => $_POST['address'],
				);
				$this->model->edit('candidate',$candidate_array);
				$candidate_id = $this->db->insert_id();
				$resume_array = array(
					'candidate_id' => $_POST['candidate_id'],
					'qualification' => $_POST['qualification'],
					'status' => $_POST['status'],
					'job_id' => $_POST['job_id'],
					'experience' => $_POST['experience'],
					'about' => $_POST['about'],
				);
				if($this->website_model->updateCandidate($resume_array))
					{
						$lead_id = $_POST['id'];
						$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','user detail');

						echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
					}
				else{
					echo json_encode(['return'=>false,'msg'=>'Already registered for this name and number']);
				}
				
				
			}
		}
    public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'User Detail';
		$data['data'] = $this->user_model->getUserRowData($id);
        $page = 'user/detail';
        $this->header_and_footer($page, $data);
    }
	
   	
}
