<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Resume extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn(){
        if($this->session->userdata('usertype') !== 'admin' && $this->session->userdata('usertype') !== 'staff')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }

	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }

	//Payment
	public function index()
	{
		$data['title'] = 'Resume';
		$data['candidates'] = $this->model->getResultData('candidate',['is_disable'=>0]);
		$data['jobs'] = $this->model->getResultData('job',['is_disable'=>0]);
		$page = 'resume/index';
		$this->header_and_footer($page, $data);
	}
	public function addResume()
	{
		$countCandidate = $this->model->countData('resume',['candidate_id'=>$_POST['candidate_id']]);
		if($countCandidate > 0 )
		{
			echo json_encode(['return'=>false,'msg'=>'Candidate already exist']);
		}
		else
		{
			if(isset($_POST['candidate_id']))
			{
				$resume_array = array(
					'candidate_id' => $_POST['candidate_id'],
					'qualification' => $_POST['qualification'],
					'status' => $_POST['status'],
					'job_id' => $_POST['job_id'],
					'experience' => $_POST['experience'],
					'about' => $_POST['about'],
				);
				if($this->website_model->submitCandidate($resume_array)){   //or $this->model->add('resume',$resume_array);
					echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
				}
			}
		}
	}
	
	public function viewResume()
	{
		$data['list'] = $this->model->getResultData('resume',[]);
		$this->load->view('resume/tb',$data);
	}
	public function editResume()
	{
		$response=array();
		$data = $this->model->getRowData('resume',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'candidate_id' => $data['candidate_id'],
			'resume' => base_url('assets/uploads/'.$data['resume'].''),
			'qualification' => $data['qualification'],
			'status' => $data['status'],
			'job_id' => $data['job_id'],
			'experience' => $data['experience'],
			'about' => $data['about'],
		);
		echo json_encode($response);
	}
	public function updateResume()
	{
		if(isset($_POST['id']))
		{
				$array = array(
					'candidate_id' => $_POST['candidate_id'],
					'qualification' => $_POST['qualification'],
					'status' => $_POST['status'],
					'job_id' => $_POST['job_id'],
					'experience' => $_POST['experience'],
					'about' => $_POST['about'],
				);
				if($this->resume_model->updateResume($array,$_POST['id']))
				{
					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
				else
				{
					echo json_encode(['return'=>false,'msg'=>'`id` is required']);
				}
			
			
		}
	}
	public function resumeDetail()
	{
		$id=$this->uri->segment(2);
		$data['title'] = 'resume Detail';
		$data['data'] = $this->resume_model->getResumeRowData($id);
		$page = 'resume/detail';
		$this->header_and_footer($page, $data);
	}

	public function job()
    {
        $data['title'] = 'Job';
        $page = 'job/index';
        $this->header_and_footer($page, $data);
    }
	public function addJob()
    {
			if($_POST['name'])
			{
				$array = array(
					'name' => $_POST['name'],
				);
				if($this->model->add('job',$array))
				{
					$lead_id = $this->db->insert_id();
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','job detail');

					echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
				}
				
			}
	}
    
	public function viewJob()
    {
		$data['list'] = $this->model->getResultData('job',[]);
		$this->load->view('job/tb',$data);
    }
	public function editJob()
    {
        $response=array();
		$data = $this->model->getRowData('job',['id' => $_POST['id']]);
		$response = array(
					'id' => $_POST['id'],
					'name' => $data['name'],
		);
		echo json_encode($response);
    }
	public function updateJob()
    {
			if(isset($_POST['id']))
			{
				$array = array(
					'name' => $_POST['name'],	
				);
				if($this->model->edit('job',$array,['id' => $_POST['id']]))
				{
					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
			else
			{
				echo json_encode(['return'=>false,'msg'=>'`id` is required']);
			}
			
		
    }

	
}
