<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Center extends CI_Controller {
	public function __construct()
    {
        parent::__construct();

        $this->isAdminLoggedIn();
    }
    public function isAdminLoggedIn()
	{
        if($this->session->userdata('usertype') !== 'admin' && $this->session->userdata('usertype') !== 'staff')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Center';
        $page = 'center/index';
        $this->header_and_footer($page, $data);
    }
	public function addCenter()
    {
		if($_POST['name'])
		{
			$array = array(
				'name' => $_POST['name'],
				'mobile' => $_POST['mobile'],
				'email' =>  $_POST['email'],
				'password' => md5($_POST['password']),
				'address' => $_POST['address'],
			);
			if($this->model->add('center',$array))
			{
				echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
			}
			
		}
    }
	public function viewCenter()
    {
		$data['list'] = $this->model->getResultData('center',[]);
		$this->load->view('center/tb',$data);
    }
	public function editCenter()
    {
        $response=array();
		$data = $this->model->getRowData('center',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'name' => $data['name'],
			'mobile' => $data['mobile'],
			'email' =>  $data['email'],
			'address' => $data['address'],
		);
		echo json_encode($response);
    }
	public function updateCenter()
    {
		if(isset($_POST['id']))
		{
			$array = array(
				'name' => $_POST['name'],
				'mobile' => $_POST['mobile'],
				'email' =>  $_POST['email'],
				'address' => $_POST['address'],
			);
			if($this->model->edit('center',$array,['id' => $_POST['id']]))
			{
				echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
			}
			
		}
    }
    public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Center Detail';
		$data['data'] = $this->model->getRowData('center',['id'=>$id]);
        $page = 'center/detail';
        $this->header_and_footer($page, $data);
    }
	public function changePassword()
    {
        if($_POST['id'])
		{
			if($this->model->edit('center',['password'=>md5($_POST['password'])],['id' => $_POST['id']]))
			{
				$this->viewCenter();
			}
			
		}
    }
		
}
