<?php


class Turf_model extends CI_Model
{
    public function getTurfRowData($id)
	{
        $query = $this->db
        ->select('t1.*,t2.name as country_name,t3.name as state_name,t4.name as city_name,t5.fullname as turf_owner_name,t6.name as turf_category_name')
        ->from('turf t1')
        ->join('countries t2', 't2.id = t1.country','left') 
        ->join('states t3', 't3.id = t1.state','left') 
        ->join('cities t4', 't4.id = t1.city','left') 
        ->join('turf_owner t5', 't5.id = t1.turf_owner_id','left') 
        ->join('turf_category t6', 't6.id = t1.turf_category_id','left') 
        ->where('t1.id',$id) 
        ->get();
		return $query->row_array();
	}
    public function getTurfResultData()
	{
        $this->db
        ->select('t1.*,t2.name as country_name,t3.name as state_name,t4.name as city_name,t5.fullname as turf_owner_name,t6.name as turf_category_name')
        ->from('turf t1')
        ->join('countries t2', 't2.id = t1.country','left') 
        ->join('states t3', 't3.id = t1.state','left') 
        ->join('cities t4', 't4.id = t1.city','left') 
        ->join('turf_owner t5', 't5.id = t1.turf_owner_id','left') 
        ->join('turf_category t6', 't6.id = t1.turf_category_id','left');
        if($this->session->userdata('usertype') == 'turf_owner'){
			$this->db->where(['t1.turf_owner_id'=>$this->session->userdata('id')]);
		}
        $query = $this->db->get();
		return $query->result_array();
	}
}

?>