<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller {
	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }
    public function isAdminLoggedIn()
	{
        if($this->session->userdata('usertype') !== 'admin' && $this->session->userdata('usertype') !== 'staff')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'User';
		$data['countries'] = $this->model->getResultData('countries',[]);
        $page = 'user/index';
        $this->header_and_footer($page, $data);
    }
	
  
	public function addUser()
    {
		$array = array(
			'fullname' => $_POST['fullname'],
			'mobile' => $_POST['mobile'],
			'gender' => $_POST['gender'],
			'email' => $_POST['email'],
			'dob' => $_POST['dob'],
			'country' => $_POST['country'],
			'state' => $_POST['state'],
			'city' => $_POST['city'],
			'address' => $_POST['address'],
		);
		
		if($this->model->add('user',$array))
		{  
			$lead_id = $this->db->insert_id();
			$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','user');
			echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
		} 
		
    }
	public function viewUser()
    {
		$data['list'] = $this->model->getResultData('user',[]);
		$this->load->view('user/tb',$data);
    }
	public function editUser()
    {
        $response=array();
		$data = $this->model->getRowData('user',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'fullname' => $data['fullname'],
			'mobile' => $data['mobile'],
			'gender' => $data['gender'],
			'email' => $data['email'],
			'dob' => $data['dob'],
			'country' => $data['country'],
			'state' => $data['state'],
			'city' => $data['city'],
			'address' => $data['address'],
		);
		echo json_encode($response);
    }
	public function updateUser()
    {
			if(isset($_POST['id']))
			{
				$array = array(
					'fullname' => $_POST['fullname'],
					'mobile' => $_POST['mobile'],
					'gender' => $_POST['gender'],
					'email' => $_POST['email'],
					'dob' => $_POST['dob'],
					'country' => $_POST['country'],
					'state' => $_POST['state'],
					'city' => $_POST['city'],
					'address' => $_POST['address'],
				);
				
				if($this->model->edit('user',$array,['id'=>$_POST['id']]))
				{
					$lead_id = $_POST['id'];
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','user');

					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
		}
    public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'User Detail';
		$data['data'] = $this->user_model->getUserRowData($id);
        $page = 'user/detail';
        $this->header_and_footer($page, $data);
    }
	
   	
}
