<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Turf extends CI_Controller {
	public function __construct()
    {
        parent::__construct();

        // $this->isAdminLoggedIn();
    }
    public function isAdminLoggedIn()
	{
        if($this->session->userdata('usertype') !== 'admin' && $this->session->userdata('usertype') !== 'staff')
        {
            redirect(base_url('dashboard'));
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	public function index()
    {
        $data['title'] = 'Turf';
		$data['turf_owners'] = $this->model->getResultData('turf_owner',['is_suspended'=>0]);
		$data['turf_categories'] = $this->model->getResultData('turf_category',['is_disable'=>0]);
		$data['countries'] = $this->model->getResultData('countries',[]);
        $page = 'turf/index';
        $this->header_and_footer($page, $data);
    }
	
  
	public function addTurf()
    {
		if($this->session->userdata('usertype') == 'turf_owner'){
			$turf_owner_id = $this->session->userdata('id');
		}else{
			$turf_owner_id = $_POST['turf_owner_id'];
		}
		$array = array(
			'turf_owner_id' => $turf_owner_id,
			'turf_category_id' => $_POST['turf_category_id'],
			'country' => $_POST['country'],
			'state' => $_POST['state'],
			'city' => $_POST['city'],
			'turf_name' => $_POST['turf_name'],
			'turf_location' => $_POST['turf_location'],
			'turf_contact_no' => $_POST['turf_contact_no'],
			'turf_details' => $_POST['turf_details'],
		);
		
		if($this->model->add('turf',$array))
		{  
			$lead_id = $this->db->insert_id();
			$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'add','turf');
			echo json_encode(['return'=>true,'msg'=>'Added Successfully']);
		} 
		
    }
	public function viewTurf()
    {
		$data['list'] = $this->turf_model->getTurfResultData();
		$this->load->view('turf/tb',$data);
    }
	public function editTurf()
    {
        $response=array();
		$data = $this->model->getRowData('turf',['id' => $_POST['id']]);
		$response = array(
			'id' => $_POST['id'],
			'turf_owner_id' => $data['turf_owner_id'],
			'turf_category_id' => $data['turf_category_id'],
			'country' => $data['country'],
			'state' => $data['state'],
			'city' => $data['city'],
			'turf_name' => $data['turf_name'],
			'turf_location' => $data['turf_location'],
			'turf_contact_no' => $data['turf_contact_no'],
			'turf_details' => $data['turf_details'],
		);
		echo json_encode($response);
    }
	public function updateTurf()
    {
			if(isset($_POST['id']))
			{
				if($this->session->userdata('usertype') == 'turf_owner'){
					$turf_owner_id = $this->session->userdata('id');
				}else{
					$turf_owner_id = $_POST['turf_owner_id'];
				}
				$array = array(
					'turf_owner_id' => $turf_owner_id,
					'turf_category_id' => $_POST['turf_category_id'],
					'country' => $_POST['country'],
					'state' => $_POST['state'],
					'city' => $_POST['city'],
					'turf_name' => $_POST['turf_name'],
					'turf_location' => $_POST['turf_location'],
					'turf_contact_no' => $_POST['turf_contact_no'],
					'turf_details' => $_POST['turf_details'],
				);
				
				if($this->model->edit('turf',$array,['id'=>$_POST['id']]))
				{
					$lead_id = $_POST['id'];
					$this->createLog($this->session->userdata('id'),$this->session->userdata('usertype'),$lead_id,'edit','turf');

					echo json_encode(['return'=>true,'msg'=>'Updated Successfully']);
				}
			}
		}
    public function detail()
    {
        $id=$this->uri->segment(2);
        $data['title'] = 'Turf Detail';
		$data['data'] = $this->turf_model->getTurfRowData($id);
        $page = 'turf/detail';
        $this->header_and_footer($page, $data);
    }
	
   	
}
