
            <!-- Main Content -->
            <main class="flex-grow">
                <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-10">
                    <!-- Page Header -->
                    <div class="mb-8">
                        <h1 class="text-4xl font-bold text-slate-800">Holiday Packages</h1>
                        <p class="text-slate-500 mt-2">Find the perfect curated trip for your clients.</p>
                    </div>
                    
                    <div class="flex flex-col lg:flex-row gap-8">
                        <!-- Left Sidebar: Filters -->
                        <aside class="w-full lg:w-1/4">
                            <div class="bg-white p-6 rounded-lg shadow-md border border-slate-200 sticky top-24">
                                <h3 class="text-lg font-bold mb-4">Filter Packages</h3>
                                <div class="space-y-6">
                                    <!-- Destination Filter -->
                                    <div>
                                        <label for="destination" class="block text-sm font-medium text-slate-600">Destination</label>
                                        <input type="text" id="destination" placeholder="e.g. Kerala, Goa, Dubai" class="mt-1 block w-full rounded-md border-slate-300 shadow-sm focus:border-sky-500 focus:ring-sky-500 sm:text-sm">
                                    </div>
                                    <!-- Duration Filter -->
                                    <div>
                                        <label for="duration" class="block text-sm font-medium text-slate-600">Duration (days)</label>
                                        <input type="number" id="duration" placeholder="e.g. 7" class="mt-1 block w-full rounded-md border-slate-300 shadow-sm focus:border-sky-500 focus:ring-sky-500 sm:text-sm">
                                    </div>
                                    <!-- Price Range -->
                                    <div>
                                        <label class="block text-sm font-medium text-slate-600">Price per person (₹)</label>
                                        <div class="flex items-center gap-2 mt-1">
                                            <input type="number" placeholder="Min" class="block w-full rounded-md border-slate-300 shadow-sm focus:border-sky-500 focus:ring-sky-500 sm:text-sm">
                                            <span>-</span>
                                            <input type="number" placeholder="Max" class="block w-full rounded-md border-slate-300 shadow-sm focus:border-sky-500 focus:ring-sky-500 sm:text-sm">
                                        </div>
                                    </div>
                                    <!-- Travel Theme -->
                                    <div>
                                        <label class="block text-sm font-medium text-slate-600">Theme</label>
                                        <div class="mt-2 space-y-2">
                                            <div class="flex items-center"><input type="checkbox" class="h-4 w-4 rounded border-slate-300 text-sky-600 focus:ring-sky-500"><label class="ml-2 text-sm text-slate-600">Family</label></div>
                                            <div class="flex items-center"><input type="checkbox" class="h-4 w-4 rounded border-slate-300 text-sky-600 focus:ring-sky-500"><label class="ml-2 text-sm text-slate-600">Honeymoon</label></div>
                                            <div class="flex items-center"><input type="checkbox" class="h-4 w-4 rounded border-slate-300 text-sky-600 focus:ring-sky-500"><label class="ml-2 text-sm text-slate-600">Adventure</label></div>
                                            <div class="flex items-center"><input type="checkbox" class="h-4 w-4 rounded border-slate-300 text-sky-600 focus:ring-sky-500"><label class="ml-2 text-sm text-slate-600">Religious</label></div>
                                        </div>
                                    </div>
                                    <!-- Apply Button -->
                                    <button class="w-full bg-sky-600 text-white font-bold py-2 px-4 rounded-md hover:bg-sky-700 transition-colors">Apply Filters</button>
                                </div>
                            </div>
                        </aside>
                        <!-- Right Content: Package Grid -->
                        <div class="w-full lg:w-3/4">
                            <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-6">
                                
                                <!-- Package Card 1 -->
                                <div class="bg-white rounded-lg shadow-md border border-slate-200 overflow-hidden flex flex-col hover:shadow-xl transition-shadow duration-300">
                                    <img src="https://placehold.co/600x400/10b981/ffffff?text=Kerala" alt="Kerala Backwaters" class="w-full h-48 object-cover">
                                    <div class="p-4 flex flex-col flex-grow">
                                        <h3 class="text-xl font-bold text-slate-800">Magical Kerala Backwaters</h3>
                                        <p class="text-sm text-slate-500 mt-1">5 Nights / 6 Days</p>
                                        <div class="mt-3 text-xs text-slate-600 space-y-1">
                                            <p>✓ Hotels & Houseboat</p>
                                            <p>✓ Meals & Transfers</p>
                                            <p>✓ Sightseeing in Munnar & Alleppey</p>
                                        </div>
                                        <div class="mt-auto pt-4">
                                            <p class="text-sm text-slate-500">Starts from</p>
                                            <p class="text-2xl font-bold text-orange-600">₹24,999 <span class="text-sm font-normal text-slate-500">/ person</span></p>
                                            <button class="mt-3 w-full bg-orange-500 text-white font-bold py-2 px-4 rounded-md hover:bg-orange-600 transition-colors">View Details</button>
                                        </div>
                                    </div>
                                </div>

                                <!-- Package Card 2 -->
                                <div class="bg-white rounded-lg shadow-md border border-slate-200 overflow-hidden flex flex-col hover:shadow-xl transition-shadow duration-300">
                                    <img src="https://placehold.co/600x400/f59e0b/ffffff?text=Rajasthan" alt="Rajasthan Desert" class="w-full h-48 object-cover">
                                    <div class="p-4 flex flex-col flex-grow">
                                        <h3 class="text-xl font-bold text-slate-800">Royal Rajasthan Tour</h3>
                                        <p class="text-sm text-slate-500 mt-1">7 Nights / 8 Days</p>
                                        <div class="mt-3 text-xs text-slate-600 space-y-1">
                                            <p>✓ Heritage Hotels</p>
                                            <p>✓ Breakfast & Dinner</p>
                                            <p>✓ Jaipur, Udaipur & Jodhpur Forts</p>
                                        </div>
                                        <div class="mt-auto pt-4">
                                            <p class="text-sm text-slate-500">Starts from</p>
                                            <p class="text-2xl font-bold text-orange-600">₹35,500 <span class="text-sm font-normal text-slate-500">/ person</span></p>
                                            <button class="mt-3 w-full bg-orange-500 text-white font-bold py-2 px-4 rounded-md hover:bg-orange-600 transition-colors">View Details</button>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Package Card 3 -->
                                <div class="bg-white rounded-lg shadow-md border border-slate-200 overflow-hidden flex flex-col hover:shadow-xl transition-shadow duration-300">
                                    <img src="https://placehold.co/600x400/3b82f6/ffffff?text=Goa" alt="Goa Beach" class="w-full h-48 object-cover">
                                    <div class="p-4 flex flex-col flex-grow">
                                        <h3 class="text-xl font-bold text-slate-800">Goa Beach Paradise</h3>
                                        <p class="text-sm text-slate-500 mt-1">3 Nights / 4 Days</p>
                                        <div class="mt-3 text-xs text-slate-600 space-y-1">
                                            <p>✓ 4-Star Beach Resort</p>
                                            <p>✓ Daily Breakfast</p>
                                            <p>✓ Airport Transfers</p>
                                        </div>
                                        <div class="mt-auto pt-4">
                                            <p class="text-sm text-slate-500">Starts from</p>
                                            <p class="text-2xl font-bold text-orange-600">₹15,000 <span class="text-sm font-normal text-slate-500">/ person</span></p>
                                            <button class="mt-3 w-full bg-orange-500 text-white font-bold py-2 px-4 rounded-md hover:bg-orange-600 transition-colors">View Details</button>
                                        </div>
                                    </div>
                                </div>

                                <!-- Package Card 4 -->
                                <div class="bg-white rounded-lg shadow-md border border-slate-200 overflow-hidden flex flex-col hover:shadow-xl transition-shadow duration-300">
                                    <img src="https://placehold.co/600x400/8b5cf6/ffffff?text=Thailand" alt="Thailand Temples" class="w-full h-48 object-cover">
                                    <div class="p-4 flex flex-col flex-grow">
                                        <h3 class="text-xl font-bold text-slate-800">Exotic Thailand Escape</h3>
                                        <p class="text-sm text-slate-500 mt-1">6 Nights / 7 Days</p>
                                        <div class="mt-3 text-xs text-slate-600 space-y-1">
                                            <p>✓ Flights Included</p>
                                            <p>✓ Bangkok & Pattaya Stay</p>
                                            <p>✓ Coral Island Tour</p>
                                        </div>
                                        <div class="mt-auto pt-4">
                                            <p class="text-sm text-slate-500">Starts from</p>
                                            <p class="text-2xl font-bold text-orange-600">₹45,999 <span class="text-sm font-normal text-slate-500">/ person</span></p>
                                            <button class="mt-3 w-full bg-orange-500 text-white font-bold py-2 px-4 rounded-md hover:bg-orange-600 transition-colors">View Details</button>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </main>
