
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
        .tab-active {
            border-color: #0ea5e9;
            color: #0ea5e9;
        }
    </style>
        <!-- Main Content -->
        <main class="flex-grow">
            <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-10">
                
                <!-- Package Header -->
                <div>
                    <h1 class="text-4xl font-bold text-slate-800">Magical Kerala Backwaters</h1>
                    <div class="flex items-center space-x-4 text-slate-500 mt-2">
                        <span>5 Nights / 6 Days</span>
                        <span class="text-slate-300">|</span>
                        <span>Family & Honeymoon</span>
                        <span class="text-slate-300">|</span>
                        <span>Package Code: NH-KER01</span>
                    </div>
                </div>

                <!-- Image Gallery -->
                <div class="mt-6 grid grid-cols-4 grid-rows-2 gap-2 h-96">
                    <div class="col-span-2 row-span-2 rounded-lg overflow-hidden"><img src="https://placehold.co/800x800/10b981/ffffff?text=Kerala+Houseboat" class="w-full h-full object-cover"></div>
                    <div class="col-span-1 row-span-1 rounded-lg overflow-hidden"><img src="https://placehold.co/400x400/10b981/ffffff?text=Tea+Gardens" class="w-full h-full object-cover"></div>
                    <div class="col-span-1 row-span-1 rounded-lg overflow-hidden"><img src="https://placehold.co/400x400/10b981/ffffff?text=Kathakali" class="w-full h-full object-cover"></div>
                    <div class="col-span-1 row-span-1 rounded-lg overflow-hidden"><img src="https://placehold.co/400x400/10b981/ffffff?text=Spices" class="w-full h-full object-cover"></div>
                    <div class="col-span-1 row-span-1 rounded-lg overflow-hidden"><img src="https://placehold.co/400x400/10b981/ffffff?text=Beach" class="w-full h-full object-cover"></div>
                </div>

                <div class="mt-8 flex flex-col lg:flex-row gap-8">
                    <!-- Left Column: Itinerary & Details -->
                    <div class="w-full lg:w-2/3">
                        <div class="bg-white p-6 rounded-lg shadow-md border border-slate-200">
                            <!-- Tabs Navigation -->
                            <div class="border-b border-slate-200">
                                <nav class="-mb-px flex space-x-8" id="tabs">
                                    <button class="tab-active whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">Itinerary</button>
                                    <button class="text-slate-500 hover:text-slate-700 whitespace-nowrap py-4 px-1 border-b-2 border-transparent font-medium text-sm">Inclusions & Exclusions</button>
                                    <button class="text-slate-500 hover:text-slate-700 whitespace-nowrap py-4 px-1 border-b-2 border-transparent font-medium text-sm">Hotels</button>
                                </nav>
                            </div>

                            <!-- Itinerary Content -->
                            <div class="py-6 space-y-8">
                                <!-- Day 1 -->
                                <div class="flex gap-4">
                                    <div class="flex flex-col items-center">
                                        <div class="bg-sky-500 text-white rounded-full h-10 w-10 flex items-center justify-center font-bold">1</div>
                                        <div class="w-px h-full bg-slate-200 mt-2"></div>
                                    </div>
                                    <div>
                                        <h3 class="text-lg font-bold">Day 1: Arrival in Cochin & Transfer to Munnar</h3>
                                        <p class="text-slate-600 mt-1">Arrive at Cochin Airport/Railway Station, meet our representative and proceed to Munnar. Enjoy the scenic journey through waterfalls and tea plantations. Check-in to your hotel and relax. Evening at leisure.</p>
                                    </div>
                                </div>
                                <!-- Day 2 -->
                                <div class="flex gap-4">
                                     <div class="flex flex-col items-center">
                                        <div class="bg-sky-500 text-white rounded-full h-10 w-10 flex items-center justify-center font-bold">2</div>
                                        <div class="w-px h-full bg-slate-200 mt-2"></div>
                                    </div>
                                    <div>
                                        <h3 class="text-lg font-bold">Day 2: Munnar Sightseeing</h3>
                                        <p class="text-slate-600 mt-1">After breakfast, proceed for a full day of sightseeing in Munnar. Visit Mattupetty Dam, Echo Point, Kundala Lake, and the Tea Museum. Enjoy the lush green landscapes. Return to the hotel for an overnight stay.</p>
                                    </div>
                                </div>
                                <!-- Day 3 -->
                                <div class="flex gap-4">
                                     <div class="flex flex-col items-center">
                                        <div class="bg-sky-500 text-white rounded-full h-10 w-10 flex items-center justify-center font-bold">3</div>
                                        <div class="w-px h-full bg-slate-200 mt-2"></div>
                                    </div>
                                    <div>
                                        <h3 class="text-lg font-bold">Day 3: Munnar to Thekkady</h3>
                                        <p class="text-slate-600 mt-1">After breakfast, check out and drive to Thekkady, famous for the Periyar National Park. Check-in to your hotel. In the afternoon, enjoy a boat ride on Periyar Lake to spot wildlife. Later, visit a spice plantation. Overnight stay in Thekkady.</p>
                                    </div>
                                </div>
                                 <!-- Day 4 -->
                                <div class="flex gap-4">
                                     <div class="flex flex-col items-center">
                                        <div class="bg-sky-500 text-white rounded-full h-10 w-10 flex items-center justify-center font-bold">4</div>
                                        <div class="w-px h-full bg-slate-200 mt-2"></div>
                                    </div>
                                    <div>
                                        <h3 class="text-lg font-bold">Day 4: Thekkady to Alleppey (Houseboat)</h3>
                                        <p class="text-slate-600 mt-1">After breakfast, proceed to Alleppey, the heart of the Kerala backwaters. Board your private houseboat by noon. Enjoy a delicious lunch as you cruise through the serene canals and villages. Dinner and overnight stay on the houseboat.</p>
                                    </div>
                                </div>
                                <!-- Day 5 -->
                                <div class="flex gap-4">
                                    <div class="flex flex-col items-center">
                                        <div class="bg-sky-500 text-white rounded-full h-10 w-10 flex items-center justify-center font-bold">5</div>
                                         <div class="w-px h-full bg-slate-200 mt-2"></div>
                                    </div>
                                    <div>
                                        <h3 class="text-lg font-bold">Day 5: Alleppey to Cochin</h3>
                                        <p class="text-slate-600 mt-1">Enjoy breakfast on the houseboat, then disembark and drive to Cochin. Check-in to your hotel. Later, go for Cochin sightseeing, including Fort Kochi, the Chinese Fishing Nets, St. Francis Church, and the Dutch Palace. Overnight stay in Cochin.</p>
                                    </div>
                                </div>
                                <!-- Day 6 -->
                                <div class="flex gap-4">
                                    <div class="flex flex-col items-center">
                                        <div class="bg-sky-500 text-white rounded-full h-10 w-10 flex items-center justify-center font-bold">6</div>
                                    </div>
                                    <div>
                                        <h3 class="text-lg font-bold">Day 6: Departure from Cochin</h3>
                                        <p class="text-slate-600 mt-1">After breakfast, check out from the hotel and transfer to Cochin Airport/Railway Station for your onward journey, filled with wonderful memories of your Kerala trip.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Right Column: Booking Widget -->
                    <aside class="w-full lg:w-1/3">
                        <div class="sticky top-24">
                            <div class="bg-white p-6 rounded-lg shadow-md border border-slate-200">
                                <p class="text-sm text-slate-500">Starts from</p>
                                <p class="text-4xl font-bold text-orange-600">₹24,999 <span class="text-lg font-normal text-slate-500">/ person</span></p>
                                
                                <div class="border-t my-4"></div>
                                
                                <div class="space-y-4">
                                    <div>
                                        <label for="travel_date" class="block text-sm font-medium text-slate-600">Travel Date</label>
                                        <input type="date" id="travel_date" class="mt-1 block w-full rounded-md border-slate-300 shadow-sm focus:border-sky-500 focus:ring-sky-500 sm:text-sm">
                                    </div>
                                    <div class="grid grid-cols-2 gap-4">
                                        <div>
                                            <label for="adults" class="block text-sm font-medium text-slate-600">Adults</label>
                                            <input type="number" id="adults" value="2" class="mt-1 block w-full rounded-md border-slate-300 shadow-sm focus:border-sky-500 focus:ring-sky-500 sm:text-sm">
                                        </div>
                                        <div>
                                            <label for="children" class="block text-sm font-medium text-slate-600">Children</label>
                                            <input type="number" id="children" value="0" class="mt-1 block w-full rounded-md border-slate-300 shadow-sm focus:border-sky-500 focus:ring-sky-500 sm:text-sm">
                                        </div>
                                    </div>
                                </div>

                                <div class="border-t my-4"></div>
                                <div class="flex justify-between items-center">
                                    <span class="text-lg font-bold">Estimated Total</span>
                                    <span class="text-2xl font-bold text-slate-800">₹49,998</span>
                                </div>
                                <button class="mt-4 w-full bg-green-500 hover:bg-green-600 text-white font-bold text-lg py-3 px-4 rounded-lg transition-colors">
                                    Book Package
                                </button>
                                <button class="mt-2 w-full border border-slate-300 bg-white hover:bg-slate-50 text-slate-700 font-bold py-2 px-4 rounded-lg transition-colors">
                                    Send Enquiry
                                </button>
                            </div>
                        </div>
                    </aside>
                </div>

            </div>
        </main>
