
        <!-- Main Content -->
        <main class="flex-grow">
            <!-- Hero Search Section -->
            <div class="bg-sky-500">
                <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-12 md:py-16 text-white">
                    <h1 class="text-3xl md:text-4xl font-bold mb-2">Welcome Back, Apex Travels!</h1>
                    <p class="text-lg text-sky-100 mb-8">Ready to create unforgettable journeys? Let's get started.</p>

                    <!-- Search Form -->
                    <div class="bg-white rounded-lg shadow-lg p-4">
                        <!-- Tabs -->
                        <div class="flex border-b border-slate-200 mb-4">
                            <button class="flex items-center space-x-2 py-2 px-4 text-sm font-semibold border-b-2 tab-active transition-colors">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path></svg>
                                <span>Hotels</span>
                            </button>
                             <button class="flex items-center space-x-2 py-2 px-4 text-sm font-semibold text-slate-500 border-b-2 border-transparent hover:text-orange-500 hover:border-orange-500 transition-colors">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 8h14M5 8a2 2 0 110-4h14a2 2 0 110 4M5 8v10a2 2 0 002 2h10a2 2 0 002-2V8m-9 4h4"></path></svg>
                                <span>Packages</span>
                            </button>
                        </div>

                        <!-- Search Inputs -->
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-4">
                            <div class="lg:col-span-2">
                                <label for="destination" class="block text-sm font-medium text-slate-600">Destination or Hotel Name</label>
                                <input type="text" id="destination" placeholder="e.g., Paris, France" class="mt-1 block w-full rounded-md border-slate-300 shadow-sm focus:border-sky-500 focus:ring-sky-500 sm:text-sm text-slate-900">
                            </div>
                            <div>
                                <label for="check-in" class="block text-sm font-medium text-slate-600">Check-in</label>
                                <input type="date" id="check-in" class="mt-1 block w-full rounded-md border-slate-300 shadow-sm focus:border-sky-500 focus:ring-sky-500 sm:text-sm text-slate-900">
                            </div>
                            <div>
                                <label for="check-out" class="block text-sm font-medium text-slate-600">Check-out</label>
                                <input type="date" id="check-out" class="mt-1 block w-full rounded-md border-slate-300 shadow-sm focus:border-sky-500 focus:ring-sky-500 sm:text-sm text-slate-900">
                            </div>
                            <div class="flex items-end">
                                <button class="w-full bg-orange-500 hover:bg-orange-600 text-white font-bold py-2.5 px-4 rounded-md flex items-center justify-center space-x-2 transition-colors">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>
                                    <span>Search</span>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Dashboard Content -->
            <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-10">

                <!-- Quick Stats -->
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-10">
                    <div class="bg-white p-6 rounded-lg shadow-md border border-slate-200">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm font-medium text-slate-500">Total Bookings (Month)</p>
                                <p class="text-3xl font-bold text-slate-800">128</p>
                            </div>
                            <div class="bg-sky-100 text-sky-600 p-3 rounded-full">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"></path></svg>
                            </div>
                        </div>
                    </div>
                    <div class="bg-white p-6 rounded-lg shadow-md border border-slate-200">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm font-medium text-slate-500">Pending Confirmations</p>
                                <p class="text-3xl font-bold text-slate-800">14</p>
                            </div>
                            <div class="bg-amber-100 text-amber-600 p-3 rounded-full">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                            </div>
                        </div>
                    </div>
                    <div class="bg-white p-6 rounded-lg shadow-md border border-slate-200">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm font-medium text-slate-500">Commission Earned (Month)</p>
                                <p class="text-3xl font-bold text-slate-800">₹10,45,000</p>
                            </div>
                            <div class="bg-green-100 text-green-600 p-3 rounded-full">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v.01M12 12v4m0 4a5 5 0 005-5V7a5 5 0 00-5-5S7 3 7 7v4a5 5 0 005 5z"></path></svg>
                            </div>
                        </div>
                    </div>
                     <div class="bg-white p-6 rounded-lg shadow-md border border-slate-200">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm font-medium text-slate-500">New Messages</p>
                                <p class="text-3xl font-bold text-slate-800">3</p>
                            </div>
                            <div class="bg-red-100 text-red-600 p-3 rounded-full">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path></svg>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Featured Holiday Packages -->
                <div class="mb-10">
                    <h2 class="text-2xl font-bold text-slate-800 mb-4">Featured Holiday Packages</h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                        <!-- Package Card 1 -->
                        <div class="bg-white rounded-lg shadow-lg overflow-hidden group">
                            <div class="relative">
                                <img src="https://placehold.co/600x400/38bdf8/ffffff?text=Maldives" alt="Maldives Getaway" class="w-full h-56 object-cover group-hover:scale-105 transition-transform duration-300">
                                <div class="absolute top-4 left-4 bg-orange-500 text-white text-xs font-bold px-3 py-1 rounded-full">Bestseller</div>
                            </div>
                            <div class="p-6">
                                <h3 class="text-xl font-semibold mb-2 text-slate-800">Luxury Maldives Getaway</h3>
                                <p class="text-slate-600 mb-4 text-sm">7 Days / 6 Nights in an overwater bungalow. All-inclusive plan.</p>
                                <div class="flex items-center justify-between">
                                    <p class="text-lg font-bold text-sky-600">₹2,49,999 <span class="text-sm font-normal text-slate-500">/ person</span></p>
                                    <a href="#" class="bg-sky-100 text-sky-700 hover:bg-sky-200 font-semibold px-4 py-2 rounded-md text-sm transition-colors">View Details</a>
                                </div>
                            </div>
                        </div>
                        <!-- Package Card 2 -->
                        <div class="bg-white rounded-lg shadow-lg overflow-hidden group">
                            <div class="relative">
                                <img src="https://placehold.co/600x400/818cf8/ffffff?text=Kyoto" alt="Kyoto Cherry Blossoms" class="w-full h-56 object-cover group-hover:scale-105 transition-transform duration-300">
                                <div class="absolute top-4 left-4 bg-green-500 text-white text-xs font-bold px-3 py-1 rounded-full">New</div>
                            </div>
                             <div class="p-6">
                                <h3 class="text-xl font-semibold mb-2 text-slate-800">Kyoto Cherry Blossom Tour</h3>
                                <p class="text-slate-600 mb-4 text-sm">5 Days / 4 Nights exploring ancient temples and beautiful gardens.</p>
                                <div class="flex items-center justify-between">
                                    <p class="text-lg font-bold text-sky-600">₹1,55,000 <span class="text-sm font-normal text-slate-500">/ person</span></p>
                                    <a href="#" class="bg-sky-100 text-sky-700 hover:bg-sky-200 font-semibold px-4 py-2 rounded-md text-sm transition-colors">View Details</a>
                                </div>
                            </div>
                        </div>
                        <!-- Package Card 3 -->
                        <div class="bg-white rounded-lg shadow-lg overflow-hidden group">
                            <div class="relative">
                               <img src="https://placehold.co/600x400/f472b6/ffffff?text=Swiss+Alps" alt="Swiss Alps Adventure" class="w-full h-56 object-cover group-hover:scale-105 transition-transform duration-300">
                            </div>
                             <div class="p-6">
                                <h3 class="text-xl font-semibold mb-2 text-slate-800">Swiss Alps Adventure</h3>
                                <p class="text-slate-600 mb-4 text-sm">8 Days of hiking, scenic train rides, and exploring charming villages.</p>
                                <div class="flex items-center justify-between">
                                    <p class="text-lg font-bold text-sky-600">₹2,95,000 <span class="text-sm font-normal text-slate-500">/ person</span></p>
                                    <a href="#" class="bg-sky-100 text-sky-700 hover:bg-sky-200 font-semibold px-4 py-2 rounded-md text-sm transition-colors">View Details</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
