<main id="main" class="main">

  <section class="section">
    <div class="row">
      <div class="col-lg-12">

        <div class="card">
          <div class="card-header mb-4">
            <div class="row align-items-center">
              <div class="col-sm-6">
                <h4 class="text-dark mb-0"><?= $title; ?></h4>
              </div>
              <div class="col-sm-6 text-end">
                <button class="btn btn-success rounded add-btn" type="button" onclick="add()">
                  <i class="bi bi-plus"></i> Add <?= $title; ?>
                </button>
              </div>
            </div>
          </div>

          <div class="card-body">
            <!-- Table -->
            <div class="table-responsive" id="tb"></div>
            <!-- End Table -->
          </div>
        </div>

      </div>
    </div>
  </section>

</main><!-- End #main -->

<!-- Add Modal -->
<div class="modal fade" id="addModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">Add <?= $title; ?></h5>
        <button class="btn-close btn-close-white" type="button" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form class="row g-3" id="add-form">

          <div class="col-md-6">
            <label for="property_id">Select Property</label>
            <select class="form-control" id="property_id" name="property_id" required>
              <option value="">Select Property</option>
              <?php foreach ($properties as $property): ?>
                <option value="<?= $property['id']; ?>"><?= $property['name']; ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="col-md-6">
            <label for="room_id">Select Room</label>
            <select class="form-control" id="room_id" name="room_id" required>
              <option value="">Select Room</option>
            </select>
          </div>

          <div class="col-md-12">
            <label for="price">Price</label>
            <input type="number" class="form-control" id="price" name="price" placeholder="Enter Room Price" required>
          </div>

          <div class="col-12 text-end">
            <button type="submit" class="btn btn-primary">Save</button>
            <button type="reset" class="btn btn-outline-danger">Reset</button>
          </div>

        </form>
      </div>
    </div>
  </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-info text-white">
        <h5 class="modal-title">Edit <?= $title; ?></h5>
        <button class="btn-close btn-close-white" type="button" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form class="row g-3" id="edit-form">

          <div class="col-md-6">
            <label for="e_property_id">Select Property</label>
            <select class="form-control" id="e_property_id" name="property_id" required>
              <option value="">Select Property</option>
              <?php foreach ($properties as $property): ?>
                <option value="<?= $property['id']; ?>"><?= $property['name']; ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="col-md-6">
            <label for="e_room_id">Select Room</label>
            <select class="form-control" id="e_room_id" name="room_id" required>
              <option value="">Select Room</option>
            </select>
          </div>

          <div class="col-md-12">
            <label for="e_price">Price</label>
            <input type="number" class="form-control" id="e_price" name="price" required>
          </div>

          <div class="col-12 text-end">
            <input type="hidden" id="e_id" name="id">
            <button type="submit" class="btn btn-primary">Save</button>
            <button type="reset" class="btn btn-outline-danger">Reset</button>
          </div>

        </form>
      </div>
    </div>
  </div>
</div>

<script>
function add() {
  $('#addModal').modal('show'); 
  $('#add-form')[0].reset();
  $('#room_id').html('<option value="">Select Room</option>');
}

$(document).ready(function(){  
  $("#tb").html('<div class="text-center"><img src="loader.gif" style="width:50px;"></div>');
  $('#tb').load('<?= base_url('room_pricing/viewPricing'); ?>');
});

// Populate Rooms on Property Change (Add Modal)
$('#property_id').on('change', function(){
  var propertyId = $(this).val();
  if(propertyId){
    $.post("<?= base_url('room_pricing/getRoomsByProperty'); ?>",{property_id:propertyId}, function(res){
      $('#room_id').html(res);
    });
  }else{
    $('#room_id').html('<option value="">Select Room</option>');
  }
});

// Populate Rooms on Property Change (Edit Modal)
$('#e_property_id').on('change', function(){
  var propertyId = $(this).val();
  if(propertyId){
    $.post("<?= base_url('room_pricing/getRoomsByProperty'); ?>",{property_id:propertyId}, function(res){
      $('#e_room_id').html(res);
    });
  }else{
    $('#e_room_id').html('<option value="">Select Room</option>');
  }
});

// Add Pricing
$("#add-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
    url: "<?= base_url('room_pricing/addPricing'); ?>",
    method: "POST",
    data: new FormData(this),
    cache: false,
    contentType: false,
    processData: false,
    dataType:'json',
    success:function(res){
      enableButton();
      if(res.return){
        $('#addModal').modal('hide'); 
        $('#add-form')[0].reset();
        $('#tb').load('<?= base_url('room_pricing/viewPricing'); ?>');
        toastr.success(res.msg);
      } else {
        toastr.error(res.msg);
      }
    }
  });
});

// Edit Pricing
function editData(id) {
  $.ajax({
    url: "<?= base_url('room_pricing/editPricing'); ?>",
    method: "POST",
    dataType: 'json',
    data: { id: id },
    success: function(res) {
      $("#e_id").val(res.id);
      $("#e_property_id").val(res.property_id).trigger('change');

      // delay loading rooms so that dropdown is populated
      setTimeout(function(){
        $("#e_room_id").val(res.room_id);
      }, 500);

      $("#e_price").val(res.price);
      $('#editModal').modal('show');
    }
  });
}

// Update Pricing
$("#edit-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
    url: "<?= base_url('room_pricing/updatePricing'); ?>",
    method: "POST",
    data: new FormData(this),
    cache: false,
    contentType: false,
    processData: false,
    dataType:'json',
    success:function(res){
      enableButton();
      if(res.return){
        $('#editModal').modal('hide'); 
        $('#edit-form')[0].reset();
        $('#tb').load('<?= base_url('room_pricing/viewPricing'); ?>');
        toastr.success(res.msg);
      } else {
        toastr.error(res.msg);
      }
    }
  });
});
</script>
