<main id="main" class="main">

  <section class="section">
    <div class="row">
      <div class="col-lg-12">

        <div class="card">
          <div class="card-header mb-4">
            <div class="row align-items-center">
              <div class="col-sm-6">
                <h4 class="text-dark mb-0"><?= $title; ?></h4>
              </div>
              <div class="col-sm-6 text-end">
                <button class="btn btn-success rounded add-btn" type="button" onclick="add()">
                  <i class="bi bi-plus"></i> Add <?= $title; ?>
                </button>
              </div>
            </div>
          </div>

          <div class="card-body">
            <!-- Table -->
            <div class="table-responsive" id="tb"></div>
            <!-- End Table -->
          </div>
        </div>

      </div>
    </div>
  </section>

</main><!-- End #main -->

<!-- Add Modal -->
<div class="modal fade" id="addModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">Add <?= $title; ?></h5>
        <button class="btn-close btn-close-white" type="button" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form class="row g-3" id="add-form">

          <div class="col-md-6">
            <label for="property_id">Select Property</label>
            <select class="form-control" id="property_id" name="property_id" required>
              <option value="">Select Property</option>
              <?php foreach ($properties as $property): ?>
                <option value="<?= $property['id']; ?>"><?= $property['name']; ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="col-md-6">
            <label for="name">Room Name</label>
            <input type="text" class="form-control" id="name" name="name" placeholder="Enter Room Name" required>
          </div>

          <div class="col-md-12">
            <label for="description">Description</label>
            <textarea class="form-control" id="description" name="description" rows="3" placeholder="Enter Description"></textarea>
          </div>

          <div class="col-md-4">
            <label for="capacity">Capacity</label>
            <input type="number" class="form-control" id="capacity" name="capacity" placeholder="No. of People" required>
          </div>

          <div class="col-md-4">
            <label for="bed_type">Bed Type</label>
            <select class="form-control" id="bed_type" name="bed_type" required>
              <option value="">Select Bed Type</option>
              <option value="single">Single</option>
              <option value="double">Double</option>
              <option value="queen">Queen</option>
              <option value="king">King</option>
              <option value="twin">Twin</option>
              <option value="bunk">Bunk</option>
            </select>
          </div>

          <div class="col-md-4">
            <label for="size_sqft">Size (sqft)</label>
            <input type="number" class="form-control" id="size_sqft" name="size_sqft" placeholder="e.g. 250">
          </div>

          <div class="col-md-6">
            <label for="status">Status</label>
            <select class="form-control" id="status" name="status">
              <option value="available">Available</option>
              <option value="unavailable">Unavailable</option>
            </select>
          </div>

          <div class="col-12 text-end">
            <button type="submit" class="btn btn-primary">Save</button>
            <button type="reset" class="btn btn-outline-danger">Reset</button>
          </div>

        </form>
      </div>
    </div>
  </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-info text-white">
        <h5 class="modal-title">Edit <?= $title; ?></h5>
        <button class="btn-close btn-close-white" type="button" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form class="row g-3" id="edit-form">

          <div class="col-md-6">
            <label for="e_property_id">Select Property</label>
            <select class="form-control" id="e_property_id" name="property_id" required>
              <option value="">Select Property</option>
              <?php foreach ($properties as $property): ?>
                <option value="<?= $property['id']; ?>"><?= $property['name']; ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="col-md-6">
            <label for="e_name">Room Name</label>
            <input type="text" class="form-control" id="e_name" name="name" required>
          </div>

          <div class="col-md-12">
            <label for="e_description">Description</label>
            <textarea class="form-control" id="e_description" name="description" rows="3"></textarea>
          </div>

          <div class="col-md-4">
            <label for="e_capacity">Capacity</label>
            <input type="number" class="form-control" id="e_capacity" name="capacity" required>
          </div>

          <div class="col-md-4">
            <label for="e_bed_type">Bed Type</label>
            <select class="form-control" id="e_bed_type" name="bed_type" required>
              <option value="single">Single</option>
              <option value="double">Double</option>
              <option value="queen">Queen</option>
              <option value="king">King</option>
              <option value="twin">Twin</option>
              <option value="bunk">Bunk</option>
            </select>
          </div>

          <div class="col-md-4">
            <label for="e_size_sqft">Size (sqft)</label>
            <input type="number" class="form-control" id="e_size_sqft" name="size_sqft">
          </div>

          <div class="col-md-6">
            <label for="e_status">Status</label>
            <select class="form-control" id="e_status" name="status">
              <option value="available">Available</option>
              <option value="unavailable">Unavailable</option>
            </select>
          </div>

          <div class="col-12 text-end">
            <input type="hidden" id="e_id" name="id">
            <button type="submit" class="btn btn-primary">Save</button>
            <button type="reset" class="btn btn-outline-danger">Reset</button>
          </div>

        </form>
      </div>
    </div>
  </div>
</div>

<script>
function add() {
  $('#addModal').modal('show'); 
  $('#add-form')[0].reset();
}

$(document).ready(function(){  
  $("#tb").html('<div class="text-center"><img src="loader.gif" style="width:50px;"></div>');
  $('#tb').load('<?= base_url('room/viewRoom'); ?>');
});

// Add Room
$("#add-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
    url: "<?= base_url('room/addRoom'); ?>",
    method: "POST",
    data: new FormData(this),
    cache: false,
    contentType: false,
    processData: false,
    dataType:'json',
    success:function(res){
      enableButton();
      if(res.return){
        $('#addModal').modal('hide'); 
        $('#add-form')[0].reset();
        $('#tb').load('<?= base_url('room/viewRoom'); ?>');
        toastr.success(res.msg);
      } else {
        toastr.error(res.msg);
      }
    }
  });
});

// Edit Room
function editData(id) {
  $.ajax({
    url: "<?= base_url('room/editRoom'); ?>",
    method: "POST",
    dataType: 'json',
    data: { id: id },
    success: function(res) {
      $("#e_id").val(res.id);
      $("#e_property_id").val(res.property_id);
      $("#e_name").val(res.name);
      $("#e_description").val(res.description);
      $("#e_capacity").val(res.capacity);
      $("#e_bed_type").val(res.bed_type);
      $("#e_size_sqft").val(res.size_sqft);
      $("#e_status").val(res.status);
      $('#editModal').modal('show');
    }
  });
}

// Update Room
$("#edit-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
    url: "<?= base_url('room/updateRoom'); ?>",
    method: "POST",
    data: new FormData(this),
    cache: false,
    contentType: false,
    processData: false,
    dataType:'json',
    success:function(res){
      enableButton();
      if(res.return){
        $('#editModal').modal('hide'); 
        $('#edit-form')[0].reset();
        $('#tb').load('<?= base_url('room/viewRoom'); ?>');
        toastr.success(res.msg);
      } else {
        toastr.error(res.msg);
      }
    }
  });
});
</script>
