<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Website_model extends CI_Model {

    public function get_all_hotels() {
        $this->db->select('p.*, GROUP_CONCAT(DISTINCT a.amenity_name) as amenities, GROUP_CONCAT(DISTINCT po.policy_text) as policies');
        $this->db->from('properties p');
        $this->db->join('property_amenities a', 'p.id = a.property_id', 'left');
        $this->db->join('property_policies po', 'p.id = po.property_id', 'left');
        $this->db->group_by('p.id');
        return $this->db->get()->result_array();
    }

    // Get single hotel
    public function get_hotel_by_id($id) {
        $this->db->select('p.*, GROUP_CONCAT(DISTINCT a.amenity_name) as amenities, GROUP_CONCAT(DISTINCT po.policy_text) as policies, GROUP_CONCAT(DISTINCT po.policy_type) as policy_types');
        $this->db->from('properties p');
        $this->db->join('property_amenities a', 'p.id = a.property_id', 'left');
        $this->db->join('property_policies po', 'p.id = po.property_id', 'left');
        $this->db->where('p.id', $id);
        $this->db->group_by('p.id');
        return $this->db->get()->row_array();
    }

    // Get rooms of a hotel
    public function get_rooms_by_hotel($property_id) {
        $this->db->select('r.*, GROUP_CONCAT(DISTINCT ra.amenity_name) as amenities, rp.price');
        $this->db->from('rooms r');
        $this->db->join('room_amenities ra', 'r.id = ra.room_id', 'left');
        $this->db->join('room_pricing rp', 'r.id = rp.room_id', 'left');
        $this->db->where('r.property_id', $property_id);
        $this->db->group_by('r.id');
        return $this->db->get()->result_array();
    }

    // Fetch inquiry cart data
    public function get_inquiry_cart($agent_id) {
        $this->db->select('ic.id as cart_id, r.id as room_id, r.name, r.description, rp.price');
        $this->db->from('inquiry_cart ic');
        $this->db->join('rooms r', 'ic.room_id = r.id', 'left');
        $this->db->join('room_pricing rp', 'r.id = rp.room_id', 'left');
        $this->db->where('ic.agent_id', $agent_id);
        return $this->db->get()->result_array();
    }

    // Generate booking summary HTML
    public function generate_booking_summary_html($agent_id) {
        $html='<h2 class="text-xl font-bold mb-4">Booking Summary</h2>';
        $cart = $this->get_inquiry_cart($agent_id);
        if(empty($cart)) return '<h2 class="text-xl font-bold mb-4">Booking Summary</h2><p class="text-center text-gray-500">No rooms added yet.</p>';

        $subtotal = 0;
        $html.= '<div class="space-y-4">';
        foreach($cart as $room){
            $subtotal += $room['price'];
            $html .= '<div class="flex justify-between items-start border-b pb-2">
                        <div>
                            <p class="font-semibold">'.htmlspecialchars($room['name']).'</p>
                            <p class="text-sm text-slate-500">'.htmlspecialchars($room['description']).'</p>
                        </div>
                        <div class="text-right">
                            <p class="font-semibold">₹'.$room['price'].'</p>
                            <button class="text-xs text-red-500 hover:underline" onclick="removeFromInquiry('.$room['cart_id'].','.$room['room_id'].')">Remove</button>
                        </div>
                    </div>';
        }
        // $taxes = round($subtotal * 0.18); // 18% tax example
        // $total = $subtotal + $taxes;
        $total = $subtotal;

        $html .= '</div>
                  <div class="border-t my-4"></div>
                  <div class="space-y-2">
                      <div class="flex justify-between text-slate-600">
                          <span>Subtotal</span>
                          <span>₹'.$subtotal.'</span>
                      </div>
                      <div class="flex justify-between text-xl font-bold pt-2">
                          <span>Total Price</span>
                          <span>₹'.$total.'</span>
                      </div>
                  </div>
                  <button class="mt-6 w-full bg-green-500 hover:bg-green-600 text-white font-bold py-3 px-4 rounded-lg transition-colors" onclick="submitInquiry()">Submit Inquiry</button>';
        return $html;
    }

}
