<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Inquiry_model extends CI_Model {

public function getInquiryResultData() {
    $this->db->select("i.*, a.fullname as agent_name, a.email, a.mobile");
    $this->db->from("inquiries i");
    $this->db->join("users a", "a.id = i.agent_id", "left");
    $this->db->order_by("i.id", "DESC");
    $inquiries = $this->db->get()->result_array();

    foreach ($inquiries as &$inq) {
        // Fetch rooms with stored inquiry price
        $this->db->select("ir.id, ir.price, r.name as room_name, GROUP_CONCAT(DISTINCT ra.amenity_name) as amenities");
        $this->db->from("inquiry_rooms ir");
        $this->db->join("rooms r", "r.id = ir.room_id", "left");
        $this->db->join("room_amenities ra", "r.id = ra.room_id", "left");
        $this->db->where("ir.inquiry_id", $inq['id']);
        $this->db->group_by("ir.id");
        $inq['rooms'] = $this->db->get()->result_array();
    }

    return $inquiries;
}




}
