<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Website extends CI_Controller {

    public function __construct() {
        parent::__construct();

        // Check if agent is logged in
        if (!$this->session->userdata('logged_in') || $this->session->userdata('log_user') != 'agent') {
            // Not logged in or not an agent, redirect to login page
            redirect(base_url());
        }
    }

    private function header_and_footer($page, $data = []) {
        $this->load->view('website/includes/header', $data);
        $this->load->view('website/'.$page, $data);
        $this->load->view('website/includes/footer');
    }

    public function index() {
        $data['title'] = 'Home';       
        $page = 'index';
        $this->header_and_footer($page, $data);
    }



    public function hotels()
    {
        $data['title'] = 'Hotels';

        $data['hotels'] = $this->website_model->get_all_hotels();

        $page = 'hotels';
        $this->header_and_footer($page, $data);
    }

    // Hotel details page
    public function hotel_details($property_id) {
        // Get hotel info
        $data['hotel'] = $this->website_model->get_hotel_by_id($property_id);

        // Get rooms for this hotel
        $data['rooms'] = $this->website_model->get_rooms_by_hotel($property_id);

        $data['title'] = $data['hotel']['name'] ?? 'Hotel Details';

        // Load header, footer and view
        $this->header_and_footer('hotel_details', $data);
    }


    public function bookings() {
        $data['title'] = 'Bookings';       
        $page = 'bookings';
        $this->header_and_footer($page, $data);
    }

    public function packages() {
        $data['title'] = 'Packages';       
        $page = 'packages';
        $this->header_and_footer($page, $data);
    }


    public function reports() {
        $data['title'] = 'Reports';       
        $page = 'reports';
        $this->header_and_footer($page, $data);
    }















    //Inquiry
    public function add_to_inquiry()
    {
        $agent_id = $this->session->userdata('id');
        $room_id  = $this->input->post('room_id');

        if(empty($room_id)) {
            echo json_encode(['return' => false, 'msg' => 'Invalid Room']);
            return;
        }

        // Check if room already added
        $exists = $this->model->getRowData('inquiry_cart',['agent_id'=>$agent_id,'room_id'=>$room_id]);
        if($exists) {
            echo json_encode(['return' => false, 'msg' => 'Room already added']);
            return;
        }

        // Add room to temporary inquiry
        $data = [
            'agent_id' => $agent_id,
            'room_id'  => $room_id,
        ];

        $insert_id = $this->model->add('inquiry_cart',$data);

        if($insert_id){
            // Get updated booking summary HTML
            // $rooms = $this->website_model->get_inquiry_cart($agent_id);
            $summary_html = $this->website_model->generate_booking_summary_html($agent_id);
            echo json_encode(['return' => true, 'summary_html' => $summary_html]);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Failed to add room']);
        }
    }

    public function get_booking_summary() {
        $agent_id = $this->session->userdata('id');
        $summary_html = $this->website_model->generate_booking_summary_html($agent_id);
        echo json_encode(['return' => true, 'summary_html' => $summary_html]);
    }

    public function remove_from_inquiry($cart_id){
        $agent_id = $this->session->userdata('id');
        $this->db->delete('inquiry_cart', ['id'=>$cart_id,'agent_id'=>$agent_id]);
        $summary_html = $this->website_model->generate_booking_summary_html($agent_id);
        echo json_encode(['return'=>true,'summary_html'=>$summary_html]);
    }

public function submit_inquiry() {
    $agent_id = $this->session->userdata('id');

    // Get all rooms from cart
    $cart_rooms = $this->website_model->get_inquiry_cart($agent_id);

    if(empty($cart_rooms)) {
        echo json_encode(['return'=>false,'msg'=>'No rooms in inquiry']);
        return;
    }

    // Calculate total amount
    $total_amount = 0;
    foreach($cart_rooms as $room){
        $total_amount += $room['price'];
    }

    // Insert into main inquiry table
    $inquiry_data = [
        'agent_id' => $agent_id,
        'status' => 'pending',
        'total_amount' => $total_amount
    ];
    $inquiry_id = $this->model->add('inquiries', $inquiry_data);

    if(!$inquiry_id){
        echo json_encode(['return'=>false,'msg'=>'Failed to create inquiry']);
        return;
    }

    // Insert rooms into inquiry_rooms
    foreach($cart_rooms as $room){
        $this->model->add('inquiry_rooms', [
            'inquiry_id' => $inquiry_id,
            'room_id' => $room['room_id'],
            'price' => $room['price']
        ]);
    }

    // Clear cart
    $this->db->where('agent_id', $agent_id)->delete('inquiry_cart');

    echo json_encode(['return'=>true,'msg'=>'Inquiry submitted successfully']);
}


    
}
