<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Settings extends CI_Controller {

	public function __construct()
    {
        parent::__construct();

        $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn(){
        $is_logged_in = $this->session->userdata('logged_in');
        if(!isset($is_logged_in) || $is_logged_in!==TRUE && $this->session->userdata('role') != 'admin')
        {
            redirect(base_url());
            exit;
        }
    }
	public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
		$this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }
	
	public function index()
    {
        $data['title'] = 'Settings';
		$data['data'] = $this->model->getRowData('settings',[]);
        $page = 'settings/index';
        $this->header_and_footer($page, $data);
    }
	public function updateSettings()
    {
        if(isset($_POST))
		{
			$array = array(
				'phone' => $_POST['phone'],
				'email' => $_POST['email'],
				'address' => $_POST['address'],
				'terms_condition' => $_POST['terms_condition'],
				'privacy_policy' => $_POST['privacy_policy'],
			);
			$this->model->edit('settings',$array,['id'=>1]);
		}
    }
   
	}
