<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Room_pricing extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        // $this->isAdminLoggedIn();
    }

    public function isAdminLoggedIn()
    {
        // if($this->session->userdata('role') !== 'admin' && $this->session->userdata('role') !== 'staff')
        // {
        //     redirect(base_url('dashboard'));
        //     exit;
        // }
    }

    public function header_and_footer($page, $data)
    {
        $this->load->view('includes/header',$data);
        $this->load->view('includes/sidebar',$data);
        $this->load->view($page);
        $this->load->view('includes/footer');
    }

    public function index()
    {
        $data['title']      = 'Room Pricing';
        $data['properties'] = $this->model->getResultData('properties', []); 
        $data['rooms']      = $this->model->getResultData('rooms', []);
        $page = 'room_pricing/index';
        $this->header_and_footer($page, $data);
    }

    public function addPricing()
    {
        $countData = $this->model->countData('room_pricing', [
            'room_id'     => $_POST['room_id']
        ]);

        if ($countData > 0) {
            echo json_encode(['return' => false, 'msg' => 'Pricing already exists for this room']);
            return;
        }

        $array = [
            'room_id'     => $_POST['room_id'],
            'price'       => $_POST['price'],
        ];

        if ($this->model->add('room_pricing', $array)) {
            $pricing_id = $this->db->insert_id();

            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $pricing_id,
                'add',
                'Room Pricing'
            );

            echo json_encode(['return' => true, 'msg' => 'Pricing Added Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Failed to add pricing']);
        }
    }

    public function viewPricing()
    {
        $data['list'] = $this->room_model->getRoomPricingResultData(); 
        $this->load->view('room_pricing/tb', $data);
    }

    public function editPricing()
    {
        $data = $this->model->getRowData('room_pricing',['id'=>$_POST['id']]);

        $response = [
            'id'          => $_POST['id'],
            'room_id'     => $data['room_id'],
            'price'       => $data['price'],
        ];

        echo json_encode($response);
    }

    public function updatePricing()
    {
        if (!isset($_POST['id']) || empty($_POST['id'])) {
            echo json_encode(['return' => false, 'msg' => 'Invalid Request']);
            return;
        }

        $id = $_POST['id'];

        $array = [
            'property_id' => $_POST['property_id'],
            'room_id'     => $_POST['room_id'],
            'price'       => $_POST['price'],
        ];

        if ($this->model->edit('room_pricing', $array, ['id' => $id])) {
            $this->createLog(
                $this->session->userdata('id'),
                $this->session->userdata('role'),
                $id,
                'edit',
                'Room Pricing'
            );

            echo json_encode(['return' => true, 'msg' => 'Pricing Updated Successfully']);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Update Failed']);
        }
    }

    public function getRoomsByProperty()
    {
        $property_id = $this->input->post('property_id');
        $rooms = $this->model->getResultData('rooms', ['property_id' => $property_id]);

        $options = '<option value="">Select Room</option>';
        foreach($rooms as $room){
            $options .= '<option value="'.$room['id'].'">'.$room['name'].'</option>';
        }
        echo $options;
    }

}
