<script>
    $(document).ready(function() {
      if($('#usertype').val() == 'admin'){
        $('#mytable').DataTable({
          dom: 'Bfrtip',
          aaSorting: [[0, 'desc']],
        buttons: [
        //  { extend: 'pdf', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3, 4]}, },
          //{ extend: 'excel', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3, 4]}, },
         // { extend: 'csv', className: 'btn-primary',exportOptions: {columns: [ 0, 1, 2, 3, 4]}, },
        ]
        });
      }else{
        $('#mytable').DataTable({
          aaSorting: [[0, 'desc']],
        });
      }
        if($('#usertype').val() == 'staff')
        {
            $('.edit-btn').remove();
            $('.add-btn').remove();
        }
    } );
</script>
<table class="table table-bordered table-hover align-middle">
    <thead class="table-dark">
        <tr>
            <th>#</th>
            <th>Property</th>
            <th>Agent</th>
            <th>Email</th>
            <th>Mobile</th>
            <th>Inquiry Date</th>
            <th>Rooms</th>
            <th>Total Amount</th>
            <th>Status</th>
        </tr>
    </thead>
    <tbody>
        <?php $i=1; foreach($list as $val): ?>
        <tr>
            <td><?= $i++; ?></td>
            <td>
                <div class="font-bold"><?= $val['property_name'] ?></div>
                <div class="text-xs text-slate-500"><?= $val['property_address']; ?></div>
            </td>
            <td><?= $val['agent_name']; ?></td>
            <td><?= $val['email']; ?></td>
            <td><?= $val['mobile']; ?></td>
            <td><?= date("d-m-Y", strtotime($val['created'])); ?></td>
            
            <!-- Room Details -->
            <td>
                <?php if(!empty($val['rooms'])): ?>
                    <ul class="list-unstyled mb-0">
                        <?php foreach($val['rooms'] as $room): ?>
                            <li class="mb-2">
                                <strong><?= $room['room_name']; ?></strong><br>
                                <span class="text-muted small">₹<?= number_format($room['price'],2); ?></span><br>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php else: ?>
                    <span class="text-danger">No rooms</span>
                <?php endif; ?>
            </td>

            <!-- Total from inquiry table -->
            <td>
                <strong>₹<?= number_format($val['total_amount'], 2); ?></strong>
            </td>

            <!-- Status -->
            <td>
                <?php
                    $status_colors = [
                        'pending' => 'bg-warning text-dark',
                        'confirmed' => 'bg-success text-white',
                        'cancelled' => 'bg-danger text-white',
                        'payment_received' => 'bg-info text-white'
                    ];
                    $status_class = $status_colors[$val['status']] ?? 'bg-secondary text-white';
                ?>
                <span class="badge <?= $status_class ?>"><?= ucfirst($val['status'] ?? 'pending'); ?></span>
                <select class="status-dropdown form-select form-select-sm" data-id="<?= $val['id']; ?>">
                    <option value="pending" <?= $val['status'] == 'pending' ? 'selected' : ''; ?>>Pending</option>
                    <option value="confirmed" <?= $val['status'] == 'confirmed' ? 'selected' : ''; ?>>Confirmed</option>
                    <option value="cancelled" <?= $val['status'] == 'cancelled' ? 'selected' : ''; ?>>Cancelled</option>
                    <option value="payment_received" <?= $val['status'] == 'payment_received' ? 'selected' : ''; ?>>Payment Received</option>
                </select>
            </td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>




<script>
function changeStatus(id,type)
{
  if (confirm('Are you sure?') == true) {
    var table = 'users';
    var column = 'is_suspended';
    $.ajax({
        url: "<?= base_url('Dashboard/Status'); ?>",
        method: "POST",
        data: {
            id:id,
            type:type,
            table:table,
            column:column,
            module:'role'
        },
        dataType:'json',
        success:function(res){
          if(res.return)
          {
            $("#tb").load("<?= base_url('users/viewUser/') ?>")
            toastr.success(res.msg);
          }
          else
          {          
            toastr.error(res.msg);
          }
        }
    });
  }
};

$(document).ready(function(){
    $('.status-dropdown').change(function(){
        var inquiryId = $(this).data('id');
        var newStatus = $(this).val();

        $.ajax({
            url: "<?php echo base_url('inquiry/update_inquiry_status'); ?>",
            method: "POST",
            data: {
                id: inquiryId,
                status: newStatus
            },
            dataType:'json',
            success:function(res){
              if(res.return)
              {
                $('#tb').load('<?= base_url('inquiry/viewInquiry'); ?>');
                toastr.success(res.msg);
              }
              else
              {
                toastr.error(res.msg);
              }
              
            }
        });
    });
});
</script>