<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Website extends CI_Controller {

    public function __construct() {
        parent::__construct();

        // Check if agent is logged in
        if (!$this->session->userdata('logged_in') || $this->session->userdata('log_user') != 'agent') {
            // Not logged in or not an agent, redirect to login page
            redirect(base_url());
        }
    }

    private function header_and_footer($page, $data = []) {
        $data['agent'] = $this->user_model->getUserRowData($this->session->userdata('id'));
        $this->load->view('website/includes/header', $data);
        $this->load->view('website/'.$page, $data);
        $this->load->view('website/includes/footer');
    }

public function index() 
{
    $data['title'] = 'Home';     

    // 🧳 All packages for dashboard view
    $data['packages'] = $this->website_model->getPackagesResultData();	  

    $agent_id = $this->session->userdata('id');

    // 📦 Package inquiries count (for this agent)
    $data['package_inquiry_count'] = count(
        $this->inquiry_model->getPackageInquiryResultData(['i.agent_id' => $agent_id])
    );

    // 🏨 Hotel inquiries count (for this agent)
    $data['hotel_inquiry_count'] = count(
        $this->inquiry_model->getInquiryResultData(['i.agent_id' => $agent_id])
    );

    // ✈️ Custom package inquiries count (for this agent)
    $data['custom_inquiry_count'] = count(
        $this->inquiry_model->getCustomInquiryResultData(['ci.agent_id' => $agent_id])
    );


    // ⏳ Pending confirmations (all types)
    $hotel_pending_count   = $this->model->countData('inquiries', ['status' => 'pending']);
    $package_pending_count = $this->model->countData('package_inquiries', ['status' => 'pending']);
    $custom_pending_count  = $this->model->countData('custom_inquiries', ['status' => 'pending']);

    $data['pending_confirmation'] = $hotel_pending_count + $package_pending_count + $custom_pending_count;	 


    // 💰 Total Business Value (sum of all "payment_received")
    $hotel_total   = $this->model->getSum('inquiries', 'total_amount', ['status' => 'payment_received']);
    $package_total = $this->model->getSum('package_inquiries', 'price', ['status' => 'payment_received']);
    $custom_total  = $this->model->getSum('custom_inquiries', 'total', ['status' => 'payment_received']);

    $data['total_business_value'] = $hotel_total + $package_total + $custom_total;


    // 🔹 Load dashboard page
    $page = 'index';
    $this->header_and_footer($page, $data);
}




    // public function hotels()
    // {
    //     $data['title'] = 'Hotels';

    //     $data['hotels'] = $this->website_model->get_all_hotels();

    //     $page = 'hotels';
    //     $this->header_and_footer($page, $data);
    // }
    public function hotels()
    {
        $data['title'] = 'Hotels';

        $destination = $this->input->post('destination');
        $checkin = $this->input->post('checkin');
        $checkout = $this->input->post('checkout');

        $data['checkin'] = $this->input->post('checkin');
        $data['checkout'] = $this->input->post('checkout');

        if (!empty($destination) || (!empty($checkin) && !empty($checkout))) {
            $data['hotels'] = $this->website_model->searchHotels($destination, $checkin, $checkout);
        } else {
            $data['hotels'] = $this->website_model->get_all_hotels();
        }

        $page = 'hotels';
        $this->header_and_footer($page, $data);
    }


    // Hotel details page
    // public function hotel_details($property_id) {
    //     // Get hotel info
    //     $data['hotel'] = $this->website_model->get_hotel_by_id($property_id);

    //     // Get rooms for this hotel
    //     $data['rooms'] = $this->website_model->get_rooms_by_hotel($property_id);

    //     $data['title'] = $data['hotel']['name'] ?? 'Hotel Details';

    //     // Load header, footer and view
    //     $this->header_and_footer('hotel_details', $data);
    // }
    public function hotel_details($property_id)
    {
        $checkin  = $this->input->post('checkin');
        $checkout = $this->input->post('checkout');

        $data['hotel'] = $this->website_model->get_hotel_by_id($property_id);
        $data['rooms'] = $this->website_model->get_rooms_by_hotel($property_id, $checkin, $checkout);

        $data['checkin']  = $checkin;
        $data['checkout'] = $checkout;
        $data['title']    = $data['hotel']['name'] ?? 'Hotel Details';

        $this->header_and_footer('hotel_details', $data);
    }



    public function inquiries() {
        $data['title'] = 'Inquiries';   
        $agent_id = $this->session->userdata('id');
		$data['list'] = $this->inquiry_model->getInquiryResultData(['i.agent_id'=>$agent_id]);	
		$data['package_inquiries'] = $this->inquiry_model->getPackageInquiryResultData(['i.agent_id'=>$agent_id]);	
		$data['custom_inquiries'] = $this->inquiry_model->getCustomInquiryResultData(['ci.agent_id'=>$agent_id]);				  
        $page = 'inquiries';
        $this->header_and_footer($page, $data);
    }

public function packages() {
    $data['title'] = 'Packages';       

    // Fetch destinations for dropdown
    $data['destinations'] = $this->model->getResultData('destinations', ['is_disable' => 0]);	

    // Get selected destination from POST
    $selectedDestination = $this->input->post('destination');

    // Pass selected destination to model
    if (!empty($selectedDestination)) {
        $data['packages'] = $this->website_model->getPackagesResultData($selectedDestination);
    } else {
        $data['packages'] = $this->website_model->getPackagesResultData();	
    }

    $page = 'packages';
    $this->header_and_footer($page, $data);
}

public function package_details($id)
{
    $data['title'] = 'Package Details';

    // Get package by ID
    $data['package_data'] = $this->website_model->getPackageById($id);
    // echo "<pre>";print_r($data['package_data']);die();

    // Decode itinerary (multi-line string)
    $data['itinerary'] = $this->_parse_itinerary($data['package_data']['itinerary']);

    // Get inclusion list (if available)
    $data['inclusions'] = $data['package_data']['inclusions'] ?? [];


    // Get hotels (comma-separated list)
    $data['hotels'] = explode(",", trim($data['package_data']['hotels'] ?? ''));

    $page = 'package_details';
    $this->header_and_footer($page, $data);
}

public function get_price_by_date()
{
    $type = $this->input->post('type');       // 'package' or 'room'
    $id = $this->input->post('id');           // package_id or room_id
    $travel_date = $this->input->post('date');

    $price = get_price_by_travel_date($type, $id, $travel_date, 0)['price_with_markup'];

    echo json_encode(['status' => true,'price' => $price]);
}


// helper to parse itinerary into structured array
private function _parse_itinerary($itinerary_text)
{
   $lines = preg_split('/\r\n|\r|\n/', trim($itinerary_text ?? ''));

    $itinerary = [];
    $day = null;
    $desc = '';

    foreach ($lines as $line) {
        if (preg_match('/^Day\s*(\d+):\s*(.*)$/i', trim($line), $matches)) {
            if ($day !== null) {
                $itinerary[] = ['day' => $day, 'title' => $title, 'desc' => trim($desc)];
            }
            $day = $matches[1];
            $title = $matches[2];
            $desc = '';
        } else {
            $desc .= ' ' . trim($line);
        }
    }

    if ($day !== null) {
        $itinerary[] = ['day' => $day, 'title' => $title, 'desc' => trim($desc)];
    }

    return $itinerary;
}




    public function reports() {
        $data['title'] = 'Reports';       
        $page = 'reports';
        $this->header_and_footer($page, $data);
    }















    //Inquiry
    public function add_to_inquiry()
    {
        $agent_id = $this->session->userdata('id');
        $room_id  = $this->input->post('room_id');

        if(empty($room_id)) {
            echo json_encode(['return' => false, 'msg' => 'Invalid Room']);
            return;
        }

        // Check if room already added
        $exists = $this->model->getRowData('inquiry_cart',['agent_id'=>$agent_id,'room_id'=>$room_id]);
        if($exists) {
            echo json_encode(['return' => false, 'msg' => 'Room already added']);
            return;
        }

        // Add room to temporary inquiry
        $data = [
            'agent_id' => $agent_id,
            'room_id'  => $room_id,
            'price'  => get_current_month_prices('room', $room_id)['markup_prices'][0],
        ];

        $insert_id = $this->model->add('inquiry_cart',$data);

        if($insert_id){
            // Get updated booking summary HTML
            // $rooms = $this->website_model->get_inquiry_cart($agent_id);
            $summary_html = $this->website_model->generate_booking_summary_html($agent_id);
            echo json_encode(['return' => true, 'summary_html' => $summary_html]);
        } else {
            echo json_encode(['return' => false, 'msg' => 'Failed to add room']);
        }
    }

    public function get_booking_summary() {
        $agent_id = $this->session->userdata('id');
        $summary_html = $this->website_model->generate_booking_summary_html($agent_id);
        echo json_encode(['return' => true, 'summary_html' => $summary_html]);
    }

    public function remove_from_inquiry($cart_id){
        $agent_id = $this->session->userdata('id');
        $this->db->delete('inquiry_cart', ['id'=>$cart_id,'agent_id'=>$agent_id]);
        $summary_html = $this->website_model->generate_booking_summary_html($agent_id);
        echo json_encode(['return'=>true,'summary_html'=>$summary_html]);
    }

public function submit_inquiry() {
    $agent_id = $this->session->userdata('id');

    // Get all rooms from cart
    $cart_rooms = $this->website_model->get_inquiry_cart($agent_id);

    if(empty($cart_rooms)) {
        echo json_encode(['return'=>false,'msg'=>'No rooms in inquiry']);
        return;
    }

    // Calculate total amount
    $total_amount = 0;
    foreach($cart_rooms as $room){
        $total_amount += $room['price'];
    }

    // Insert into main inquiry table
    $inquiry_data = [
        'agent_id' => $agent_id,
        'status' => 'pending',
        'total_amount' => $total_amount
    ];
    if($this->model->add('inquiries', $inquiry_data)){
        $inquiry_id = $this->db->insert_id();
    }

    if(!$inquiry_id){
        echo json_encode(['return'=>false,'msg'=>'Failed to create inquiry']);
        return;
    }

    // Insert rooms into inquiry_rooms
    foreach($cart_rooms as $room){
        $this->model->add('inquiry_rooms', [
            'inquiry_id' => $inquiry_id,
            'room_id' => $room['room_id'],
            'price' => $room['price']
        ]);
    }

    // Clear cart
    $this->db->where('agent_id', $agent_id)->delete('inquiry_cart');

    echo json_encode(['return'=>true,'msg'=>'Inquiry submitted successfully']);
}









public function send_package_inquiry()
{
    $package_id = $this->input->post('package_id');
    $travel_date = $this->input->post('travel_date');
    $adults = $this->input->post('adults') ?? 1;
    $children = $this->input->post('children') ?? 1;
    $travelers = $this->input->post('travelers') ?? 1;
    $message = $this->input->post('message');
    $price = str_replace(',', '', $this->input->post('price'));
    $price = (float) $price; // optional, ensures it's numeric

    // Replace with logged-in agent ID
    $agent_id = $this->session->userdata('id') ?? 0;

    if(!$agent_id) {
        echo json_encode(['status'=>'error', 'message'=>'Please login first']);
        return;
    }

    if(!$package_id) {
        echo json_encode(['status'=>'error', 'message'=>'Invalid package']);
        return;
    }

    $data = [
        'agent_id' => $agent_id,
        'package_id' => $package_id,
        'travel_date' => $travel_date ?: null,
        'adults' => $adults,
        'children' => $children,
        'travelers' => $travelers,
        'message' => $message,
        'price' => $price,
        'status' => 'pending'
    ];
    // echo "<pre>";print_r($data);die();


    if($this->model->add('package_inquiries',$data)){
        echo json_encode(['status'=>'success']);
    } else {
        echo json_encode(['status'=>'error', 'message'=>'Failed to save inquiry']);
    }
}



/*AGENT PROFILE */
    public function agent_profile() {
        $data['title'] = 'Agent Profile';       
        $data['agent'] = $this->user_model->getUserRowData($this->session->userdata('id'));
        // echo "<pre>";print_r($data['agent']);die();
        $page = 'agent_profile';
        $this->header_and_footer($page, $data);
    }




    public function update_profile()
    {
        $id = $this->input->post('id');
        $fullname = $this->input->post('fullname');
        $email = $this->input->post('email');
        $mobile = $this->input->post('mobile');
        $dob = $this->input->post('dob');

        $data = [
            'fullname' => $fullname,
            'email' => $email,
            'mobile' => $mobile,
            'dob' => $dob
        ];

        // Update agent details
        $this->model->edit('users', $data, ['id' => $id]);

    

        echo json_encode(['status' => true, 'message' => 'Profile updated successfully']);
    }

    public function upload_logo()
    {
        $agency_id = $this->input->post('agency_id');
        $user_id   = $this->session->userdata('id');

        // Upload new logo (no resize)
        $upload = upload_file('company_logo', 'company_logo', false);

        if ($upload['status']) {

            // Get the current user record (to find existing company_logo)
            $user = $this->model->getRowData('users', ['id' => $user_id]);

            // Delete old logo if it exists
            if (!empty($user['company_logo'])) {
                $old_path = FCPATH . 'assets/uploads/' . $user['company_logo'];
                if (file_exists($old_path)) {
                    unlink($old_path);
                }
            }

            // Update new logo path in DB
            $this->model->edit(
                'users',
                ['company_logo' => $upload['file_path']],
                ['id' => $user_id]
            );

            echo json_encode([
                'status' => true,
                'file'   => base_url('assets/uploads/' . $upload['file_path'])
            ]);

        } else {
            echo json_encode([
                'status' => false,
                'error'  => $upload['error']
            ]);
        }
    }


    public function upload_profile_pic()
    {
        $user_id = $this->session->userdata('id');

        // Upload new profile photo (no resize)
        $upload = upload_file('profile_pic', 'profile_pics', false);

        if ($upload['status']) {
            // Get old profile photo if any
            $old = $this->model->getRowData('users', ['id' => $user_id]);
            if (!empty($old['profile_pic'])) {
                $old_file = FCPATH . 'assets/uploads/' . $old['profile_pic'];
                if (file_exists($old_file)) {
                    unlink($old_file);
                }
            }

            // Save new photo path in DB
            $this->model->edit('users', ['profile_pic' => $upload['file_path']], ['id' => $user_id]);

            echo json_encode([
                'status' => true,
                'file' => base_url('assets/uploads/' . $upload['file_path'])
            ]);
        } else {
            echo json_encode([
                'status' => false,
                'error' => $upload['error']
            ]);
        }
    }




    //CUSTOM PACKAGES
    public function custom_packages() {
        $data['title'] = 'Custom Packages';       
        $data['destinations'] = $this->model->getResultData('destinations',['is_disable'=>0]);
        $page = 'custom_packages';
        $this->header_and_footer($page, $data);
    }

    public function get_cities_by_destination()
    {
        $destination_id = $this->input->post('destination_id');

        $this->db->select('cities.id, cities.name');
        $this->db->from('destination_cities');
        $this->db->join('cities', 'cities.id = destination_cities.city_id', 'left');
        $this->db->where('destination_cities.destination_id', $destination_id);
        $this->db->order_by('cities.name', 'ASC');
        $result = $this->db->get()->result_array();

        echo json_encode($result);
    }

    public function get_hotels_by_city()
    {
        $city_id = $this->input->post('city_id');

        $this->db->select('id, name');
        $this->db->from('properties');
        $this->db->where('city', $city_id);
        $this->db->order_by('name', 'ASC');
        $result = $this->db->get()->result_array();

        echo json_encode($result);
    }

    public function get_rooms_by_hotel()
    {
        $property_id = $this->input->post('property_id');
        $rooms = $this->db->get_where('rooms', ['property_id' => $property_id])->result_array();
        echo json_encode($rooms);
    }

    public function get_room_price()
    {
        $room_id = $this->input->post('room_id');
        $start_date = $this->input->post('start_date');

        $priceData = get_price_by_travel_date('room', $room_id, $start_date);
        echo json_encode(['price_with_markup' => $priceData['price_with_markup']]);
    }


    public function save_custom_inquiry()
    {
        $package_name   = $this->input->post('package_name');
        $destination_id = $this->input->post('destination_id');
        $start_date     = $this->input->post('start_date');
        $end_date       = $this->input->post('end_date');
        $no_of_adults   = $this->input->post('no_of_adults');
        $no_of_children = $this->input->post('no_of_children');
        $subtotal       = $this->input->post('subtotal');
        $total          = $this->input->post('total');
        $items          = json_decode($this->input->post('items'), true);

        //  Calculate no_of_days automatically
        $no_of_days = 0;
        if (!empty($items)) {
            foreach ($items as $item) {
                $no_of_days += (int)$item['nights'];
            }
        }

        //  Save main inquiry        
        $subtotal_clean = (float) str_replace([',', ' '], '', $subtotal);
        $total_clean    = (float) str_replace([',', ' '], '', $total);

        $data = [
            'agent_id'        => $this->session->userdata('id') ?? null,
            'package_name'   => $package_name,
            'destination_id' => $destination_id,
            'start_date'     => $start_date,
            'end_date'       => $end_date,
            'no_of_days'     => $no_of_days,
            'no_of_adults'   => $no_of_adults,
            'no_of_children' => $no_of_children,
            'subtotal' => $subtotal_clean,
            'total'    => $total_clean,
            'status'         => 'pending'
        ];
        // echo "<pre>";print_r($data);die();

        $this->db->insert('custom_inquiries', $data);
        $inquiry_id = $this->db->insert_id();

        if (!empty($items)) {
            foreach ($items as $i => $item) {
                $row = [
                    'inquiry_id'      => $inquiry_id,
                    'day_no'          => $i + 1,
                    'city_id'         => $item['city_id'],
                    'city_name'       => $item['city_name'],
                    'hotel_id'        => $item['hotel_id'],
                    'hotel_name'      => $item['hotel_name'],
                    'room_id'         => $item['room_id'],
                    'room_name'       => $item['room_name'],
                    'price_per_night' => $item['room_price'],
                    'nights'          => $item['nights'],
                    'total_price'     => $item['total_price']
                ];
                $this->db->insert('custom_inquiry_itinerary', $row);
            }
        }

        echo json_encode(['status' => 'success', 'inquiry_id' => $inquiry_id]);
    }



}
