<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Login - Nihar B2B Portal</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
  <style>
    body { font-family: 'Inter', sans-serif; }
  </style>
</head>
<body class="bg-slate-50 text-slate-800">

  <div class="min-h-screen flex items-center justify-center bg-gradient-to-br from-sky-50 to-slate-100 px-4 sm:px-6 lg:px-8">
    <div class="max-w-md w-full space-y-8">

      <div>
        <!-- Logo -->
        <div class="flex items-center justify-center space-x-2">
          <svg class="h-10 w-10 text-sky-500" xmlns="http://www.w3.org/2000/svg" fill="none" 
            viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" 
              d="M12.75 3.03v.568c0 .334.148.65.405.864l1.068.89c.442.369.535 
              1.01.216 1.49l-.51.766a2.25 2.25 0 01-1.161.886l-.143.048a1.107 
              1.107 0 00-.57 1.664c.369.555.169 1.307-.427 
              1.605L9 13.125l.423 1.059a.956.956 0 01-1.652.928l-.679-.906a1.125 
              1.125 0 00-1.906.172L4.5 15.75l-.612.153M12.75 
              3.031a9 9 0 00-8.862 12.872M12.75 3.031a9 9 0 016.69 
              14.036m0 0l-.177.177a2.25 2.25 0 00-.998 
              1.787l-2.096 5.239a.75.75 0 001.123.82l5.239-2.096a2.25 
              2.25 0 001.787-.998l.177-.177M18 5.25a.75.75 0 
              00-1.06-1.06L15.75 5.25l1.19-1.192a.75.75 0 
              00-1.06-1.06l-1.192 1.19-1.192-1.19a.75.75 0 
              00-1.06 1.06l1.19 1.192-1.19 1.192a.75.75 0 
              001.06 1.06l1.192-1.19 1.192 1.19a.75.75 0 
              001.06-1.06L16.81 5.25l1.19-1.19z" />
          </svg>
          <span class="text-3xl font-bold text-slate-700">Nihar</span>
        </div>
        <h2 class="mt-6 text-center text-2xl font-bold text-slate-800">
          Agent Portal Login
        </h2>
        <p class="mt-2 text-center text-sm text-slate-600">
          Welcome back! Please enter your details.
        </p>
      </div>

      <!-- Alerts -->
      <div id="error" class="hidden text-red-600 text-center font-semibold bg-red-100 p-2 rounded-md text-sm"></div>
      <div id="success" class="hidden text-green-600 text-center font-semibold bg-green-100 p-2 rounded-md text-sm">
        Login Successful...
      </div>

      <!-- Login Form -->
      <div class="bg-white p-8 rounded-lg shadow-lg border border-slate-200">
        <form class="space-y-6" id="login">
          <div>
            <label for="email" class="block text-sm font-medium text-slate-700">Email address</label>
            <div class="mt-1">
              <input id="email" name="email" type="email" required
                class="appearance-none block w-full px-3 py-2 border border-slate-300 rounded-md shadow-sm placeholder-slate-400 
                focus:outline-none focus:ring-sky-500 focus:border-sky-500 sm:text-sm"
              >
            </div>
          </div>

          <div>
            <label for="password" class="block text-sm font-medium text-slate-700">Password</label>
            <div class="mt-1">
              <input id="password" name="password" type="password" required
                class="appearance-none block w-full px-3 py-2 border border-slate-300 rounded-md shadow-sm placeholder-slate-400 
                focus:outline-none focus:ring-sky-500 focus:border-sky-500 sm:text-sm"
                placeholder="••••••••">
            </div>
          </div>

          <div>
            <button type="submit" id="sign-in-button"
              class="w-full flex justify-center py-2 px-4 border border-transparent text-sm font-medium rounded-md 
              text-white bg-sky-600 hover:bg-sky-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-sky-500">
              <span id="sign-in">Sign in</span>
              <span id="sign-in-loader" class="hidden">Checking...</span>
            </button>
          </div>
        </form>
      </div>

      <p class="mt-2 text-center text-xs text-slate-500">
        &copy; <?= date('Y'); ?> Nihar B2B Solutions. All rights reserved.
      </p>
    </div>
  </div>

  <!-- jQuery -->
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>

  <script>
  $('#login').submit(function(event) {
    event.preventDefault();
    var email = $('#email').val();
    var pass = $('#password').val();

    $.ajax({
      type: "POST",
      url : "<?= base_url('web_auth/agentLoginSubmit');?>", // same controller as sample
      dataType: "JSON",
      data : "email="+email+"&pass="+pass,
      cache : false,
    //   beforeSend: function() {
    //     $("#sign-in").hide();
    //     $("#sign-in-loader").removeClass("hidden");
    //     $("#sign-in-button").attr("disabled",true);       
    //   }, 
      success: function(res) {
        if(res[0] == '0') {
          $("#error").hide();
          $("#success").show();
          $("#sign-in-loader").text("Redirecting...");
          setTimeout(function(){
            window.location = "<?= base_url('agent-dashboard');?>";
          },2000);
        } else {
          $("#error").html(res[1]).show();
          $("#success").hide();
          $("#sign-in").show();
          $("#sign-in-loader").addClass("hidden");
          $("#sign-in-button").removeAttr("disabled"); 
        }
      },
      error: function (jqXHR, exception) {
        var msg = '';
        if (jqXHR.status === 0) msg = 'Not connect.\n Verify Network.';
        else if (jqXHR.status == 404) msg = 'Requested page not found. [404]';
        else if (jqXHR.status == 500) msg = 'Internal Server Error [500].';
        else if (exception === 'parsererror') msg = 'Requested JSON parse failed.';
        else if (exception === 'timeout') msg = 'Time out error.';
        else if (exception === 'abort') msg = 'Ajax request aborted.';
        else msg = 'Uncaught Error.\n' + jqXHR.responseText;

        $("#error").html(msg).show();
      },
    });
  });
  </script>
</body>
</html>
