<main id="main" class="main">

  <section class="section">
    <div class="row">
      <div class="col-lg-12">

        <div class="card">
          <div class="card-header mb-4">
            <div class="row align-items-center">
              <div class="col-sm-6">
                <h4 class="text-dark mb-0"><?= $title; ?></h4>
              </div>
              <div class="col-sm-6 text-end">
                <button class="btn btn-success rounded add-btn" type="button" onclick="add()">
                  <i class="bi bi-plus"></i> Add <?= $title; ?>
                </button>
              </div>
            </div>
          </div>

          <div class="card-body">
            <div class="table-responsive" id="tb"></div>
          </div>
        </div>

      </div>
    </div>
  </section>

</main>

<!-- Add Modal -->
<div class="modal fade" id="addModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">Add <?= $title; ?></h5>
        <button class="btn-close btn-close-white" type="button" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form class="row g-3" id="add-form">

          <!-- Package Selection -->
          <div class="col-md-12">
            <label for="package_id" class="form-label fw-semibold">Select Package</label>
            <select class="form-control" id="package_id" name="package_id" required>
              <option value="">Select Package</option>
              <?php foreach ($packages as $pkg): ?>
                <option value="<?= $pkg['id']; ?>"><?= $pkg['title']; ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <hr class="my-3">

          <!-- Dynamic Date-Price Rows -->
          <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-2">
              <h6 class="mb-0 fw-semibold">Set Prices for Date Ranges</h6>
              <button type="button" class="btn btn-sm btn-outline-success" id="addRowBtn">
                <i class="bi bi-plus-circle"></i> Add More
              </button>
            </div>

            <div class="table-responsive">
              <table class="table table-bordered align-middle" id="priceTable">
                <thead class="table-light">
                  <tr>
                    <th style="width:60%">Date Range</th>
                    <th style="width:30%">Price</th>
                    <th style="width:10%">Action</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <td>
                      <select class="form-control" name="price_date_id[]" required>
                        <option value="">Select Date Range</option>
                        <?php foreach ($price_dates as $pd): ?>
                          <option value="<?= $pd['id']; ?>">
                            <?= $pd['name']; ?> (<?= date('d M', strtotime($pd['from_date'])) . ' - ' . date('d M Y', strtotime($pd['to_date'])); ?>)
                          </option>
                        <?php endforeach; ?>
                      </select>
                    </td>
                    <td><input type="number" class="form-control" name="price[]" placeholder="Enter price" required></td>
                    <td class="text-center">
                      <button type="button" class="btn btn-sm btn-outline-danger removeRowBtn"><i class="bi bi-trash"></i></button>
                    </td>
                  </tr>
                </tbody>
              </table>
            </div>
          </div>

          <div class="col-12 text-end">
            <button type="submit" class="btn btn-primary">Save</button>
            <button type="reset" class="btn btn-outline-danger">Reset</button>
          </div>

        </form>
      </div>
    </div>
  </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-info text-white">
        <h5 class="modal-title">Edit <?= $title; ?></h5>
        <button class="btn-close btn-close-white" type="button" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form class="row g-3" id="edit-form">

          <!-- Package Selection -->
          <div class="col-md-12">
            <label for="e_package_id" class="form-label fw-semibold">Select Package</label>
            <select class="form-control" id="e_package_id" name="package_id" required>
              <option value="">Select Package</option>
              <?php foreach ($packages as $pkg): ?>
                <option value="<?= $pkg['id']; ?>"><?= $pkg['title']; ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <hr class="my-3">

          <!-- Dynamic Date-Price Rows -->
          <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-2">
              <h6 class="mb-0 fw-semibold">Set Prices for Date Ranges</h6>
              <button type="button" class="btn btn-sm btn-outline-success" id="addPriceRow">
                <i class="bi bi-plus-circle"></i> Add More
              </button>
            </div>

            <div class="table-responsive">
              <table class="table table-bordered align-middle" id="editPriceTable">
                <thead class="table-light">
                  <tr>
                    <th style="width:60%">Date Range</th>
                    <th style="width:30%">Price</th>
                    <th style="width:10%">Action</th>
                  </tr>
                </thead>
                <tbody id="priceRows"></tbody>
              </table>
            </div>
          </div>

          <div class="col-12 text-end mt-3">
            <input type="hidden" id="e_id" name="id">
            <button type="submit" class="btn btn-primary">Save</button>
            <button type="reset" class="btn btn-outline-danger">Reset</button>
          </div>

        </form>
      </div>
    </div>
  </div>
</div>

<script>
function add() {
  $('#addModal').modal('show'); 
  $('#add-form')[0].reset();
}

$(document).ready(function(){  
  $("#tb").html('<div class="text-center"><img src="loader.gif" style="width:50px;"></div>');
  $('#tb').load('<?= base_url('package_pricing/viewPricing'); ?>');
});

// Add Pricing
$("#add-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
    url: "<?= base_url('package_pricing/addPricing'); ?>",
    method: "POST",
    data: new FormData(this),
    cache: false,
    contentType: false,
    processData: false,
    dataType:'json',
    success:function(res){
      enableButton();
      if(res.return){
        $('#addModal').modal('hide'); 
        $('#add-form')[0].reset();
        $('#tb').load('<?= base_url('package_pricing/viewPricing'); ?>');
        toastr.success(res.msg);
      } else {
        toastr.error(res.msg);
      }
    }
  });
});

function editData(id) {
  $.ajax({
    url: "<?= base_url('package_pricing/editPricing'); ?>",
    method: "POST",
    dataType: 'json',
    data: { id: id },
    success: function(res) {
      $("#e_package_id").val(res.package_id);
      $("#priceRows").html('');

      if(res.prices.length > 0){
        res.prices.forEach(function(p){
          addPriceRow(p.price_date_id, p.price, p.pricing_id);
        });
      } else {
        addPriceRow();
      }

      $('#editModal').modal('show');
    }
  });
}

function addPriceRow(price_date_id = '', price = '', pricing_id = ''){
  var options = `<?php foreach ($price_dates as $pd): ?>
    <option value="<?= $pd['id']; ?>"><?= $pd['name']; ?> (<?= date('d M', strtotime($pd['from_date'])) ?> - <?= date('d M Y', strtotime($pd['to_date'])) ?>)</option>
  <?php endforeach; ?>`;

  var row = `
  <tr class="price-row">
    <input type="hidden" name="pricing_id[]" value="${pricing_id}">
    <td>
      <select class="form-control" name="price_date_id[]" required>
        <option value="">Select Date Range</option>
        ${options}
      </select>
    </td>
    <td>
      <input type="number" class="form-control" name="price[]" placeholder="Enter Price" value="${price}" required>
    </td>
    <td class="text-center">
      <button type="button" class="btn btn-sm btn-outline-danger removeRow"><i class="bi bi-trash"></i></button>
    </td>
  </tr>`;

  $("#priceRows").append(row);
  if(price_date_id){
    $("#priceRows tr:last select[name='price_date_id[]']").val(price_date_id);
  }
}

$("#addPriceRow").click(function(){ addPriceRow(); });
$(document).on('click', '.removeRow', function(){ $(this).closest('tr.price-row').remove(); });

// Update Pricing
$("#edit-form").submit(function(e){
  e.preventDefault();
  disableButton();
  $.ajax({
    url: "<?= base_url('package_pricing/updatePricing'); ?>",
    method: "POST",
    data: new FormData(this),
    cache: false,
    contentType: false,
    processData: false,
    dataType:'json',
    success:function(res){
      enableButton();
      if(res.return){
        $('#editModal').modal('hide'); 
        $('#edit-form')[0].reset();
        $('#tb').load('<?= base_url('package_pricing/viewPricing'); ?>');
        toastr.success(res.msg);
      } else {
        toastr.error(res.msg);
      }
    }
  });
});

// Add new row in Add Modal
$('#addRowBtn').click(function() {
  const newRow = `
    <tr>
      <td>
        <select class="form-control" name="price_date_id[]" required>
          <option value="">Select Date Range</option>
          <?php foreach ($price_dates as $pd): ?>
            <option value="<?= $pd['id']; ?>">
              <?= $pd['name']; ?> (<?= date('d M', strtotime($pd['from_date'])) . ' - ' . date('d M Y', strtotime($pd['to_date'])); ?>)
            </option>
          <?php endforeach; ?>
        </select>
      </td>
      <td><input type="number" class="form-control" name="price[]" placeholder="Enter price" required></td>
      <td class="text-center">
        <button type="button" class="btn btn-sm btn-outline-danger removeRowBtn"><i class="bi bi-trash"></i></button>
      </td>
    </tr>`;
  $('#priceTable tbody').append(newRow);
});

$(document).on('click', '.removeRowBtn', function() {
  $(this).closest('tr').remove();
});
</script>
