<main id="main" class="main">

  <section class="section">
    <div class="row">
      <div class="col-lg-12">

        <div class="card">
          <div class="card-header mb-4">
            <div class="row align-items-center">
              <div class="col-sm-6">
                <h4 class="text-dark mb-0"><?= $title; ?></h4>
              </div>
              <div class="col-sm-6 text-end">
                <button class="btn btn-success rounded add-btn" type="button" onclick="add()">
                  <i class="bi bi-plus"></i> Add <?= $title; ?>
                </button>
              </div>
            </div>
          </div>

          <div class="card-body">
            <!-- Table -->
            <div class="table-responsive" id="tb"></div>
            <!-- End Table -->
          </div>
        </div>

      </div>
    </div>
  </section>

</main><!-- End #main -->

<!-- Add Modal -->
<div class="modal fade" id="addModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">Add <?= $title; ?></h5>
        <button class="btn-close btn-close-white" type="button" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form class="row g-3" id="add-form" enctype="multipart/form-data">

          <!-- Destination Dropdown -->
          <div class="col-md-12">
            <label for="destination_id">Destination</label>
            <select class="form-control" id="destination_id" name="destination_id" required>
              <option value="">Select Destination</option>
              <?php foreach($destinations as $d) { ?>
                <option value="<?= $d['id']; ?>"><?= htmlspecialchars($d['name']); ?></option>
              <?php } ?>
            </select>
          </div>

          <!-- Title -->
          <div class="col-md-12">
            <label for="title">Package Title</label>
            <input type="text" class="form-control" id="title" name="title" placeholder="Enter Package Title" required>
          </div>

          <!-- Short Description -->
          <div class="col-md-12">
            <label for="short_description">Short Description</label>
            <textarea class="form-control" id="short_description" name="short_description" rows="2" placeholder="Enter Short Description"></textarea>
          </div>

          <!-- Duration -->
          <div class="col-md-6">
            <label for="duration_nights">Nights</label>
            <input type="number" class="form-control" id="duration_nights" name="duration_nights" placeholder="e.g. 3">
          </div>

          <div class="col-md-6">
            <label for="duration_days">Days</label>
            <input type="number" class="form-control" id="duration_days" name="duration_days" placeholder="e.g. 4">
          </div>



          <!-- Image Upload -->
          <!-- <div class="col-md-6">
            <label for="image">Package Image</label>
            <input type="file" class="form-control" id="image" name="image" accept="image/*">
          </div> -->

          <!-- Theme Selection -->
          <div class="col-md-12">
            <label for="themes" class="form-label">Select Themes</label>
            <div class="d-flex flex-wrap gap-3">
              <?php if (!empty($themes)) { ?>
                <?php foreach ($themes as $t) { ?>
                  <div class="form-check">
                    <input 
                      class="form-check-input" 
                      type="checkbox" 
                      name="themes[]" 
                      id="theme_<?= $t['id']; ?>" 
                      value="<?= $t['id']; ?>">
                    <label class="form-check-label" for="theme_<?= $t['id']; ?>">
                      <?= htmlspecialchars($t['name']); ?>
                    </label>
                  </div>
                <?php } ?>
              <?php } else { ?>
                <p class="text-muted">No themes available</p>
              <?php } ?>
            </div>
          </div>

          <!-- Itinerary / Day-wise Details -->
          <div class="col-md-12 mt-3">
            <label for="itinerary" class="form-label">Day-wise Itinerary / Details</label>
            <textarea name="itinerary" id="itinerary" class="form-control" rows="6" placeholder="Enter day-wise details here..."></textarea>
          </div>
          
          <!-- Hotels -->
          <div class="col-md-12 mt-3">
            <label for="itinerary" class="form-label">Hotels</label>
            <textarea name="hotels" id="hotels" class="form-control" rows="6"></textarea>
          </div>

          <!-- Submit Buttons -->
          <div class="col-12 text-end">
            <button type="submit" class="btn btn-primary">Save</button>
            <button type="reset" class="btn btn-outline-danger">Reset</button>
          </div>

        </form>


      </div>
    </div>
  </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-info text-white">
        <h5 class="modal-title">Edit <?= $title; ?></h5>
        <button class="btn-close btn-close-white" type="button" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form class="row g-3" id="edit-form">

          <!-- Destination Dropdown -->
          <div class="col-md-12">
            <label for="destination_id">Destination</label>
            <select class="form-control" id="e_destination_id" name="destination_id" required>
              <option value="">Select Destination</option>
              <?php foreach($destinations as $d) { ?>
                <option value="<?= $d['id']; ?>"><?= htmlspecialchars($d['name']); ?></option>
              <?php } ?>
            </select>
          </div>

          <!-- Title -->
          <div class="col-md-12">
            <label for="title">Package Title</label>
            <input type="text" class="form-control" id="e_title" name="title" placeholder="Enter Package Title" required>
          </div>

          <!-- Short Description -->
          <div class="col-md-12">
            <label for="short_description">Short Description</label>
            <textarea class="form-control" id="e_short_description" name="short_description" rows="2" placeholder="Enter Short Description"></textarea>
          </div>

          <!-- Duration -->
          <div class="col-md-6">
            <label for="duration_nights">Nights</label>
            <input type="number" class="form-control" id="e_duration_nights" name="duration_nights" placeholder="e.g. 3">
          </div>

          <div class="col-md-6">
            <label for="duration_days">Days</label>
            <input type="number" class="form-control" id="e_duration_days" name="duration_days" placeholder="e.g. 4">
          </div>


          <!-- Image Upload -->
          <!-- <div class="col-md-6">
            <label for="image">Package Image</label>
            <input type="file" class="form-control" id="e_image" name="image" accept="image/*">
            <div class="mt-2">
              <img id="preview_edit" src="#" alt="Current Image" style="max-width:120px; display:none; border-radius:6px;">
            </div>
          </div> -->

          
          <!-- Theme Selection -->
          <div class="col-md-12">
            <label for="themes" class="form-label">Select Themes</label>
            <div class="d-flex flex-wrap gap-3">
              <?php if (!empty($themes)) { ?>
                <?php foreach ($themes as $t) { ?>
                  <div class="form-check">
                    <input 
                      class="form-check-input" 
                      type="checkbox" 
                      name="themes[]" 
                      id="e_theme_<?= $t['id']; ?>" 
                      value="<?= $t['id']; ?>">
                    <label class="form-check-label" for="theme_<?= $t['id']; ?>">
                      <?= htmlspecialchars($t['name']); ?>
                    </label>
                  </div>
                <?php } ?>
              <?php } else { ?>
                <p class="text-muted">No themes available</p>
              <?php } ?>
            </div>
          </div>

          <!-- Itinerary / Day-wise Details -->
          <div class="col-md-12 mt-3">
            <label for="itinerary" class="form-label">Day-wise Itinerary / Details</label>
            <textarea name="itinerary" id="e_itinerary" class="form-control" rows="6" placeholder="Enter day-wise details here..."></textarea>
          </div>

          <!-- Hotels -->
          <div class="col-md-12 mt-3">
            <label for="itinerary" class="form-label">Hotels</label>
            <textarea name="hotels" id="e_hotels" class="form-control" rows="6"></textarea>
          </div>


          <div class="col-12 text-end">
            <input type="hidden" id="e_id" name="id">
            <button type="submit" class="btn btn-primary">Save</button>
            <button type="reset" class="btn btn-outline-danger">Reset</button>
          </div>

        </form>
      </div>
    </div>
  </div>
</div>

        <!-- Image Modal -->
        <div class="modal fade modal-bookmark" id="packageImageModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Package Images</h5>
                <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <div class="row">
                  <div class="col-md-12 mb-5">
                    <form class="form-bookmark" id="package-image-form">
                      <input type="file" name="package_image" id="package_image" required>
                      <button type="submit" class="btn btn-primary btn-sm">Add</button>
                      <input type="hidden" name="package_id" id="package_id">
                    </form>
                  </div>
                  <div class="col-md-12">
                    <table class="table table-bordered">
                      <thead>
                        <tr>
                          <th scope="col">S.No.</th>
                          <th scope="col">Image</th>
                          <th scope="col">Action</th>
                        </tr>
                      </thead>
                      <tbody class="images">
                        
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
<script>
function add() {
  $('#addModal').modal('show');
  $('#add-form')[0].reset();
  $('#preview_add').attr('src', '').hide(); // clear image preview
}

$(document).ready(function() {
  $("#tb").html('<div class="text-center"><img src="loader.gif" style="width:50px;"></div>');
  $('#tb').load('<?= base_url('package/viewPackage'); ?>');
});


// ================================
// ADD PACKAGE
// ================================
$("#add-form").submit(function(e) {
  e.preventDefault();
  disableButton();
  $.ajax({
    url: "<?= base_url('package/addPackage'); ?>",
    method: "POST",
    data: new FormData(this),
    cache: false,
    contentType: false,
    processData: false,
    dataType: 'json',
    success: function(res) {
      enableButton();
      if (res.return) {
        $('#addModal').modal('hide');
        $('#add-form')[0].reset();
        $('#tb').load('<?= base_url('package/viewPackage'); ?>');
        toastr.success(res.msg);
      } else {
        toastr.error(res.msg);
      }
    }
  });
});


// ================================
// EDIT PACKAGE
// ================================
function editData(id) {
  $.ajax({
    url: "<?= base_url('package/editPackage'); ?>",
    method: "POST",
    dataType: "json",
    data: { id: id },
    success: function (res) {
      if (!res || res.return === false) {
        alert(res.msg || "Something went wrong!");
        return;
      }

      // Basic fields
      $("#e_id").val(res.id);
      $("#e_destination_id").val(res.destination_id);
      $("#e_title").val(res.title);
      $("#e_short_description").val(res.short_description);
      $("#e_duration_nights").val(res.duration_nights);
      $("#e_duration_days").val(res.duration_days);
      $("#e_hotels").val(res.hotels);

      // // Image preview
      // if (res.image && res.image !== "") {
      //   $("#preview_edit")
      //     .attr("src", "<?= base_url('assets/uploads/'); ?>" + res.image)
      //     .show();
      // } else {
      //   $("#preview_edit").attr("src", "").hide();
      // }

      // Uncheck all theme checkboxes first
      $('input[name="themes[]"]').prop("checked", false);

      // Check the themes returned from backend
      if (res.themes && Array.isArray(res.themes)) {
        res.themes.forEach(function (themeId) {
          $("#e_theme_" + themeId).prop("checked", true);
        });
      }

      // Set itinerary (simple textarea)
      $("#e_itinerary").val(res.itinerary || "");

      // Show modal
      $("#editModal").modal("show");
    },
    error: function () {
      alert("Error fetching package data.");
    },
  });
}



// ================================
// UPDATE PACKAGE
// ================================
$("#edit-form").submit(function(e) {
  e.preventDefault();
  disableButton();
  $.ajax({
    url: "<?= base_url('package/updatePackage'); ?>",
    method: "POST",
    data: new FormData(this),
    cache: false,
    contentType: false,
    processData: false,
    dataType: 'json',
    success: function(res) {
      enableButton();
      if (res.return) {
        $('#editModal').modal('hide');
        $('#edit-form')[0].reset();
        $('#tb').load('<?= base_url('package/viewPackage'); ?>');
        toastr.success(res.msg);
      } else {
        toastr.error(res.msg);
      }
    }
  });
});


// ================================
// IMAGE PREVIEW HANDLERS
// ================================
$("#image").on("change", function() {
  readURL(this, '#preview_add');
});

$("#e_image").on("change", function() {
  readURL(this, '#preview_edit');
});

function readURL(input, previewSelector) {
  if (input.files && input.files[0]) {
    const reader = new FileReader();
    reader.onload = function(e) {
      $(previewSelector).attr('src', e.target.result).show();
    };
    reader.readAsDataURL(input.files[0]);
  }
}
</script>


<script>
  // Initialize WYSIWYG editor
  $(document).ready(function() {
    $('#itinerary').summernote({
      height: 200,
      placeholder: 'Example: Day 1 - Arrival and Check-in...',
    });
  });

function packageImage(id)
{
  $.ajax({
      url: "<?php echo base_url('package/packageImage'); ?>",
      method: "POST",
      data: {
        package_id:id
      },
      success:function(res){
        $("#package_id").val(id);
        $('.images').html(res);
      }
  });
};


$("#package-image-form").submit(function(e){
  e.preventDefault();
  disableButton();
  var formData = new FormData(this);
  $.ajax({
      url: "<?php echo base_url('package/addPackageImage'); ?>",
      method: "POST",
      data:  formData,
      cache: false,
      contentType: false,
      processData: false,
      dataType:'json',
      success:function(res){
        enableButton();
        if(res.return)
        {
          $('#package_image').val('');
          packageImage($('#package_id').val());
          toastr.success(res.msg);
        }
        else
        {
          toastr.error(res.msg);
        }
      }
  });
});
function makePackageCoverImage(image_id,package_id)
{
  if (confirm('Are you sure?') == true) {
    $.ajax({
        url: "<?php echo base_url('package/makePackageCoverImage'); ?>",
        method: "POST",
        data:  {
          'image_id':image_id,
          'package_id':package_id,
        },
        dataType:'json',
        success:function(res){
          if(res.return)
          {
            packageImage(package_id);
            toastr.success(res.msg);
          }
          else
          {
            toastr.error(res.msg);
          }
        }
    });
  }
}
function packageImage(id)
{
  $.ajax({
      url: "<?php echo base_url('package/packageImage'); ?>",
      method: "POST",
      data: {
        package_id:id
      },
      success:function(res){
        $("#package_id").val(id);
        $('.images').html(res);
      }
  });
};
function deletePackageImage(image_id,package_id)
{
  if (confirm('Are you sure?') == true) {
    $.ajax({
        url: "<?php echo base_url('package/deletePackageImage'); ?>",
        method: "POST",
        data:  {
          'image_id':image_id
        },
        dataType:'json',
        success:function(res){
          if(res.return)
          {
            packageImage(package_id);
            toastr.success(res.msg);
          }
          else
          {
            toastr.error(res.msg);
          }
        }
    });
  }
}
</script>